/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.logging;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import net.sf.eBus.util.TimerEvent;
import net.sf.eBus.util.TimerTask;
import net.sf.eBus.util.TimerTaskListener;

public final class CalendarFileHandler
extends StreamHandler
implements TimerTaskListener {
    public static final String DEFAULT_DIRECTORY = ".";
    public static final String DEFAULT_BASENAME = "Logger";
    public static final String DEFAULT_DATE_FORMAT = "yyyyMMdd";
    public static final Level DEFAULT_LEVEL = Level.INFO;
    public static final String DEFAULT_EXTENSION = "log";
    public static final int MIN_DAYS_KEPT = 0;
    public static final int MAX_DAYS_KEPT = 96;
    public static final int DEFAULT_DAYS_KEPT = 10;
    private static final String TIMEOUT_METHOD_NAME = "handleTimeout";
    private static final String BASENAME_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.basename";
    private static final String PATTERN_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.pattern";
    private static final String EXTENSION_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.extension";
    private static final String DAYS_KEPT_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.days_kept";
    private static final String FORMATTER_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.formatter";
    private static final String LEVEL_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.level";
    private static Timer sTimer = new Timer("LogRollTimer", true);
    private final String mDirectory;
    private final String mBasename;
    private final String mDateFormat;
    private final String mExtension;
    private final int mDaysKept;
    private TimerTask mLogRollTimer;

    public CalendarFileHandler() throws IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this(CalendarFileHandler.getProperty(BASENAME_KEY, DEFAULT_BASENAME), CalendarFileHandler.getProperty(PATTERN_KEY, DEFAULT_DATE_FORMAT), CalendarFileHandler.getProperty(EXTENSION_KEY, DEFAULT_EXTENSION), CalendarFileHandler.getDefaultDaysKept());
    }

    public CalendarFileHandler(String baseName, String datePattern, String extension, int daysKept) throws IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (Strings.isNullOrEmpty((String)baseName)) {
            throw new IllegalArgumentException("baseName is either null or an empty string");
        }
        if (Strings.isNullOrEmpty((String)datePattern)) {
            throw new IllegalArgumentException("datePattern is either null or an empty string");
        }
        if (Strings.isNullOrEmpty((String)extension)) {
            throw new IllegalArgumentException("extension is either null or an empty string");
        }
        this.mDirectory = CalendarFileHandler.dirname(baseName);
        this.mBasename = CalendarFileHandler.basename(baseName);
        this.mDateFormat = datePattern;
        this.mExtension = extension;
        this.mDaysKept = daysKept;
        this.mLogRollTimer = new TimerTask(this);
        Formatter formatter = CalendarFileHandler.createFormatter();
        if (formatter != null) {
            this.setFormatter(formatter);
        }
        this.setLevel(this.getDefaultLevel());
        OutputStream logStream = CalendarFileHandler.openLogStream(this.mDirectory, this.mBasename, this.mDateFormat, this.mExtension);
        if (logStream != null) {
            this.setOutputStream(logStream);
        }
        this.deleteLogFiles();
        this.startMidnightTimer(this.mLogRollTimer);
    }

    @Override
    public void handleTimeout(TimerEvent task) {
        OutputStream logStream = CalendarFileHandler.openLogStream(this.mDirectory, this.mBasename, this.mDateFormat, this.mExtension);
        LogRecord logRecord = new LogRecord(Level.INFO, "Rolling log file.");
        logRecord.setSourceClassName(CalendarFileHandler.class.getName());
        logRecord.setSourceMethodName(TIMEOUT_METHOD_NAME);
        this.publish(logRecord);
        this.deleteLogFiles();
        if (logStream != null) {
            this.setOutputStream(logStream);
        }
        logRecord = new LogRecord(Level.INFO, "Finished rolling log file.");
        logRecord.setSourceClassName(CalendarFileHandler.class.getName());
        logRecord.setSourceMethodName(TIMEOUT_METHOD_NAME);
        this.publish(logRecord);
        this.mLogRollTimer = new TimerTask(this);
        this.startMidnightTimer(this.mLogRollTimer);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        super.publish(record);
        super.flush();
    }

    private void deleteLogFiles() {
        Calendar calendar = Calendar.getInstance();
        File directory = new File(this.mDirectory);
        calendar.add(5, this.mDaysKept * -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        LogFileFilter logFilter = new LogFileFilter(directory, this.mBasename + DEFAULT_DIRECTORY, this.mDateFormat, DEFAULT_DIRECTORY + this.mExtension, calendar.getTime());
        File[] logFiles = directory.listFiles(logFilter);
        if (logFiles != null && logFiles.length > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Deleted the following log files:");
            for (int index = 0; index < logFiles.length; ++index) {
                buffer.append("\n    ").append(logFiles[index].getName());
                try {
                    Path path = FileSystems.getDefault().getPath(logFiles[index].getPath(), new String[0]);
                    Files.delete(path);
                    continue;
                }
                catch (IOException jex) {
                    buffer.append(" failed");
                }
            }
            LogRecord logRecord = new LogRecord(Level.INFO, buffer.toString());
            logRecord.setSourceClassName(CalendarFileHandler.class.getName());
            logRecord.setSourceMethodName(TIMEOUT_METHOD_NAME);
            this.publish(logRecord);
        }
    }

    private static OutputStream openLogStream(String directory, String basename, String datePattern, String extension) {
        FileOutputStream retval = null;
        try {
            File logFile = new File(CalendarFileHandler.generateLogFilename(directory, basename, datePattern, extension));
            retval = new FileOutputStream(logFile, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retval;
    }

    private static String generateLogFilename(String directory, String basename, String datePattern, String extension) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
        return String.format("%s%c%s.%s.%s", directory, Character.valueOf(File.separatorChar), basename, formatter.format(new Date()), extension);
    }

    private static int getDefaultDaysKept() {
        String value = CalendarFileHandler.getProperty(DAYS_KEPT_KEY, String.valueOf(10));
        int retval = 10;
        if (!(Strings.isNullOrEmpty((String)value) || (retval = Integer.parseInt(value)) >= 0 && retval <= 96)) {
            throw new IllegalArgumentException(String.format("%,d is either < %d or > %d", retval, 0, 96));
        }
        return retval;
    }

    private static Formatter createFormatter() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String value = CalendarFileHandler.getProperty(FORMATTER_KEY, null);
        Formatter retval = null;
        if (!Strings.isNullOrEmpty((String)value)) {
            Class<?> fc = Class.forName(value);
            Constructor<?> ctor = fc.getDeclaredConstructor(new Class[0]);
            retval = (Formatter)ctor.newInstance(new Object[0]);
        }
        return retval;
    }

    private static String getProperty(String key, String defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String value = manager.getProperty(key);
        return Strings.isNullOrEmpty((String)value) ? defaultValue : value;
    }

    private Level getDefaultLevel() {
        String value = CalendarFileHandler.getProperty(LEVEL_KEY, DEFAULT_LEVEL.getName());
        Level retval = DEFAULT_LEVEL;
        if (!Strings.isNullOrEmpty((String)value)) {
            retval = Level.parse(value);
        }
        return retval;
    }

    private static String dirname(String baseName) throws IOException {
        int index = baseName.lastIndexOf(File.separatorChar);
        String retval = index < 0 ? DEFAULT_DIRECTORY : baseName.substring(0, index);
        File dir = new File(retval);
        if (!(dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IOException(retval + " is an invalid directory");
        }
        return retval;
    }

    private static String basename(String baseName) {
        int index = baseName.lastIndexOf(File.separatorChar);
        return index < 0 ? baseName : baseName.substring(index + 1);
    }

    private void startMidnightTimer(TimerTask task) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        sTimer.schedule((java.util.TimerTask)task, calendar.getTime());
    }

    private static final class LogFileFilter
    implements FilenameFilter {
        private final File _directory;
        private final String _basename;
        private final int _basenameSize;
        private final SimpleDateFormat _dateFormatter;
        private final String _extension;
        private final int _extensionSize;
        private final Date _expiration;
        private final Calendar _calendar;

        private LogFileFilter(File directory, String basename, String dateFormat, String extension, Date expiration) {
            this._directory = directory;
            this._basename = basename;
            this._basenameSize = this._basename.length();
            this._dateFormatter = new SimpleDateFormat(dateFormat);
            this._extension = extension;
            this._extensionSize = this._extension.length();
            this._expiration = expiration;
            this._calendar = Calendar.getInstance();
        }

        @Override
        public boolean accept(File directory, String name) {
            ParsePosition pos;
            String dateSubstring;
            Date logFileDate;
            boolean retval;
            boolean bl = retval = directory.equals(this._directory) && name.startsWith(this._basename) && name.endsWith(this._extension);
            if (retval && (logFileDate = this._dateFormatter.parse(dateSubstring = name.substring(this._basenameSize, name.length() - this._extensionSize), pos = new ParsePosition(0))) != null) {
                this._calendar.setTime(logFileDate);
                this._calendar.set(11, 0);
                this._calendar.set(12, 0);
                this._calendar.set(13, 0);
                this._calendar.set(14, 0);
                retval = this._calendar.getTime().before(this._expiration);
            }
            return retval;
        }
    }
}

