/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SequentialTask
implements Runnable {
    private final int _index;
    private final TaskIndex _taskIndex;
    private final Runnable _task;
    private final Logger _logger;
    private final Level _logLevel;
    private static final Map<Object, TaskIndex> _IndexMap = new WeakHashMap<Object, TaskIndex>();
    private static final Lock _IndexLock = new ReentrantLock(true);

    private SequentialTask(TaskIndex taskIndex, Runnable task, Logger logger, Level logLevel) {
        this._index = taskIndex.assignIndex();
        this._taskIndex = taskIndex;
        this._task = task;
        this._logger = logger;
        this._logLevel = logLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TaskIndex taskIndex = this._taskIndex;
        synchronized (taskIndex) {
            block8: {
                while (this._index != this._taskIndex.currentIndex()) {
                    try {
                        this._taskIndex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    this._task.run();
                }
                catch (Exception jex) {
                    if (this._logger == null || !this._logger.isLoggable(this._logLevel)) break block8;
                    this._logger.log(this._logLevel, "task exception", jex);
                }
            }
            this._taskIndex.incrementIndex();
            this._taskIndex.notifyAll();
        }
    }

    public int index() {
        return this._index;
    }

    public static SequentialTask createTask(Object o, Runnable task) throws IllegalArgumentException {
        return SequentialTask.createTask(o, task, null, Level.OFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SequentialTask createTask(Object o, Runnable task, Logger logger, Level logLevel) throws IllegalArgumentException {
        SequentialTask retval = null;
        if (o == null) {
            throw new IllegalArgumentException("null o");
        }
        if (task == null) {
            throw new IllegalArgumentException("null task");
        }
        _IndexLock.lock();
        try {
            TaskIndex taskIndex;
            if (!_IndexMap.containsKey(o)) {
                taskIndex = new TaskIndex();
                _IndexMap.put(o, taskIndex);
            } else {
                taskIndex = _IndexMap.get(o);
            }
            retval = new SequentialTask(taskIndex, task, logger, logLevel);
        }
        finally {
            _IndexLock.unlock();
        }
        return retval;
    }

    private static final class TaskIndex {
        private int _currentIndex = 0;
        private int _assignIndex = 0;

        private TaskIndex() {
        }

        private int currentIndex() {
            return this._currentIndex;
        }

        private int assignIndex() {
            int retval = this._assignIndex++;
            this._assignIndex %= Integer.MAX_VALUE;
            return retval;
        }

        private void incrementIndex() {
            ++this._currentIndex;
            this._currentIndex %= Integer.MAX_VALUE;
        }
    }
}

