/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.regex;

import java.util.Iterator;
import java.util.SortedSet;
import net.sf.eBus.util.regex.Component;

public final class CharacterSet
extends Component {
    private static final long serialVersionUID = 328192L;
    private final SortedSet<Character> mSet;
    private final boolean mNegationFlag;

    CharacterSet(SortedSet<Character> set, boolean flag, int minSize, int maxSize, int index) {
        super(2, minSize, maxSize, index);
        this.mSet = set;
        this.mNegationFlag = flag;
    }

    @Override
    public boolean lessThan(char c) {
        return this.mSet.first().charValue() < c || this.mNegationFlag;
    }

    @Override
    public boolean equalTo(char c) {
        return this.mSet.contains(Character.valueOf(c)) != this.mNegationFlag;
    }

    @Override
    public boolean greaterThan(char c) {
        return this.mSet.last().charValue() > c || this.mNegationFlag;
    }

    public boolean isNegated() {
        return this.mNegationFlag;
    }

    public String toString() {
        int[] range = new int[2];
        int rangeIndex = 0;
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        if (this.mNegationFlag) {
            buffer.append('^');
        }
        Iterator it = this.mSet.iterator();
        while (it.hasNext()) {
            char index = ((Character)it.next()).charValue();
            if (rangeIndex > 0) {
                if (index == range[1] + 1) {
                    range[1] = index;
                } else {
                    buffer.append((char)range[0]);
                    if (range[1] > range[0] + 1) {
                        buffer.append('-');
                    }
                    buffer.append((char)range[1]);
                    rangeIndex = 0;
                }
            }
            if (rangeIndex != 0) continue;
            range[0] = index;
            rangeIndex = 1;
        }
        if (rangeIndex == 0) {
            buffer.append((char)range[0]);
        } else {
            buffer.append((char)range[0]);
            if (range[1] > range[0] + 1) {
                buffer.append('-');
            }
            buffer.append((char)range[1]);
        }
        buffer.append(']');
        this.appendSize(buffer);
        return buffer.toString();
    }
}

