/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.util.TimerEvent;
import net.sf.eBus.util.TimerTask;
import net.sf.eBus.util.TimerTaskListener;
import net.sf.eBus.util.logging.StatusReporter;

public final class StatusReport
implements TimerTaskListener {
    private boolean _initFlag = false;
    private String _appName = "<app name not set>";
    private String _version = "<version not set>";
    private Date _buildDate = null;
    private String _boilerPlate = null;
    private Logger _logger;
    private Level _level = Level.INFO;
    private ReportFrequency _frequency = ReportFrequency.FIFTEEN_MINUTE;
    private final List<StatusReporter> _reporters;
    private TimerTask _reportTimer;
    private boolean _dumpThreadsFlag = false;
    private static StatusReport _instance;
    private static final Lock _ctorMutex;
    private static final Date _startTime;
    private static final List<TimeUnit> _timeUnitList;
    private static final Timer _timer;
    private static final int MILLIS_PER_DAY = 86400000;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_SECOND = 1000;

    private StatusReport() {
        this._logger = Logger.getLogger("");
        this._reporters = new LinkedList<StatusReporter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTimeout(TimerEvent event) {
        LinkedList<StatusReporter> reporters;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Runtime sys = Runtime.getRuntime();
        long now = System.currentTimeMillis();
        long upTime = now - _startTime.getTime();
        long totalMem = sys.totalMemory();
        long freeMem = sys.freeMemory();
        long usedMem = totalMem - freeMem;
        pw.println("STATUS REPORT");
        pw.println();
        this.logHeader(pw);
        pw.println();
        pw.print("          JRE: ");
        pw.print(System.getProperty("java.version"));
        pw.print(" (");
        pw.print(System.getProperty("java.vendor"));
        pw.println(")");
        pw.print("          JVM: ");
        pw.print(System.getProperty("java.vm.name"));
        pw.print(", ");
        pw.print(System.getProperty("java.vm.version"));
        pw.print(" (");
        pw.print(System.getProperty("java.vm.vendor"));
        pw.println(")");
        pw.println();
        pw.print("   Start date: ");
        pw.format("%1$tm/%1$td/%1$tY at %1$tH:%1$tM:S%n", _startTime);
        pw.print("      Up time: ");
        pw.println(StatusReport.formatTime(upTime));
        pw.format("  Used memory: %,d bytes%n", usedMem);
        pw.format("  Free memory: %,d bytes%n", freeMem);
        pw.format(" Total memory: %,d bytes%n", totalMem);
        pw.format(" Thread count: %,d%n%n", this.countThreads());
        if (this._dumpThreadsFlag) {
            this.outputThreads(pw);
            pw.println();
        }
        List<StatusReporter> list = this._reporters;
        synchronized (list) {
            reporters = new LinkedList<StatusReporter>(this._reporters);
        }
        reporters.stream().map(reporter -> {
            reporter.reportStatus(pw);
            return reporter;
        }).forEach(_item -> pw.println());
        this._logger.log(this._level, sw.toString());
    }

    public synchronized Logger getLogger() {
        return this._logger;
    }

    public synchronized Level getLevel() {
        return this._level;
    }

    public synchronized ReportFrequency getReportFrequency() {
        return this._frequency;
    }

    public synchronized boolean getDumpThreads() {
        return this._dumpThreadsFlag;
    }

    public synchronized void setLogger(Logger logger) {
        this._logger = logger;
    }

    public synchronized void setLevel(Level level) throws IllegalArgumentException {
        if (level == null) {
            throw new IllegalArgumentException("null level");
        }
        this._level = level;
    }

    public synchronized void setReportFrequency(ReportFrequency frequency) {
        if (this._frequency != frequency) {
            this._frequency = frequency;
            if (this._reportTimer != null) {
                this._reportTimer.cancel();
                this._reportTimer = null;
            }
            this.startReportTimer();
        }
    }

    public synchronized void setDumpThreads(boolean flag) {
        this._dumpThreadsFlag = flag;
    }

    public synchronized void setApplicationInfo(String name, String version, Date buildDate, String boilerPlate) throws IllegalStateException {
        if (this._initFlag) {
            throw new IllegalStateException("app info already set");
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this._initFlag = true;
        this._appName = name;
        this._version = version;
        this._buildDate = new Date(buildDate.getTime());
        this._boilerPlate = boilerPlate;
        pw.println("=================================================================");
        this.logHeader(pw);
        this._logger.info(sw.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(StatusReporter reporter) {
        List<StatusReporter> list = this._reporters;
        synchronized (list) {
            if (!this._reporters.contains(reporter)) {
                this._reporters.add(reporter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(StatusReporter reporter) {
        List<StatusReporter> list = this._reporters;
        synchronized (list) {
            this._reporters.remove(reporter);
        }
    }

    public static StatusReport getInstance() {
        _ctorMutex.lock();
        try {
            if (_instance == null) {
                _instance = new StatusReport();
                _instance.startReportTimer();
            }
        }
        finally {
            _ctorMutex.unlock();
        }
        return _instance;
    }

    public static String formatTime(long delta) {
        long delta2 = delta;
        Formatter retval = new Formatter();
        Iterator<TimeUnit> it = _timeUnitList.iterator();
        boolean startFlag = false;
        while (it.hasNext()) {
            TimeUnit timeUnit = it.next();
            long unitTime = timeUnit.getUnitTime();
            long scalar = delta2 / unitTime;
            delta2 -= scalar * unitTime;
            if (scalar <= 0L && !startFlag) continue;
            if (!startFlag) {
                startFlag = true;
            } else {
                retval.format(", ", new Object[0]);
            }
            retval.format("%d %s", scalar, timeUnit.getName());
            if (scalar != 0L && scalar <= 1L) continue;
            retval.format("s", new Object[0]);
        }
        if (!startFlag) {
            retval.format("0 millisecs", new Object[0]);
        }
        return retval.toString();
    }

    private void logHeader(PrintWriter pw) {
        pw.print(this._appName);
        pw.print(" v. ");
        pw.print(this._version);
        if (this._buildDate != null) {
            pw.format(" (build %1$tm/%1$td/%1$tY at %1$tH:%1$tM:%1$tS)%n", this._buildDate);
            pw.println(")");
        }
        if (this._boilerPlate != null) {
            pw.println();
            pw.println(this._boilerPlate);
        }
        pw.println();
        pw.print("Current working directory is ");
        pw.print(System.getProperty("user.dir"));
        pw.println(".");
        pw.print("Class path is ");
        pw.print(System.getProperty("java.class.path"));
        pw.println(".");
    }

    private void startReportTimer() {
        long frequency = this._frequency.getFrequency();
        long reportDelay = frequency - System.currentTimeMillis() % frequency;
        this._reportTimer = new TimerTask(this);
        _timer.scheduleAtFixedRate((java.util.TimerTask)this._reportTimer, reportDelay, frequency);
    }

    private int countThreads() {
        ThreadGroup parent;
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while ((parent = group.getParent()) != null) {
            group = parent;
        }
        return group.activeCount() - 1;
    }

    private void outputThreads(PrintWriter pw) {
        ThreadGroup parent;
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while ((parent = group.getParent()) != null) {
            group = parent;
        }
        int threadCount = group.activeCount();
        if (threadCount == 0) {
            pw.println("Active threads: None");
        } else {
            Thread[] threads = new Thread[threadCount];
            group.enumerate(threads);
            --threadCount;
            for (int index = 0; index < threadCount; ++index) {
                Thread thread = threads[index];
                if (thread == null) continue;
                pw.print("[");
                pw.print(thread.getName());
                pw.print("] ");
                pw.print(thread.getClass().getName());
                pw.print(" (");
                if (thread.isAlive()) {
                    pw.print("alive, ");
                } else {
                    pw.print("dead, ");
                }
                if (thread.isDaemon()) {
                    pw.print("daemon, ");
                } else {
                    pw.print("non-daemon, ");
                }
                if (thread.isInterrupted()) {
                    pw.print("interrupted, ");
                } else {
                    pw.print("not interrupted, ");
                }
                pw.print((Object)thread.getState());
                pw.println(")");
            }
        }
    }

    static {
        _ctorMutex = new ReentrantLock();
        _startTime = new Date();
        _timer = new Timer("ReportTimer", true);
        _timeUnitList = new ArrayList<TimeUnit>();
        _timeUnitList.add(new TimeUnit("day", 86400000L));
        _timeUnitList.add(new TimeUnit("hour", 3600000L));
        _timeUnitList.add(new TimeUnit("minute", 60000L));
        _timeUnitList.add(new TimeUnit("second", 1000L));
        _timeUnitList.add(new TimeUnit("millisec", 1L));
    }

    private static final class TimeUnit {
        private final String _name;
        private final long _unitTime;

        private TimeUnit(String name, long unitTime) {
            this._name = name;
            this._unitTime = unitTime;
        }

        private String getName() {
            return this._name;
        }

        private long getUnitTime() {
            return this._unitTime;
        }
    }

    public static enum ReportFrequency {
        FIVE_MINUTE(300000L),
        TEN_MINUTE(600000L),
        FIFTEEN_MINUTE(900000L),
        TWENTY_MINUTE(1200000L),
        THIRTY_MINUTE(1800000L),
        HOURLY(3600000L);

        private final long _frequency;

        private ReportFrequency(long frequency) {
            this._frequency = frequency;
        }

        public long getFrequency() {
            return this._frequency;
        }
    }
}

