/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.io.Serializable;
import java.util.Formatter;

public class MultiKey
implements Comparable<MultiKey>,
Serializable {
    private static final long serialVersionUID = 328192L;
    private final Object[] mKeys;
    private final int mHashCode;

    public MultiKey(Object ... keys) throws IndexOutOfBoundsException {
        if (keys.length == 0) {
            throw new IndexOutOfBoundsException("no keys");
        }
        this.mKeys = new Object[keys.length];
        System.arraycopy(keys, 0, this.mKeys, 0, keys.length);
        int hashCode = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            hashCode ^= keys[i].hashCode();
        }
        this.mHashCode = hashCode;
    }

    @Override
    public int compareTo(MultiKey key) throws ClassCastException {
        int retval = 0;
        if (this != key) {
            retval = this.mKeys.length - key.mKeys.length;
            for (int i = 0; i < this.mKeys.length && retval == 0; ++i) {
                if (this.mKeys[i] == null) {
                    if (key.mKeys[i] == null) continue;
                    retval = -1;
                    continue;
                }
                retval = ((Comparable)this.mKeys[i]).compareTo(key.mKeys[i]);
            }
        }
        return retval;
    }

    public int size() {
        return this.mKeys.length;
    }

    public Object key(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.mKeys.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index) + " invalid index");
        }
        return this.mKeys[index];
    }

    public Object[] keys() {
        Object[] keys = new Object[this.mKeys.length];
        System.arraycopy(this.mKeys, 0, keys, 0, this.mKeys.length);
        return keys;
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof MultiKey) {
            MultiKey mkey = (MultiKey)o;
            if (this.mKeys.length == mkey.mKeys.length) {
                retcode = true;
                for (int i = 0; retcode && i < this.mKeys.length; ++i) {
                    retcode = this.mKeys[i] == null ? mkey.mKeys[i] == null : this.mKeys[i].equals(mkey.mKeys[i]);
                }
            }
        }
        return retcode;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public String toString() {
        Formatter buffer = new Formatter();
        buffer.format("{", new Object[0]);
        String sep = "";
        for (int i = 0; i < this.mKeys.length; ++i) {
            buffer.format("%s%s", sep, this.mKeys[i]);
            sep = ", ";
        }
        buffer.format("}", new Object[0]);
        return buffer.toString();
    }
}

