/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.util.Arrays;
import java.util.Formatter;

public final class HexDump {
    private static final int BYTES_PER_LINE = 16;
    private static final int BREAK_COLUMN = 8;
    private static final int SPACE_COUNT = 3;
    private static final int MAX_BYTE = 256;
    private static final char[] ASCII_CODE = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};

    private HexDump() {
    }

    public static String dump(byte[] data, String indent) {
        return HexDump.dump(data, 0, data.length, indent);
    }

    public static String dump(byte[] data, int offset, int size, String indent) {
        char[] ascii = new char[19];
        Formatter retval = new Formatter();
        int index1 = 0;
        int address = 0;
        while (index1 < size) {
            int index2;
            int remaining = size - index1;
            int lineSize = remaining < 16 ? remaining : 16;
            Arrays.fill(ascii, ' ');
            ascii[0] = 34;
            retval.format("%n", new Object[0]);
            if (indent != null) {
                retval.format(indent, new Object[0]);
            }
            retval.format("0x%08x: ", address);
            int index3 = 0;
            for (index2 = 0; index2 < lineSize; ++index2) {
                int datum = data[offset + index1 + index2];
                if (datum < 0) {
                    datum += 256;
                }
                if (index2 == 8) {
                    retval.format("   ", new Object[0]);
                    index3 = 1;
                } else {
                    retval.format(" ", new Object[0]);
                }
                retval.format("%02x", datum);
                ascii[index2 + index3 + 1] = ASCII_CODE[datum];
            }
            ascii[index2 + index3 + 1] = 34;
            if (lineSize < 16) {
                for (index2 = lineSize; index2 < 16; ++index2) {
                    if (index2 == 8) {
                        retval.format("  ", new Object[0]);
                    }
                    retval.format("   ", new Object[0]);
                }
            }
            retval.format("  %s", new String(ascii));
            index1 += lineSize;
            address += lineSize;
        }
        return retval.toString();
    }
}

