/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class EventThread
extends Thread {
    private AtomicReference<RunState> _runState;
    private BlockingQueue<Object> _queue;
    private Thread _thread;
    private CountDownLatch _startSignal;
    private CountDownLatch _stopSignal;
    private static AtomicInteger _threadNumber = new AtomicInteger();
    private static final Logger _logger = Logger.getLogger(EventThread.class.getName());
    private static final String NAME_PREFIX = "EventThread_%d";

    protected EventThread() {
        this(String.format(NAME_PREFIX, _threadNumber.getAndIncrement()), Integer.MAX_VALUE);
    }

    protected EventThread(String name) {
        this(name, Integer.MAX_VALUE);
    }

    protected EventThread(int capacity) {
        this(String.format(NAME_PREFIX, _threadNumber.getAndIncrement()), capacity);
    }

    protected EventThread(String name, int capacity) {
        super(name);
        if (capacity <= 0) {
            throw new IllegalArgumentException("invalid capacity (" + Integer.toString(capacity) + ")");
        }
        this._runState = new AtomicReference<RunState>(RunState.NOT_STARTED);
        this._queue = new LinkedBlockingQueue<Object>(capacity);
        this._startSignal = new CountDownLatch(1);
        this._stopSignal = new CountDownLatch(1);
    }

    public final boolean isHalted() {
        return this._runState.get().compareTo(RunState.HALT_DRAIN) >= 0;
    }

    public final RunState runstate() {
        return this._runState.get();
    }

    @Override
    public final void run() {
        boolean startFlag = false;
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "{0} is starting.", this.getName());
        }
        this._thread = Thread.currentThread();
        try {
            if (this._runState.get() == RunState.NOT_STARTED) {
                startFlag = this.starting();
                if (startFlag) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "{0} started.", this.getName());
                    }
                    this._runState.set(RunState.RUNNING);
                } else {
                    this._runState.set(RunState.HALTED);
                }
            }
        }
        catch (Exception jex) {
            _logger.log(Level.WARNING, "thread exception while starting.", jex);
            this._runState.set(RunState.HALTED);
        }
        this._startSignal.countDown();
        if (this._runState.get() == RunState.RUNNING && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "{0} is now running.", this.getName());
        }
        while (this._runState.get().compareTo(RunState.HALT_DRAIN) <= 0) {
            try {
                Object event = this._queue.take();
                if (event instanceof HaltEvent) {
                    this._runState.set(RunState.HALT_NOW);
                    continue;
                }
                this.handleEvent(event);
            }
            catch (InterruptedException jex) {
            }
            catch (Exception threadex) {
                _logger.log(Level.WARNING, "Event processing failure.", threadex);
            }
        }
        this._thread = null;
        if (startFlag) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, "{0} is stopping.", this.getName());
            }
            try {
                this._runState.set(RunState.STOPPING);
                this.stopping();
            }
            catch (Exception jex) {
                _logger.log(Level.WARNING, "thread exception while stopping", jex);
            }
            this._runState.set(RunState.HALTED);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "{0} stopped.", this.getName());
            }
            this._stopSignal.countDown();
        }
    }

    public abstract void handleEvent(Object var1);

    public abstract boolean starting();

    public abstract void stopping();

    public final void start(boolean waitFlag) throws IllegalStateException {
        if (this._runState.get() != RunState.NOT_STARTED) {
            throw new IllegalStateException("thread previously started");
        }
        super.start();
        if (waitFlag) {
            try {
                this._startSignal.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._startSignal = null;
    }

    public final void add(Object event) throws IllegalArgumentException, IllegalStateException {
        RunState runState = this._runState.get();
        if (event == null) {
            throw new IllegalArgumentException("null event");
        }
        if (runState == RunState.HALT_DRAIN || runState == RunState.HALT_NOW) {
            throw new IllegalStateException("thread halted");
        }
        try {
            this._queue.put(event);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void halt(boolean waitFlag) {
        RunState runState = this._runState.get();
        if (runState == RunState.STARTING || runState == RunState.RUNNING) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, "Halting {0}.", this.getName());
            }
            this._runState.set(RunState.HALT_DRAIN);
            try {
                this._queue.put(new HaltEvent());
                if (waitFlag) {
                    this._stopSignal.await();
                }
            }
            catch (InterruptedException interrupt) {
                this._runState.set(RunState.HALT_NOW);
                this._thread.interrupt();
            }
        }
    }

    public final void haltNow(boolean waitFlag) {
        RunState runState = this._runState.get();
        if (runState == RunState.STARTING || runState == RunState.RUNNING) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, "Halting {0} immediately.", this.getName());
            }
            this._runState.set(RunState.HALT_NOW);
            this._thread.interrupt();
        }
        if (waitFlag) {
            try {
                this._stopSignal.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static final class HaltEvent {
        private HaltEvent() {
        }
    }

    public static enum RunState {
        NOT_STARTED,
        STARTING,
        RUNNING,
        HALT_DRAIN,
        HALT_NOW,
        STOPPING,
        HALTED;

    }
}

