/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.text;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import net.sf.eBus.text.Token;
import net.sf.eBus.text.TokenLexerContext;

public final class TokenLexer {
    public static final char NO_OPEN_CHAR = '\u0000';
    private static final int MAX_BUFFER_LEN = 4096;
    private static final int BUFFER_OFFSET = 2;
    private static final int READ_BUFFER_LEN = 4098;
    private static final int EOL = 10;
    private static final int CR = 13;
    public static final int ERROR = 0;
    public static final int EOF = 1;
    public static final int CHARACTER = 2;
    public static final int COMMENT = 3;
    public static final int FLOAT = 4;
    public static final int INTEGER = 5;
    public static final int NAME = 6;
    public static final int OPERATOR = 7;
    public static final int SOURCE = 8;
    public static final int STRING = 9;
    public static final int TOKEN_COUNT = 10;
    public static final int NEXT_TOKEN = 10;
    private static final int MIN_ASCII_CHAR = 0;
    private static final int MAX_ASCII_CHAR = 128;
    private static final int[] PUNCTUATION = new int[]{33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 58, 59, 60, 61, 62, 63, 64, 91, 92, 93, 94, 95, 96, 123, 125, 124, 126};
    private static String[] sTypeName;
    private static Method[] _TransMethod;
    private TokenLexerContext mLexerFSM;
    private Reader mReader = null;
    private LexMode mMode;
    private boolean _stopFlag;
    private Token mToken;
    private final StringBuilder mTokenBuffer = new StringBuilder();
    private int mLineNumber = 0;
    private final char[] mReadBuffer = new char[4098];
    private int mBufferSize = 0;
    private int mReadIndex = 0;
    private int mOffset = 0;
    private boolean mEofFlag = false;
    private char mOpenChar;
    private char mCloseChar;
    private final Map<String, Integer> mKeywords;
    private final Map<String, Integer> mOperators;
    private final Map<Character, Integer> mDelimiters;

    public TokenLexer(Map<String, Integer> keywords, Map<String, Integer> operators, Map<Character, Integer> delimiters) throws IllegalArgumentException {
        this.mKeywords = keywords;
        this.mOperators = operators;
        this.mDelimiters = delimiters;
        this.validate(keywords.values(), "keywords");
        this.validate(operators.values(), "operators");
        this.validate(delimiters.values(), "delimiters");
        this.mMode = LexMode.COOKED;
        this.mLexerFSM = null;
    }

    public int lineNumber() {
        return this.mLineNumber;
    }

    public int offset() {
        return this.mOffset;
    }

    public LexMode mode() {
        return this.mMode;
    }

    public void input(Reader reader) {
        this.mReader = reader;
        this.mBufferSize = 0;
        this.mReadIndex = 0;
        this.mOffset = 0;
        this.mLineNumber = 0;
        this.mEofFlag = false;
        this.mLexerFSM = new TokenLexerContext(this);
        this.mLexerFSM.enterStartState();
    }

    public void rawMode(char openChar, char closeChar) {
        this.mMode = LexMode.RAW;
        this.mOpenChar = openChar;
        this.mCloseChar = closeChar;
    }

    public void cookedMode() {
        this.mMode = LexMode.COOKED;
        this.mTokenBuffer.delete(0, this.mTokenBuffer.length());
    }

    public Token nextToken() {
        Token retval = this.mEofFlag ? new Token(1, null, "", this.mLineNumber) : (this.mMode == LexMode.COOKED ? this.nextCookedToken() : this.nextRawToken());
        return retval;
    }

    String token() {
        return this.mTokenBuffer.toString();
    }

    void startToken() {
        this.mToken = null;
        this.mTokenBuffer.delete(0, this.mTokenBuffer.length());
    }

    void appendToken(char c) {
        this.mTokenBuffer.append(c);
    }

    void endToken(int type) {
        String tokenStr = this.mTokenBuffer.toString();
        switch (type) {
            case 6: {
                this.mToken = this.nameToken(tokenStr);
                break;
            }
            case 7: {
                this.mToken = this.operatorToken(tokenStr);
                break;
            }
            case 2: {
                this.mToken = new Token(type, Character.valueOf(tokenStr.charAt(0)), tokenStr, this.mLineNumber);
                break;
            }
            case 4: {
                this.mToken = this.floatToken(tokenStr);
                break;
            }
            case 5: {
                this.mToken = this.longToken(tokenStr);
                break;
            }
            default: {
                this.mToken = new Token(type, tokenStr, tokenStr, this.mLineNumber);
            }
        }
        this._stopFlag = true;
    }

    void badToken(String errorMsg) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(errorMsg);
        buffer.append(" (token: ");
        buffer.append(this.mTokenBuffer.toString());
        buffer.append(")");
        this.mToken = new Token(0, buffer.toString(), "", this.mLineNumber);
        this._stopFlag = true;
    }

    void ungetChar() {
        --this.mReadIndex;
        --this.mOffset;
    }

    boolean isDelimiter(char c) {
        return this.mDelimiters.containsKey(Character.valueOf(c));
    }

    int delimiterType(char c) {
        return this.mDelimiters.get(Character.valueOf(c));
    }

    private Token nextCookedToken() {
        this.startToken();
        try {
            this._stopFlag = false;
            while (!this._stopFlag) {
                char c = this.readChar();
                if (c >= _TransMethod.length) {
                    this.mLexerFSM.unicode(c);
                    continue;
                }
                if (c == '\n') {
                    ++this.mLineNumber;
                }
                _TransMethod[c].invoke((Object)this.mLexerFSM, Character.valueOf(c));
            }
        }
        catch (EOFException e) {
            this.mLexerFSM.EOF();
        }
        catch (IllegalAccessException | InvocationTargetException invokex) {
            this.badToken("Unknown token");
        }
        catch (IOException ioex) {
            this.badToken(ioex.getMessage() + " (token: " + this.mTokenBuffer.toString() + ")");
        }
        return this.mToken;
    }

    private Token nextRawToken() {
        int startLine = this.mLineNumber;
        this.startToken();
        try {
            int depth = 0;
            this._stopFlag = false;
            while (!this._stopFlag) {
                char c = this.readChar();
                if (c == this.mCloseChar && depth == 0) {
                    this._stopFlag = true;
                    continue;
                }
                this.mTokenBuffer.append(c);
                if (c == this.mCloseChar) {
                    --depth;
                    continue;
                }
                if (this.mOpenChar != '\u0000' && c == this.mOpenChar) {
                    ++depth;
                    continue;
                }
                if (c != '\n') continue;
                ++this.mLineNumber;
            }
            String value = this.mTokenBuffer.toString();
            this.mToken = new Token(8, value, value, startLine);
        }
        catch (EOFException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("User source code contains an unbalanced ");
            msg.append(this.mOpenChar);
            msg.append(", ");
            msg.append(this.mCloseChar);
            msg.append(" pair.");
            this.badToken(msg.toString());
        }
        catch (IOException ioex) {
            this.badToken(ioex.getMessage() + " (token: " + this.mTokenBuffer.toString() + ")");
        }
        return this.mToken;
    }

    private Token nameToken(String token) {
        int type = 6;
        String value = token;
        String key = token.toUpperCase(Locale.US);
        if (this.mKeywords.containsKey(key)) {
            type = this.mKeywords.get(key);
            value = key;
        }
        return new Token(type, value, token, this.mLineNumber);
    }

    private Token operatorToken(String token) {
        int type;
        String value = token;
        if (!this.mOperators.containsKey(token)) {
            type = 0;
            value = "unknown operator";
        } else {
            type = this.mOperators.get(token);
        }
        return new Token(type, value, token, this.mLineNumber);
    }

    private Token floatToken(String token) {
        Object value;
        int type = 4;
        try {
            value = Double.valueOf(token);
        }
        catch (NumberFormatException formex) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("invalid float, ");
            buffer.append(formex.getMessage());
            type = 0;
            value = buffer.toString();
        }
        return new Token(type, value, token, this.mLineNumber);
    }

    private Token longToken(String initialToken) {
        Object value;
        String token = initialToken;
        int type = 5;
        if (token.charAt(0) == '+') {
            token = token.substring(1);
        }
        try {
            value = Long.valueOf(token);
        }
        catch (NumberFormatException formex) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("invalid integer, ");
            buffer.append(formex.getMessage());
            type = 0;
            value = buffer.toString();
        }
        return new Token(type, value, token, this.mLineNumber);
    }

    private char readChar() throws IOException, EOFException {
        if (this.mReadIndex == this.mBufferSize) {
            int offset = 0;
            if (this.mBufferSize > 2) {
                offset = 2;
                this.mReadBuffer[0] = this.mReadBuffer[this.mBufferSize - 2];
                this.mReadBuffer[1] = this.mReadBuffer[this.mBufferSize - 1];
            } else if (this.mBufferSize > 1) {
                offset = 1;
                this.mReadBuffer[0] = this.mReadBuffer[this.mBufferSize - 1];
            }
            int length = 4096 - offset;
            int size = this.mReader.read(this.mReadBuffer, offset, length);
            if (size < 0) {
                this.mBufferSize = 0;
                this.mEofFlag = true;
                throw new EOFException("end-of-file reached");
            }
            this.mBufferSize = size + offset;
            this.mReadIndex = offset;
        }
        char retval = this.mReadBuffer[this.mReadIndex];
        ++this.mReadIndex;
        ++this.mOffset;
        return retval;
    }

    private void validate(Collection<Integer> values, String name) throws IllegalArgumentException {
        values.stream().filter(value -> value < 10).forEachOrdered(value -> {
            throw new IllegalArgumentException(String.format("invalid %s token type (%s)", name, value));
        });
    }

    static {
        String transName = "<not set>";
        sTypeName = new String[10];
        TokenLexer.sTypeName[0] = "ERROR";
        TokenLexer.sTypeName[2] = "CHARACTER";
        TokenLexer.sTypeName[3] = "COMMENT";
        TokenLexer.sTypeName[1] = "EOF";
        TokenLexer.sTypeName[4] = "FLOAT";
        TokenLexer.sTypeName[5] = "INTEGER";
        TokenLexer.sTypeName[6] = "NAME";
        TokenLexer.sTypeName[8] = "SOURCE";
        TokenLexer.sTypeName[9] = "STRING";
        _TransMethod = new Method[128];
        try {
            int i;
            Class<TokenLexerContext> fsmClass = TokenLexerContext.class;
            transName = "unicode";
            Method unicode = fsmClass.getDeclaredMethod(transName, Character.TYPE);
            transName = "whitespace";
            Method whitespace = fsmClass.getDeclaredMethod(transName, Character.TYPE);
            transName = "alpha";
            Method alpha = fsmClass.getDeclaredMethod(transName, Character.TYPE);
            transName = "digit";
            Method digit = fsmClass.getDeclaredMethod(transName, Character.TYPE);
            transName = "punctuation";
            Method punctuation = fsmClass.getDeclaredMethod(transName, Character.TYPE);
            transName = "EOL";
            Method eol = fsmClass.getDeclaredMethod(transName, Character.TYPE);
            for (i = 0; i < 128; ++i) {
                TokenLexer._TransMethod[i] = Character.isWhitespace(i) ? whitespace : unicode;
            }
            for (i = 97; i <= 122; ++i) {
                TokenLexer._TransMethod[i] = alpha;
            }
            for (i = 65; i <= 90; ++i) {
                TokenLexer._TransMethod[i] = alpha;
            }
            for (i = 48; i <= 57; ++i) {
                TokenLexer._TransMethod[i] = digit;
            }
            TokenLexer._TransMethod[10] = eol;
            TokenLexer._TransMethod[13] = eol;
            for (i = 0; i < PUNCTUATION.length; ++i) {
                TokenLexer._TransMethod[TokenLexer.PUNCTUATION[i]] = punctuation;
            }
        }
        catch (NoSuchMethodException | SecurityException jex) {
            System.err.format("INITIALIZATION ERROR! No such method as LexerContext.%s(char).%n", transName);
        }
    }

    public static enum LexMode {
        COOKED,
        RAW;

    }
}

