//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
// 
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2001 - 2008. Charles W. Rapp.
// All Rights Reserved.
//

package net.sf.eBus.util;

/**
 * Classes which want to be asynchronously informed about
 * properties changes should implement this interface and
 * add themselves to the properties listeners by calling
 * {@link Properties#addListener(PropertiesListener)}.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public interface PropertiesListener
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * {@link Properties} calls this method when it detects
     * a change in its underlying properties file.
     * @param event The change properties event.
     */
    void propertiesUpdate(PropertiesEvent event);
} // end of interface PropertiesListener

//
// CHANGE LOG
// $Log: PropertiesListener.java,v $
// Revision 1.2  2005/07/22 01:36:04  charlesr
// Move to Java 5.
//
// Revision 1.1  2004/07/25 16:02:22  charlesr
// Corrected javadoc comments.
//
// Revision 1.0  2004/03/02 23:20:06  charlesr
// Initial revision
//
