//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2005. Charles W. Rapp.
// All Rights Reserved.
//

package net.sf.eBus.util;

/**
 * This {@link MultiKey} subclass uses generics to guarantee
 * key type and order. {@link MultiKey} is unable to provide
 * this type safety.
 * @param <K1> The first key.
 * @param <K2> The second key.
 * @param <K3> The third key.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public class MultiKey3<K1, K2, K3>
    extends MultiKey
{
//---------------------------------------------------------------
// Member data.
//

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     *  This is eBus version 2.1.0.
     */
    private static final long serialVersionUID = 0x050200L;

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * Creates a three value {@link MultiKey}.
     * @param key1 the first key.
     * @param key2 the second key.
     * @param key3 the third key.
     */
    public MultiKey3(final K1 key1, final K2 key2, final K3 key3)
    {
        super (key1, key2, key3);
    } // end of MultiKey3(K1, K2, K3)

    //
    // end of Constructors.
    //-----------------------------------------------------------
} // end of class MultiKey3

//
// CHANGE LOG
// $Log: MultiKey3.java,v $
// Revision 1.1  2008/02/29 14:57:09  charlesr
// Made class inheritable.
//
// Revision 1.0  2005/10/27 15:08:30  charlesr
// Initial revision
//
