/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import net.sf.eBus.util.TimerEvent;
import net.sf.eBus.util.TimerTask;
import net.sf.eBus.util.TimerTaskListener;

public final class CalendarFileHandler
extends StreamHandler
implements TimerTaskListener {
    private final String _directory;
    private final String _basename;
    private final String _dateFormat;
    private final String _extension;
    private final int _daysKept;
    private TimerTask _logRollTimer;
    private static Timer _Timer = new Timer("LogRollTimer", true);
    public static final String DEFAULT_DIRECTORY = ".";
    public static final String DEFAULT_BASENAME = "Logger";
    public static final String DEFAULT_DATE_FORMAT = "yyyyMMdd";
    public static final String DEFAULT_EXTENSION = "log";
    public static final int MIN_DAYS_KEPT = 0;
    public static final int MAX_DAYS_KEPT = 96;
    public static final int DEFAULT_DAYS_KEPT = 10;
    private static final String BASENAME_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.basename";
    private static final String PATTERN_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.pattern";
    private static final String EXTENSION_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.extension";
    private static final String DAYS_KEPT_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.days_kept";
    private static final String FORMATTER_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.formatter";
    private static final String LEVEL_KEY = "net.sf.eBus.util.logging.CalendarFileHandler.level";

    public CalendarFileHandler() {
        Formatter formatter2;
        this._logRollTimer = new TimerTask(this);
        LogManager manager = LogManager.getLogManager();
        int daysKept = 10;
        String value = CalendarFileHandler.getProperty(BASENAME_KEY, DEFAULT_BASENAME, manager);
        this._directory = CalendarFileHandler.dirname(value);
        this._basename = CalendarFileHandler.basename(value);
        this._extension = CalendarFileHandler.getProperty(EXTENSION_KEY, DEFAULT_EXTENSION, manager);
        this._dateFormat = CalendarFileHandler.getProperty(PATTERN_KEY, DEFAULT_DATE_FORMAT, manager);
        value = manager.getProperty(FORMATTER_KEY);
        if (value != null && value.length() > 0 && (formatter2 = CalendarFileHandler.createFormatter(value)) != null) {
            this.setFormatter(formatter2);
        }
        if ((value = manager.getProperty(LEVEL_KEY)) != null && value.length() > 0) {
            try {
                this.setLevel(Level.parse(value));
            }
            catch (IllegalArgumentException | SecurityException formatter2) {
                // empty catch block
            }
        }
        if ((value = manager.getProperty(DAYS_KEPT_KEY)) != null && value.length() > 0) {
            try {
                daysKept = Integer.parseInt(value);
            }
            catch (Exception formatter2) {
                // empty catch block
            }
        }
        this._daysKept = daysKept;
        OutputStream logStream = CalendarFileHandler.openLogStream(this._directory, this._basename, this._dateFormat, this._extension);
        if (logStream != null) {
            this.setOutputStream(logStream);
        }
        this.deleteLogFiles();
        this.startMidnightTimer(this._logRollTimer);
    }

    public CalendarFileHandler(String baseName, String datePattern, String extension, int daysKept) throws IllegalArgumentException {
        OutputStream logStream;
        Formatter formatter2;
        if (baseName == null) {
            throw new IllegalArgumentException("null baseName");
        }
        if (datePattern == null) {
            throw new IllegalArgumentException("null datePattern");
        }
        if (extension == null) {
            throw new IllegalArgumentException("null extension");
        }
        if (baseName.length() == 0) {
            throw new IllegalArgumentException("empty baseName");
        }
        if (datePattern.length() == 0) {
            throw new IllegalArgumentException("empty datePattern");
        }
        if (extension.length() == 0) {
            throw new IllegalArgumentException("empty extension");
        }
        this._directory = CalendarFileHandler.dirname(baseName);
        this._basename = CalendarFileHandler.basename(baseName);
        this._dateFormat = datePattern;
        this._extension = extension;
        this._daysKept = daysKept;
        this._logRollTimer = new TimerTask(this);
        File dir = new File(this._directory);
        if (!(dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException(this._directory + " is an invalid directory");
        }
        LogManager manager = LogManager.getLogManager();
        String value = manager.getProperty(FORMATTER_KEY);
        if (value != null && value.length() > 0 && (formatter2 = CalendarFileHandler.createFormatter(value)) != null) {
            this.setFormatter(formatter2);
        }
        if ((value = manager.getProperty(LEVEL_KEY)) != null && value.length() > 0) {
            try {
                this.setLevel(Level.parse(value));
            }
            catch (IllegalArgumentException | SecurityException formatter2) {
                // empty catch block
            }
        }
        if ((logStream = CalendarFileHandler.openLogStream(this._directory, this._basename, this._dateFormat, this._extension)) != null) {
            this.setOutputStream(logStream);
        }
        this.deleteLogFiles();
        this.startMidnightTimer(this._logRollTimer);
    }

    @Override
    public void handleTimeout(TimerEvent task) {
        OutputStream logStream = CalendarFileHandler.openLogStream(this._directory, this._basename, this._dateFormat, this._extension);
        LogRecord logRecord = new LogRecord(Level.INFO, "Rolling log file.");
        logRecord.setSourceClassName(CalendarFileHandler.class.getName());
        logRecord.setSourceMethodName("handleTimeout");
        this.publish(logRecord);
        this.deleteLogFiles();
        if (logStream != null) {
            this.setOutputStream(logStream);
        }
        logRecord = new LogRecord(Level.INFO, "Finished rolling log file.");
        logRecord.setSourceClassName(CalendarFileHandler.class.getName());
        logRecord.setSourceMethodName("handleTimeout");
        this.publish(logRecord);
        this._logRollTimer = new TimerTask(this);
        this.startMidnightTimer(this._logRollTimer);
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        super.flush();
    }

    private void deleteLogFiles() {
        Calendar calendar = Calendar.getInstance();
        File directory = new File(this._directory);
        calendar.add(5, this._daysKept * -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        LogFileFilter logFilter = new LogFileFilter(directory, this._basename + DEFAULT_DIRECTORY, this._dateFormat, DEFAULT_DIRECTORY + this._extension, calendar.getTime());
        File[] logFiles = directory.listFiles(logFilter);
        if (logFiles != null && logFiles.length > 0) {
            java.util.Formatter buffer = new java.util.Formatter();
            buffer.format("Deleted the following log files:", new Object[0]);
            for (int index = 0; index < logFiles.length; ++index) {
                buffer.format("%n    %s", logFiles[index].getName());
                if (logFiles[index].delete()) continue;
                buffer.format(" failed", new Object[0]);
            }
            LogRecord logRecord = new LogRecord(Level.INFO, buffer.toString());
            logRecord.setSourceClassName(CalendarFileHandler.class.getName());
            logRecord.setSourceMethodName("handleTimeout");
            this.publish(logRecord);
        }
    }

    private static OutputStream openLogStream(String directory, String basename, String datePattern, String extension) {
        FileOutputStream retval = null;
        try {
            File logFile = new File(CalendarFileHandler.generateLogFilename(directory, basename, datePattern, extension));
            retval = new FileOutputStream(logFile, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retval;
    }

    private static String generateLogFilename(String directory, String basename, String datePattern, String extension) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
        return String.format("%s%c%s.%s.%s", directory, Character.valueOf(File.separatorChar), basename, formatter.format(new Date()), extension);
    }

    private static String getProperty(String key, String defaultValue, LogManager manager) {
        String retval = manager.getProperty(key);
        if (retval == null || retval.length() == 0) {
            retval = defaultValue;
        }
        return retval;
    }

    private static Formatter createFormatter(String className) {
        Formatter retval = null;
        try {
            Class<?> formatterClass = Class.forName(className);
            Constructor<?> ctor = formatterClass.getDeclaredConstructor(new Class[0]);
            retval = (Formatter)ctor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return retval;
    }

    private static String dirname(String baseName) {
        int index = baseName.lastIndexOf(47);
        String retval = index < 0 ? DEFAULT_DIRECTORY : baseName.substring(0, index);
        return retval;
    }

    private static String basename(String baseName) {
        int index = baseName.lastIndexOf(47);
        String retval = index < 0 ? baseName : baseName.substring(index + 1);
        return retval;
    }

    private void startMidnightTimer(TimerTask task) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        _Timer.schedule((java.util.TimerTask)task, calendar.getTime());
    }

    private static final class LogFileFilter
    implements FilenameFilter {
        private final File _directory;
        private final String _basename;
        private final int _basenameSize;
        private final SimpleDateFormat _dateFormatter;
        private final String _extension;
        private final int _extensionSize;
        private final Date _expiration;
        private final Calendar _calendar;

        private LogFileFilter(File directory, String basename, String dateFormat, String extension, Date expiration) {
            this._directory = directory;
            this._basename = basename;
            this._basenameSize = this._basename.length();
            this._dateFormatter = new SimpleDateFormat(dateFormat);
            this._extension = extension;
            this._extensionSize = this._extension.length();
            this._expiration = expiration;
            this._calendar = Calendar.getInstance();
        }

        @Override
        public boolean accept(File directory, String name) {
            ParsePosition pos;
            String dateSubstring;
            Date logFileDate;
            boolean retval;
            boolean bl = retval = directory.equals(this._directory) && name.startsWith(this._basename) && name.endsWith(this._extension);
            if (retval && (logFileDate = this._dateFormatter.parse(dateSubstring = name.substring(this._basenameSize, name.length() - this._extensionSize), pos = new ParsePosition(0))) != null) {
                this._calendar.setTime(logFileDate);
                this._calendar.set(11, 0);
                this._calendar.set(12, 0);
                this._calendar.set(13, 0);
                this._calendar.set(14, 0);
                retval = this._calendar.getTime().before(this._expiration);
            }
            return retval;
        }
    }
}

