/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ShutdownHook
extends Thread {
    private final CountDownLatch _signal;
    private static ShutdownHook _instance = null;
    private static final Lock _lock = new ReentrantLock();

    private ShutdownHook(CountDownLatch signal) {
        this._signal = signal;
    }

    @Override
    public void run() {
        this._signal.countDown();
    }

    public static CountDownLatch addShutdownHook() {
        CountDownLatch retval;
        _lock.lock();
        try {
            if (_instance != null) {
                retval = ShutdownHook._instance._signal;
            } else {
                retval = new CountDownLatch(1);
                _instance = new ShutdownHook(retval);
                Runtime.getRuntime().addShutdownHook(_instance);
            }
        }
        finally {
            _lock.unlock();
        }
        return retval;
    }

    public static void removeShutdownHook() {
        _lock.lock();
        try {
            if (_instance != null) {
                Runtime.getRuntime().removeShutdownHook(_instance);
                _instance = null;
            }
        }
        finally {
            _lock.unlock();
        }
    }
}

