/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.util.TimerEvent;
import net.sf.eBus.util.TimerTaskListener;

public final class TimerTask
extends java.util.TimerTask {
    private static final Logger sLogger = Logger.getLogger(TimerTask.class.getName());
    private volatile TimerTaskListener mCallback;
    private final Object mValue;

    public TimerTask(TimerTaskListener listener) {
        this(listener, null);
    }

    public TimerTask(TimerTaskListener listener, Object value) {
        this.mCallback = Objects.requireNonNull(listener, "null listener");
        this.mValue = value;
    }

    @Override
    public boolean cancel() {
        this.mCallback = null;
        return super.cancel();
    }

    @Override
    public void run() {
        try {
            this.mCallback.handleTimeout(new TimerEvent(this, this.mValue));
        }
        catch (Exception jex) {
            sLogger.log(Level.WARNING, "TimerTaskListener exception", jex);
        }
    }
}

