/*
 * ex: set ro:
 * DO NOT EDIT.
 * generated by smc (http://smc.sourceforge.net/)
 * from file : RegexLexer.sm.sm
 */


//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2003 - 2010, 2018. Charles W. Rapp.
// All Rights Reserved.
//


package net.sf.eBus.util.regex;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.invoke.MethodType;
import statemap.FSMContext7;
import statemap.State7;
import statemap.TransitionHandle;

public class RegexLexerContext
    extends FSMContext7
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    public RegexLexerContext(final RegexLexer owner)
    {
        this (owner, _States[TokenMap_Start_STATE_ID]);
    }

    public RegexLexerContext(final RegexLexer owner, final int initStateId)
    {
        this (owner, _States[initStateId]);    }

    public RegexLexerContext(final RegexLexer owner, final State7 initState)
    {
        super (initState);

        ctxt = owner;
    }

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FSMContext7 Abstract Method Override.
    //

    @Override
    protected void executeAction(final MethodHandle mh)
    {
        try
        {
            mh.invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }

        return;
    }

    //
    // end of FSMContext7 Abstract Method Override.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Transitions.
    //

    public void EOS()
    {
        _transition = "EOS";
        try
        {
            final TransitionHandle th =
                getState().transition(EOS12_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void Error(String reason)
    {
        _transition = "Error";
        try
        {
            final TransitionHandle th =
                getState().transition(Error14_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, reason);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void OK()
    {
        _transition = "OK";
        try
        {
            final TransitionHandle th =
                getState().transition(OK13_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void OK(int minimumSize, int maximumSize)
    {
        _transition = "OK";
        try
        {
            final TransitionHandle th =
                getState().transition(OK20_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, minimumSize, maximumSize);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void alpha(int c)
    {
        _transition = "alpha";
        try
        {
            final TransitionHandle th =
                getState().transition(alpha3_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void asterisk(int c)
    {
        _transition = "asterisk";
        try
        {
            final TransitionHandle th =
                getState().transition(asterisk15_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void backslash(int c)
    {
        _transition = "backslash";
        try
        {
            final TransitionHandle th =
                getState().transition(backslash8_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void comma(int c)
    {
        _transition = "comma";
        try
        {
            final TransitionHandle th =
                getState().transition(comma7_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void dash(int c)
    {
        _transition = "dash";
        try
        {
            final TransitionHandle th =
                getState().transition(dash5_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void digit(int c)
    {
        _transition = "digit";
        try
        {
            final TransitionHandle th =
                getState().transition(digit4_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void escape_done(int c)
    {
        _transition = "escape_done";
        try
        {
            final TransitionHandle th =
                getState().transition(escape_done9_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void escape_error(String reason)
    {
        _transition = "escape_error";
        try
        {
            final TransitionHandle th =
                getState().transition(escape_error11_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, reason);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void escape_set()
    {
        _transition = "escape_set";
        try
        {
            final TransitionHandle th =
                getState().transition(escape_set10_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void left_brace(int c)
    {
        _transition = "left_brace";
        try
        {
            final TransitionHandle th =
                getState().transition(left_brace18_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void left_bracket(int c)
    {
        _transition = "left_bracket";
        try
        {
            final TransitionHandle th =
                getState().transition(left_bracket2_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void period(int c)
    {
        _transition = "period";
        try
        {
            final TransitionHandle th =
                getState().transition(period1_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void plus(int c)
    {
        _transition = "plus";
        try
        {
            final TransitionHandle th =
                getState().transition(plus16_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void question_mark(int c)
    {
        _transition = "question_mark";
        try
        {
            final TransitionHandle th =
                getState().transition(question_mark17_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void right_brace(int c)
    {
        _transition = "right_brace";
        try
        {
            final TransitionHandle th =
                getState().transition(right_brace22_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void right_bracket(int c)
    {
        _transition = "right_bracket";
        try
        {
            final TransitionHandle th =
                getState().transition(right_bracket21_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void up_arrow(int c)
    {
        _transition = "up_arrow";
        try
        {
            final TransitionHandle th =
                getState().transition(up_arrow6_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    //
    // end of Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Default State Transitions.
    //

    private void TokenMap_Default_right_bracket(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("']' has no matching '['");
        }
        finally
        {
            setState(_States[TokenMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Default_left_brace(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("'{' not after literal, '[]' or '.'");
        }
        finally
        {
            setState(_States[TokenMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Default_right_brace(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("'}' has no matching '{'");
        }
        finally
        {
            setState(_States[TokenMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Default_EOS()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("unexpected end-of-string");
        }
        finally
        {
            setState(_States[TokenMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("unexpected character");
        }
        finally
        {
            setState(_States[TokenMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Start State Transitions.
    //

    private void TokenMap_Start_EOS()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.done();
        }
        finally
        {
            setState(_States[TokenMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_alpha(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.startToken(Component.LITERAL);
            ctxt.literal(c);
        }
        finally
        {
            setState(_States[TokenMap_Range_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_backslash(int c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
            pushState(_States[TokenMap_Escape_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_comma(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.startToken(Component.LITERAL);
            ctxt.literal(c);
        }
        finally
        {
            setState(_States[TokenMap_Range_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_dash(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.startToken(Component.LITERAL);
            ctxt.literal(c);
        }
        finally
        {
            setState(_States[TokenMap_Range_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_digit(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.startToken(Component.LITERAL);
            ctxt.literal(c);
        }
        finally
        {
            setState(_States[TokenMap_Range_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_escape_done(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.startToken(Component.LITERAL);
            ctxt.literal(c);
        }
        finally
        {
            setState(_States[TokenMap_Range_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_escape_error(String reason)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken(reason);
        }
        finally
        {
            setState(_States[TokenMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_escape_set()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[TokenMap_Range_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_left_bracket(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.startToken(Component.CHARACTER_SET);
        }
        finally
        {
            setState(_States[TokenMap_CharacterSet_STATE_ID]);
            enterState();
            pushState(_States[CharacterSetMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_period(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.startToken(Component.ANY_CHAR);
        }
        finally
        {
            setState(_States[TokenMap_Range_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_up_arrow(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.startToken(Component.LITERAL);
            ctxt.literal(c);
        }
        finally
        {
            setState(_States[TokenMap_Range_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Start State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.CharacterSet State Transitions.
    //

    private void TokenMap_CharacterSet_Error(String reason)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken(reason);
        }
        finally
        {
            setState(_States[TokenMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_CharacterSet_OK()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[TokenMap_Range_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.CharacterSet State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Range State Transitions.
    //

    private void TokenMap_Range_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.unreadChar();
            ctxt.endToken(1, 1);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Range_EOS()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.unreadChar();
            ctxt.endToken(1, 1);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Range_asterisk(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(0, Component.NO_MAX_MATCH_LIMIT);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Range_left_brace(int c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
            setState(_States[TokenMap_RangeStart_STATE_ID]);
            enterState();
            pushState(_States[RangeMap_MinimumSize_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Range_plus(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(1, Component.NO_MAX_MATCH_LIMIT);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Range_question_mark(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(0, 1);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Range State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.RangeStart State Transitions.
    //

    private void TokenMap_RangeStart_Error(String reason)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken(reason);
        }
        finally
        {
            setState(_States[TokenMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_RangeStart_OK(int minimumSize, int maximumSize)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(minimumSize, maximumSize);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.RangeStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Escape State Transitions.
    //

    private void TokenMap_Escape_alpha(int c)
    {
        final int stateId = _state.getId();

        if (c == 'n')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            escape_done( '\n');
        }
        else if (c == 'r')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            escape_done( '\r');
        }
        else if (c == 'f')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            escape_done( '\f');
        }
        else if (c == 'a')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            escape_done( 0x07);
        }
        else if (c == 'e')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            escape_done( 0x1B);
        }
        else if (c == 'x')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_Hex2_STATE_ID]);
            }

            enterState();
        }
        else if (c == 'u')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_Hex4_STATE_ID]);
            }

            enterState();
        }
        else if (c == 'd')
        {
            exitState();

            try
            {
                clearState();
                ctxt.startToken(Component.CHARACTER_SET);
                ctxt.addToSet(RegexLexer.DIGIT_FIRST, RegexLexer.DIGIT_LAST);
            }
            finally
            {
                popState();
            }


            escape_set();
        }
        else if (c == 'D')
        {
            exitState();

            try
            {
                clearState();
                ctxt.startToken(Component.CHARACTER_SET);
                ctxt.addToSet(RegexLexer.DIGIT_FIRST, RegexLexer.DIGIT_LAST);
                ctxt.negatedFlag(true);
            }
            finally
            {
                popState();
            }


            escape_set();
        }
        else if (c == 's')
        {
            exitState();

            try
            {
                clearState();
                ctxt.startToken(Component.CHARACTER_SET);
                ctxt.addToSet(RegexLexer.WHITESPACE);
            }
            finally
            {
                popState();
            }


            escape_set();
        }
        else if (c == 'S')
        {
            exitState();

            try
            {
                clearState();
                ctxt.startToken(Component.CHARACTER_SET);
                ctxt.addToSet(RegexLexer.WHITESPACE);
                ctxt.negatedFlag(true);
            }
            finally
            {
                popState();
            }


            escape_set();
        }
        else if (c == 'w')
        {
            exitState();

            try
            {
                clearState();
                ctxt.startToken(Component.CHARACTER_SET);
                ctxt.addToSet(RegexLexer.LC_ALPHA_FIRST, RegexLexer.LC_ALPHA_LAST);
                ctxt.addToSet(RegexLexer.UC_ALPHA_FIRST, RegexLexer.UC_ALPHA_LAST);
                ctxt.addToSet('_');
                ctxt.addToSet(RegexLexer.DIGIT_FIRST, RegexLexer.DIGIT_LAST);
            }
            finally
            {
                popState();
            }


            escape_set();
        }
        else if (c == 'W')
        {
            exitState();

            try
            {
                clearState();
                ctxt.startToken(Component.CHARACTER_SET);
                ctxt.addToSet(RegexLexer.LC_ALPHA_FIRST, RegexLexer.LC_ALPHA_LAST);
                ctxt.addToSet(RegexLexer.UC_ALPHA_FIRST, RegexLexer.UC_ALPHA_LAST);
                ctxt.addToSet('_');
                ctxt.addToSet(RegexLexer.DIGIT_FIRST, RegexLexer.DIGIT_LAST);
                ctxt.negatedFlag(true);
            }
            finally
            {
                popState();
            }


            escape_set();
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                popState();
            }


            escape_error( "invalid escape sequence");
        }

        return;
    }


    private void TokenMap_Escape_asterisk(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_backslash(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_comma(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_dash(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_digit(int c)
    {
        final int stateId = _state.getId();

        if (c == '0')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_Octal_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                popState();
            }


            escape_done( c);
        }

        return;
    }


    private void TokenMap_Escape_left_brace(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_left_bracket(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_period(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_plus(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_question_mark(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_right_brace(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_right_bracket(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    private void TokenMap_Escape_up_arrow(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( c);

        return;
    }


    //
    // end of TokenMap.Escape State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Octal State Transitions.
    //

    private void TokenMap_Octal_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_error( "invalid octal value");

        return;
    }


    private void TokenMap_Octal_digit(int c)
    {
        final int stateId = _state.getId();

        if (c >= '0' && c <= '7')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_Octal2_STATE_ID]);
            }

            enterState();
        }
        else
        {
            TokenMap_Octal_Default();
        }


        return;
    }


    //
    // end of TokenMap.Octal State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Octal2 State Transitions.
    //

    private void TokenMap_Octal2_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.unreadChar();
        }
        finally
        {
            popState();
        }


        escape_done( ctxt.octalChar());

        return;
    }


    private void TokenMap_Octal2_EOS()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.unreadChar();
        }
        finally
        {
            popState();
        }


        escape_done( ctxt.octalChar());

        return;
    }


    private void TokenMap_Octal2_digit(int c)
    {
        final int stateId = _state.getId();

        if (c >= '0' && c <= '7')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_Octal3_STATE_ID]);
            }

            enterState();
        }
        else
        {
            TokenMap_Octal2_Default();
        }


        return;
    }


    //
    // end of TokenMap.Octal2 State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Octal3 State Transitions.
    //

    private void TokenMap_Octal3_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.unreadChar();
        }
        finally
        {
            popState();
        }


        escape_done( ctxt.octalChar());

        return;
    }


    private void TokenMap_Octal3_EOS()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.unreadChar();
        }
        finally
        {
            popState();
        }


        escape_done( ctxt.octalChar());

        return;
    }


    private void TokenMap_Octal3_digit(int c)
    {
        final int stateId = _state.getId();

        if (c >= '0' && c <= '7' && ctxt.isOctal() == true)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            escape_done( ctxt.octalChar());
        }
        else
        {
            TokenMap_Octal3_Default();
        }


        return;
    }


    //
    // end of TokenMap.Octal3 State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Hex2 State Transitions.
    //

    private void TokenMap_Hex2_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_error( "invalid hexadecimal value");

        return;
    }


    private void TokenMap_Hex2_alpha(int c)
    {
        final int stateId = _state.getId();

        if ((c >= 'a' && c <= 'f') || (c >= 'A' && c <= 'F'))
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_Hex22_STATE_ID]);
            }

            enterState();
        }
        else
        {
            TokenMap_Hex2_Default();
        }


        return;
    }


    private void TokenMap_Hex2_digit(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[TokenMap_Hex22_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Hex2 State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Hex22 State Transitions.
    //

    private void TokenMap_Hex22_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_error( "invalid hexadecimal value");

        return;
    }


    private void TokenMap_Hex22_alpha(int c)
    {
        final int stateId = _state.getId();

        if ((c >= 'a' && c <= 'f') || (c >= 'A' && c <= 'F'))
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            escape_done( ctxt.hexChar());
        }
        else
        {
            TokenMap_Hex22_Default();
        }


        return;
    }


    private void TokenMap_Hex22_digit(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( ctxt.hexChar());

        return;
    }


    //
    // end of TokenMap.Hex22 State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Hex4 State Transitions.
    //

    private void TokenMap_Hex4_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_error( "invalid hexadecimal value");

        return;
    }


    private void TokenMap_Hex4_alpha(int c)
    {
        final int stateId = _state.getId();

        if ((c >= 'a' && c <= 'f') || (c >= 'A' && c <= 'F'))
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_Hex42_STATE_ID]);
            }

            enterState();
        }
        else
        {
            TokenMap_Hex4_Default();
        }


        return;
    }


    private void TokenMap_Hex4_digit(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[TokenMap_Hex42_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Hex4 State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Hex42 State Transitions.
    //

    private void TokenMap_Hex42_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_error( "invalid hexadecimal value");

        return;
    }


    private void TokenMap_Hex42_alpha(int c)
    {
        final int stateId = _state.getId();

        if ((c >= 'a' && c <= 'f') || (c >= 'A' && c <= 'F'))
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_Hex43_STATE_ID]);
            }

            enterState();
        }
        else
        {
            TokenMap_Hex42_Default();
        }


        return;
    }


    private void TokenMap_Hex42_digit(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[TokenMap_Hex43_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Hex42 State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Hex43 State Transitions.
    //

    private void TokenMap_Hex43_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_error( "invalid hexadecimal value");

        return;
    }


    private void TokenMap_Hex43_alpha(int c)
    {
        final int stateId = _state.getId();

        if ((c >= 'a' && c <= 'f') || (c >= 'A' && c <= 'F'))
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_Hex44_STATE_ID]);
            }

            enterState();
        }
        else
        {
            TokenMap_Hex43_Default();
        }


        return;
    }


    private void TokenMap_Hex43_digit(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[TokenMap_Hex44_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Hex43 State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Hex44 State Transitions.
    //

    private void TokenMap_Hex44_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_error( "invalid hexadecimal value");

        return;
    }


    private void TokenMap_Hex44_alpha(int c)
    {
        final int stateId = _state.getId();

        if ((c >= 'a' && c <= 'f') || (c >= 'A' && c <= 'F'))
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            escape_done( ctxt.hexChar());
        }
        else
        {
            TokenMap_Hex44_Default();
        }


        return;
    }


    private void TokenMap_Hex44_digit(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        escape_done( ctxt.hexChar());

        return;
    }


    //
    // end of TokenMap.Hex44 State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Done State Entry/Exit Actions.
    //

    private void TokenMap_Done__Entry_()
    {
        ctxt.closeInput();
    }

    //
    // end of TokenMap.Done State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Done State Transitions.
    //

    private void TokenMap_Done_Default()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void TokenMap_Done_left_brace(int c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void TokenMap_Done_right_brace(int c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void TokenMap_Done_right_bracket(int c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of TokenMap.Done State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // CharacterSetMap.Default State Transitions.
    //

    private void CharacterSetMap_Default_EOS()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        Error( "incomplete character set");

        return;
    }


    //
    // end of CharacterSetMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // CharacterSetMap.Start State Transitions.
    //

    private void CharacterSetMap_Start_alpha(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_asterisk(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_backslash(int c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
            pushState(_States[TokenMap_Escape_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_comma(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_dash(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        Error( "'-' must follow a literal");

        return;
    }


    private void CharacterSetMap_Start_digit(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_escape_done(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_left_brace(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_left_bracket(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_period(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_plus(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_question_mark(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_right_brace(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_Start_right_bracket(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        Error( "Empty character set");

        return;
    }


    private void CharacterSetMap_Start_up_arrow(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.negatedFlag(true);
        }
        finally
        {
            setState(_States[CharacterSetMap_NextItem_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of CharacterSetMap.Start State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // CharacterSetMap.FirstItem State Transitions.
    //

    private void CharacterSetMap_FirstItem_alpha(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_asterisk(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_backslash(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
        }
        finally
        {
            setState(_States[stateId]);
            pushState(_States[TokenMap_Escape_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_FirstItem_comma(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_dash(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[CharacterSetMap_SecondItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_FirstItem_digit(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_escape_done(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_left_brace(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_left_bracket(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_period(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_plus(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_question_mark(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_right_brace(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void CharacterSetMap_FirstItem_right_bracket(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
        }
        finally
        {
            popState();
        }


        OK();

        return;
    }


    private void CharacterSetMap_FirstItem_up_arrow(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    //
    // end of CharacterSetMap.FirstItem State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // CharacterSetMap.SecondItem State Transitions.
    //

    private void CharacterSetMap_SecondItem_alpha(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_asterisk(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_backslash(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.addToSet(ctxt.firstCharacter());
        }
        finally
        {
            setState(_States[stateId]);
            pushState(_States[TokenMap_Escape_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_SecondItem_comma(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_dash(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        Error( "'--' not allowed");

        return;
    }


    private void CharacterSetMap_SecondItem_digit(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_escape_done(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_left_brace(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_left_bracket(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_period(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_plus(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_question_mark(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_right_brace(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterSetMap_SecondItem_right_bracket(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        Error( "Missing second item after '-'");

        return;
    }


    private void CharacterSetMap_SecondItem_up_arrow(int c)
    {
        final int stateId = _state.getId();

        if (c <= ctxt.firstCharacter())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "first character >= last character");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.addToSet(ctxt.firstCharacter(), c);
            }
            finally
            {
                setState(_States[CharacterSetMap_NextItem_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of CharacterSetMap.SecondItem State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // CharacterSetMap.NextItem State Transitions.
    //

    private void CharacterSetMap_NextItem_alpha(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_asterisk(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_backslash(int c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
            pushState(_States[TokenMap_Escape_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_comma(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_dash(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        Error( "'-' must follow a literal");

        return;
    }


    private void CharacterSetMap_NextItem_digit(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_escape_done(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_left_brace(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_left_bracket(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_period(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_plus(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_question_mark(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_right_brace(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterSetMap_NextItem_right_bracket(int c)
    {
        final int stateId = _state.getId();

        if (ctxt.characterSetSize() == 0)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "empty character set");
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                popState();
            }


            OK();
        }

        return;
    }


    private void CharacterSetMap_NextItem_up_arrow(int c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.firstCharacter(c);
        }
        finally
        {
            setState(_States[CharacterSetMap_FirstItem_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of CharacterSetMap.NextItem State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RangeMap.Default State Transitions.
    //

    private void RangeMap_Default_EOS()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        Error( "incomplete range");

        return;
    }


    //
    // end of RangeMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RangeMap.MinimumSize State Transitions.
    //

    private void RangeMap_MinimumSize_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        Error( "invalid character in range");

        return;
    }


    private void RangeMap_MinimumSize_comma(int c)
    {
        final int stateId = _state.getId();

        if (ctxt.numberLength() == 0)
        {
            exitState();

            try
            {
                clearState();
                ctxt.minimumSize(RegexLexer.SIZE_NOT_SET);
            }
            finally
            {
                setState(_States[RangeMap_MaximumSize_STATE_ID]);
            }

            enterState();
        }
        else if (ctxt.minimumSize(ctxt.number()) == false)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "invalid minimum size");
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearNumber();
            }
            finally
            {
                setState(_States[RangeMap_MaximumSize_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void RangeMap_MinimumSize_digit(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendNumber(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void RangeMap_MinimumSize_right_brace(int c)
    {
        final int stateId = _state.getId();

        if (ctxt.numberLength() == 0)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "empty range");
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                popState();
            }


            Error( "comma missing");
        }

        return;
    }


    //
    // end of RangeMap.MinimumSize State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RangeMap.MaximumSize State Transitions.
    //

    private void RangeMap_MaximumSize_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        Error( "invalid character in range");

        return;
    }


    private void RangeMap_MaximumSize_digit(int c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendNumber(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void RangeMap_MaximumSize_right_brace(int c)
    {
        final int stateId = _state.getId();

        if (ctxt.numberLength() == 0 &&
       ctxt.minimumSize() == RegexLexer.SIZE_NOT_SET)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            Error( "neither mimimum or maximum size found");
        }
        else if (ctxt.numberLength() == 0)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            OK( ctxt.minimumSize(), Component.NO_MAX_MATCH_LIMIT);
        }
        else if (ctxt.maximumSize(ctxt.number()) == false)
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearNumber();
            }
            finally
            {
                popState();
            }


            Error( "invalid maximum size");
        }
        else if (ctxt.minimumSize() == RegexLexer.SIZE_NOT_SET)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            OK( 0, ctxt.maximumSize());
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearNumber();
            }
            finally
            {
                popState();
            }


            OK( ctxt.minimumSize(), ctxt.maximumSize());
        }

        return;
    }


    //
    // end of RangeMap.MaximumSize State Transitions.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    transient private RegexLexer ctxt;

    //-----------------------------------------------------------
    // Constants.
    //

    private static final long serialVersionUID = 1L;

    public static final int TokenMap_Start_STATE_ID = 0;
    public static final int TokenMap_CharacterSet_STATE_ID = 1;
    public static final int TokenMap_Range_STATE_ID = 2;
    public static final int TokenMap_RangeStart_STATE_ID = 3;
    public static final int TokenMap_Escape_STATE_ID = 4;
    public static final int TokenMap_Octal_STATE_ID = 5;
    public static final int TokenMap_Octal2_STATE_ID = 6;
    public static final int TokenMap_Octal3_STATE_ID = 7;
    public static final int TokenMap_Hex2_STATE_ID = 8;
    public static final int TokenMap_Hex22_STATE_ID = 9;
    public static final int TokenMap_Hex4_STATE_ID = 10;
    public static final int TokenMap_Hex42_STATE_ID = 11;
    public static final int TokenMap_Hex43_STATE_ID = 12;
    public static final int TokenMap_Hex44_STATE_ID = 13;
    public static final int TokenMap_Done_STATE_ID = 14;

    public static final int CharacterSetMap_Start_STATE_ID = 15;
    public static final int CharacterSetMap_FirstItem_STATE_ID = 16;
    public static final int CharacterSetMap_SecondItem_STATE_ID = 17;
    public static final int CharacterSetMap_NextItem_STATE_ID = 18;

    public static final int RangeMap_MinimumSize_STATE_ID = 19;
    public static final int RangeMap_MaximumSize_STATE_ID = 20;

    private static final int STATE_COUNT = 21;

    private static final int EOS12_TRANSITION_ID = 1;
    private static final int Error14_TRANSITION_ID = 2;
    private static final int OK13_TRANSITION_ID = 3;
    private static final int OK20_TRANSITION_ID = 4;
    private static final int alpha3_TRANSITION_ID = 5;
    private static final int asterisk15_TRANSITION_ID = 6;
    private static final int backslash8_TRANSITION_ID = 7;
    private static final int comma7_TRANSITION_ID = 8;
    private static final int dash5_TRANSITION_ID = 9;
    private static final int digit4_TRANSITION_ID = 10;
    private static final int escape_done9_TRANSITION_ID = 11;
    private static final int escape_error11_TRANSITION_ID = 12;
    private static final int escape_set10_TRANSITION_ID = 13;
    private static final int left_brace18_TRANSITION_ID = 14;
    private static final int left_bracket2_TRANSITION_ID = 15;
    private static final int period1_TRANSITION_ID = 16;
    private static final int plus16_TRANSITION_ID = 17;
    private static final int question_mark17_TRANSITION_ID = 18;
    private static final int right_brace22_TRANSITION_ID = 19;
    private static final int right_bracket21_TRANSITION_ID = 20;
    private static final int up_arrow6_TRANSITION_ID = 21;

    private static final int TRANSITION_COUNT = 22;

    private static final MethodType[] TRANSITION_TYPES =
    {
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, String.class),
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, int.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, String.class),
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, int.class)
    };

    private static final String[] MAP_NAMES =
    {
        "TokenMap",
        "CharacterSetMap",
        "RangeMap"
    };

    private static final String[][] STATE_NAMES =
    {
        new String[]
        {
            "Start",
            "CharacterSet",
            "Range",
            "RangeStart",
            "Escape",
            "Octal",
            "Octal2",
            "Octal3",
            "Hex2",
            "Hex22",
            "Hex4",
            "Hex42",
            "Hex43",
            "Hex44",
            "Done"
        },

        new String[]
        {
            "Start",
            "FirstItem",
            "SecondItem",
            "NextItem"
        },

        new String[]
        {
            "MinimumSize",
            "MaximumSize"
        }
    };

    private static String[][] STATE_TRANSITIONS =
    {
        new String[]
        {
            "EOS",
            "alpha",
            "backslash",
            "comma",
            "dash",
            "digit",
            "escape_done",
            "escape_error",
            "escape_set",
            "left_bracket",
            "period",
            "up_arrow"
        },

        new String[]
        {
            "Error",
            "OK"
        },

        new String[]
        {
            "Default",
            "EOS",
            "asterisk",
            "left_brace",
            "plus",
            "question_mark"
        },

        new String[]
        {
            "Error",
            "OK"
        },

        new String[]
        {
            "alpha",
            "asterisk",
            "backslash",
            "comma",
            "dash",
            "digit",
            "left_brace",
            "left_bracket",
            "period",
            "plus",
            "question_mark",
            "right_brace",
            "right_bracket",
            "up_arrow"
        },

        new String[]
        {
            "Default",
            "digit"
        },

        new String[]
        {
            "Default",
            "EOS",
            "digit"
        },

        new String[]
        {
            "Default",
            "EOS",
            "digit"
        },

        new String[]
        {
            "Default",
            "alpha",
            "digit"
        },

        new String[]
        {
            "Default",
            "alpha",
            "digit"
        },

        new String[]
        {
            "Default",
            "alpha",
            "digit"
        },

        new String[]
        {
            "Default",
            "alpha",
            "digit"
        },

        new String[]
        {
            "Default",
            "alpha",
            "digit"
        },

        new String[]
        {
            "Default",
            "alpha",
            "digit"
        },

        new String[]
        {
            "Default",
            "left_brace",
            "right_brace",
            "right_bracket"
        },

        new String[]
        {
            "alpha",
            "asterisk",
            "backslash",
            "comma",
            "dash",
            "digit",
            "escape_done",
            "left_brace",
            "left_bracket",
            "period",
            "plus",
            "question_mark",
            "right_brace",
            "right_bracket",
            "up_arrow"
        },

        new String[]
        {
            "alpha",
            "asterisk",
            "backslash",
            "comma",
            "dash",
            "digit",
            "escape_done",
            "left_brace",
            "left_bracket",
            "period",
            "plus",
            "question_mark",
            "right_brace",
            "right_bracket",
            "up_arrow"
        },

        new String[]
        {
            "alpha",
            "asterisk",
            "backslash",
            "comma",
            "dash",
            "digit",
            "escape_done",
            "left_brace",
            "left_bracket",
            "period",
            "plus",
            "question_mark",
            "right_brace",
            "right_bracket",
            "up_arrow"
        },

        new String[]
        {
            "alpha",
            "asterisk",
            "backslash",
            "comma",
            "dash",
            "digit",
            "escape_done",
            "left_brace",
            "left_bracket",
            "period",
            "plus",
            "question_mark",
            "right_brace",
            "right_bracket",
            "up_arrow"
        },

        new String[]
        {
            "Default",
            "comma",
            "digit",
            "right_brace"
        },

        new String[]
        {
            "Default",
            "digit",
            "right_brace"
        }
    };

    private static final String[] TRANSITION_NAMES =
    {
        "Default",
        "EOS",
        "Error",
        "OK",
        "OK",
        "alpha",
        "asterisk",
        "backslash",
        "comma",
        "dash",
        "digit",
        "escape_done",
        "escape_error",
        "escape_set",
        "left_brace",
        "left_bracket",
        "period",
        "plus",
        "question_mark",
        "right_brace",
        "right_bracket",
        "up_arrow"
    };

    private static final State7[] _States = new State7[STATE_COUNT];

    static
    {
        final Lookup lookup = MethodHandles.lookup();
        final Class<?> clazz = RegexLexerContext.class;
        final int mapSize = MAP_NAMES.length;
        int stateSize;
        int mapIndex;
        int stateIndex;
        int transIndex;
        int stateId = 0;
        String mapName;
        String stateName;
        String transName;
        String methodName;
        MethodType transType;
        MethodHandle entryHandle;
        MethodHandle exitHandle;
        TransitionHandle[] transitions;

        for (mapIndex = 0; mapIndex < mapSize; ++mapIndex)
        {
            mapName = MAP_NAMES[mapIndex];
            stateSize = STATE_NAMES[mapIndex].length;

            for (stateIndex = 0; stateIndex < stateSize; ++stateIndex, ++stateId)
            {
                stateName = STATE_NAMES[mapIndex][stateIndex];
                transitions = new TransitionHandle[TRANSITION_COUNT];

                methodName = String.format(ENTRY_NAME, mapName, stateName);
                entryHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);
                methodName = String.format(EXIT_NAME, mapName, stateName);
                exitHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);

                for (transIndex = 1; transIndex < TRANSITION_COUNT; ++transIndex)
                {
                    transName = TRANSITION_NAMES[transIndex];
                    transType = TRANSITION_TYPES[transIndex];
                    transitions[transIndex] =
                        lookupTransition(lookup, clazz, mapName, stateName, transName, transType);
                }

                _States[stateId] =
                    new State7(
                        String.format(STATE_NAME_FORMAT, mapName, stateName),
                        stateId,
                        entryHandle,
                        exitHandle,
                        transitions,
                        STATE_TRANSITIONS[stateId]);

            }
        }
    }
}

/*
 * Local variables:
 *  buffer-read-only: t
 * End:
 */
