//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2004 - 2008. Charles W. Rapp.
// All Rights Reserved.
//

package net.sf.eBus.util;

import java.util.EventObject;

/**
 * Contains the updated {@link Properties} object as event
 * source. Retrieve the Properties object by calling
 * {@code getSource()} and casting the return value
 * to {@link Properties}.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public final class PropertiesEvent
    extends EventObject
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * The specified properties have changed.
     * @param properties the event's source.
     * @throws IllegalArgumentException
     * if {@code properties} is {@code null}.
     */
    public PropertiesEvent(final Properties properties)
        throws IllegalArgumentException
    {
        super (properties);

        if (properties == null)
        {
            throw (
                new IllegalArgumentException("null properties"));
        }
    } // end of PropertiesEvent(Properties)

    //
    // end of Constructors.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     *  This is eBus version 2.1.0.
     */
    private static final long serialVersionUID = 0x020100L;
} // end of class PropertiesEvent

//
// CHANGE LOG
// $Log: PropertiesEvent.java,v $
// Revision 1.1  2005/07/22 01:35:45  charlesr
// Move to Java 5.
//
// Revision 1.0  2004/03/02 23:20:00  charlesr
// Initial revision
//
