/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.io.Serializable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;

public final class IndexPool
implements Serializable {
    private AtomicInteger _nextIndex;
    private final int _minIndex;
    private final int _maxIndex;
    private ConcurrentLinkedDeque<Integer> _pool;
    private static final long serialVersionUID = 131588L;

    public IndexPool() {
        this(0, Integer.MAX_VALUE);
    }

    public IndexPool(int minIndex, int maxIndex) throws IllegalArgumentException {
        if (minIndex < 0) {
            throw new IllegalArgumentException("minIndex < 0 (" + Integer.toString(minIndex) + ")");
        }
        if (maxIndex < 0) {
            throw new IllegalArgumentException("maxIndex < 0 (" + Integer.toString(maxIndex) + ")");
        }
        if (minIndex > maxIndex) {
            throw new IllegalArgumentException("minIndex (" + Integer.toString(minIndex) + " > maxIndex (" + Integer.toString(maxIndex) + ")");
        }
        this._nextIndex = new AtomicInteger(minIndex);
        this._minIndex = minIndex;
        this._maxIndex = maxIndex;
        this._pool = new ConcurrentLinkedDeque();
    }

    public String toString() {
        Formatter retval = new Formatter();
        String separator = "";
        retval.format("minimum index = %,d%n", this._minIndex);
        retval.format("maximum index = %,d%n", this._maxIndex);
        retval.format("cached indices = {", new Object[0]);
        Iterator<Integer> pit = this._pool.iterator();
        while (pit.hasNext()) {
            retval.format("%s%,d", separator, pit.next());
            separator = ", ";
        }
        retval.format("}%nnext index = %,d", this._nextIndex.get());
        return retval.toString();
    }

    public int minIndex() {
        return this._minIndex;
    }

    public int maxIndex() {
        return this._maxIndex;
    }

    public int nextIndex() throws IllegalStateException {
        Integer retval = this._pool.pollFirst();
        if (retval == null && (retval = Integer.valueOf(this._nextIndex.getAndIncrement())) > this._maxIndex) {
            throw new IllegalStateException("index pool is exhausted");
        }
        return retval;
    }

    public void returnIndex(int index) throws IndexOutOfBoundsException {
        if (index < this._minIndex) {
            throw new IndexOutOfBoundsException(Integer.toString(index) + " < minimum index" + Integer.toString(this._minIndex));
        }
        if (index > this._maxIndex) {
            throw new IndexOutOfBoundsException(Integer.toString(index) + " > maximum index" + Integer.toString(this._maxIndex));
        }
        this._pool.add(index);
    }

    public void reset() {
        this._nextIndex.set(this._minIndex);
        this._pool.clear();
    }
}

