/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA
 * 02111-1307 USA
 *
 * The Initial Developer of the Original Code is Charles W. Rapp.
 * Portions created by Charles W. Rapp are
 * Copyright 2012. Charles W. Rapp
 * All Rights Reserved.
 */

/**
 * Contains supporting utility Java classes for
 * <code>net.sf.eBus</code>. These utilities either provide
 * capabilities not provided by the Java standard edition or
 * extend existing Java classes:
 * <ul>
 *   <li>
 *     {@link net.sf.eBus.util.EventThread}: Extends
 *     <code>java.lang.Thread</code> to provide event queue
 *     processing. This class provides the thread-safe method
 *     {@link net.sf.eBus.util.EventThread#add(Object)} to
 *     place events on the queue.
 *     Subclasses then provide methods for:
 *     <ol>
 *       <li>
 *         Initializing upon thread start
 *         ({@link net.sf.eBus.util.EventThread#start}).
 *       </li>
 *       <li>
 *         Cleaning up upon thread termination
 *         ({@link net.sf.eBus.util.EventThread#stop}).
 *       </li>
 *       <li>
 *         Override
 *         {@link net.sf.eBus.util.EventThread#handleEvent(Object)}
 *         to process the next event.
 *       </li>
 *     </ol>
 *   </li>
 *   <li>
 *       {@link net.sf.eBus.util.SequentialTask}: Offers a
 *       different solution to the same problem that
 *       {@link net.sf.eBus.util.EventThread} solves: processing
 *       an object's tasks in chronological order.
 *       {@link net.sf.eBus.util.EventThread} is a poor solution
 *       for a large number of threads and infrequent events. A
 *       {@link java.util.concurrent.ExecutorService thread pool}
 *       is preferable but the pool's threads execute tasks in an
 *       undetermined order. If tasks associated with the
 *       <i>same object</i> must execute in chronological order,
 *       {@link net.sf.eBus.util.SequentialTask} guarantees that
 *       ordering. Tasks associated with different objects can
 *       execute in parallel.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.HexDump}: Binary data hex dump
 *     generator.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.IndexCache IndexCache}: Stores the
 *     latest index value in a specified file. This class is used
 *     when a unique index value must be maintained across an
 *     application's separate executions. IndexCache does not
 *     support index sharing by multiple applications running
 *     simultaneously. It is designed to work with a single
 *     application only.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.IndexPool IndexPool}: Tracks which
 *     integer indices are in use and returns to the caller the
 *     minimum index available. For example, if you need to use
 *     an index value between 0 and 99 inclusive and indices
 *     0, 1 and 3 are in use, then
 *     {@link net.sf.eBus.util.IndexPool#nextIndex}
 *     returns 2. The application is responsible for informing
 *     {@link net.sf.eBus.util.IndexPool} when an index in no
 *     longer in use by calling
 *     {@link net.sf.eBus.util.IndexPool#returnIndex(int)}.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.MultiKey MultiKey}: Allows
 *     multiple objects to be used as a single Java map key.
 *     Obviates the need for nested maps.
 *     <p>
 *       The multikey code belongs to Howard Lewis Ship and
 *       Stephen Colebourne and is under the Apache license.
 *     </p>
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.Properties Properties}: Extends
 *     <code>java.lang.Properties</code> class. Provides access to
 *     multiple property files and additional methods for
 *     retrieving <code>boolean</code>, <code>int</code>,
 *     <code>double</code> and <code>String[]</code> arrays from
 *     a properties list or placing into the properties list.
 *     Also provides
 *     {@link net.sf.eBus.util.Properties#addListener(PropertiesListener)} and
 *     {@link net.sf.eBus.util.Properties#removeListener(PropertiesListener)}
 *     methods. When the underlying properties file changes,
 *     Properties reloads the file and then informs all registered
 *     {@link net.sf.eBus.util.PropertiesListener PropertiesListener}s.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.TernarySearchTree TernarySearchTree}:
 *     Implements the Bentley, Sedgewick ternary search tree (TST)
 *     as a Java map. Keys are restricted to Java character
 *     sequences. TST only partially follows the Java Map
 *     interface. The keySet, values and entrySet methods return
 *     collections that are <i>not</i> backed by the map.
 *     Modifying these returned collections does not modify the
 *     map.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.TimerTask TimerTask}: Extends
 *     <code>java.util.TimerTask</code>. Associates a
 *     {@link net.sf.eBus.util.TimerTaskListener} with the
 *     {@link net.sf.eBus.util.TimerTask}. When the timer expires,
 *     {@link net.sf.eBus.util.TimerTaskListener#handleTimeout(TimerEvent)}
 *     is called.
 *   </li>
 * </ul>
 */

package net.sf.eBus.util;
