/*
 * ex: set ro:
 * DO NOT EDIT.
 * generated by smc (http://smc.sourceforge.net/)
 * from file : TokenLexer.sm.sm
 */


//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2001 - 2008, 2011. Charles W. Rapp.
// All Rights Reserved.
//
//
// Tokens
// <name>      ::= [A-Za-z][A-Za-z0-9_]*
//               ;
// <integer>   ::= [+-]{0,1}[0-9]+
//               ;
// <float>     ::= [+-]{0,1}[0-9]*"."[0-9]+
//               | [+-]{0,1}[0-9]+"."[0-9]*
//               ;
// <string>    ::= "*"
//               ;
// <character> ::= '.'
//               ;
// <operator>  ::= [punctuation]+ (user defined)
//               ;
// <delimiter> ::= [punctuation] (user defined)
//               ;


package net.sf.eBus.text;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.invoke.MethodType;
import statemap.FSMContext7;
import statemap.State7;
import statemap.TransitionHandle;

public class TokenLexerContext
    extends FSMContext7
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    public TokenLexerContext(final TokenLexer owner)
    {
        this (owner, _States[TokenMap_Start_STATE_ID]);
    }

    public TokenLexerContext(final TokenLexer owner, final int initStateId)
    {
        this (owner, _States[initStateId]);    }

    public TokenLexerContext(final TokenLexer owner, final State7 initState)
    {
        super (initState);

        ctxt = owner;
    }

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FSMContext7 Abstract Method Override.
    //

    @Override
    protected void executeAction(final MethodHandle mh)
    {
        try
        {
            mh.invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }

        return;
    }

    //
    // end of FSMContext7 Abstract Method Override.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Transitions.
    //

    public void EOF()
    {
        _transition = "EOF";
        try
        {
            final TransitionHandle th =
                getState().transition(EOF6_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void EOL(char c)
    {
        _transition = "EOL";
        try
        {
            final TransitionHandle th =
                getState().transition(EOL2_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void alpha(char c)
    {
        _transition = "alpha";
        try
        {
            final TransitionHandle th =
                getState().transition(alpha3_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void characterDone()
    {
        _transition = "characterDone";
        try
        {
            final TransitionHandle th =
                getState().transition(characterDone10_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void characterError()
    {
        _transition = "characterError";
        try
        {
            final TransitionHandle th =
                getState().transition(characterError11_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void commentDone()
    {
        _transition = "commentDone";
        try
        {
            final TransitionHandle th =
                getState().transition(commentDone13_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void digit(char c)
    {
        _transition = "digit";
        try
        {
            final TransitionHandle th =
                getState().transition(digit4_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void punctuation(char c)
    {
        _transition = "punctuation";
        try
        {
            final TransitionHandle th =
                getState().transition(punctuation5_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void stringDone()
    {
        _transition = "stringDone";
        try
        {
            final TransitionHandle th =
                getState().transition(stringDone8_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void stringError()
    {
        _transition = "stringError";
        try
        {
            final TransitionHandle th =
                getState().transition(stringError9_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void unicode(char c)
    {
        _transition = "unicode";
        try
        {
            final TransitionHandle th =
                getState().transition(unicode12_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void whitespace(char c)
    {
        _transition = "whitespace";
        try
        {
            final TransitionHandle th =
                getState().transition(whitespace1_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, c);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    //
    // end of Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Default State Transitions.
    //

    private void TokenMap_Default_unicode(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
            ctxt.badToken("invalid character");
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void TokenMap_Default_EOL(char c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of TokenMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Start State Transitions.
    //

    private void TokenMap_Start_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("invalid character.");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.EOF);
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_EOL(char c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void TokenMap_Start_alpha(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[TokenMap_Name_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_digit(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[TokenMap_Number_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Start_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (ctxt.isDelimiter(c) == true)
        {
            try
            {
                clearState();
                ctxt.appendToken(c);
                ctxt.endToken(ctxt.delimiterType(c));
            }
            finally
            {
                setState(_States[stateId]);
            }

        }
        else if (c == '+')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_SignOperator_STATE_ID]);
            }

            enterState();
        }
        else if (c == '-')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_SignOperator_STATE_ID]);
            }

            enterState();
        }
        else if (c == '.')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_Period_STATE_ID]);
            }

            enterState();
        }
        else if (c == '/')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_CommentStart_STATE_ID]);
            }

            enterState();
        }
        else if (c == '"')
        {
            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_DoubleQuoteString_STATE_ID]);
                enterState();
                pushState(_States[StringMap_Start_STATE_ID]);
            }

            enterState();
        }
        else if (c == '\'')
        {
            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[TokenMap_SingleQuoteString_STATE_ID]);
                enterState();
                pushState(_States[CharacterMap_Start_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_Operator_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void TokenMap_Start_whitespace(char c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of TokenMap.Start State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.DoubleQuoteString State Transitions.
    //

    private void TokenMap_DoubleQuoteString_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("malformed string");
            ctxt.ungetChar();
            ctxt.endToken(TokenLexer.EOF);
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_DoubleQuoteString_stringDone()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.STRING);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_DoubleQuoteString_stringError()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("malformed string");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.DoubleQuoteString State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.SingleQuoteString State Transitions.
    //

    private void TokenMap_SingleQuoteString_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("malformed single-quote character");
            ctxt.ungetChar();
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_SingleQuoteString_characterDone()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.CHARACTER);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_SingleQuoteString_characterError()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("malformed single-quote character");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.SingleQuoteString State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Name State Transitions.
    //

    private void TokenMap_Name_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.NAME);
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Name_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.NAME);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Name_alpha(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void TokenMap_Name_digit(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void TokenMap_Name_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '_')
        {
            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.ungetChar();
                ctxt.endToken(TokenLexer.NAME);
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void TokenMap_Name_unicode(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[TokenMap_NameError_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Name_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.NAME);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Name State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.NameError State Transitions.
    //

    private void TokenMap_NameError_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("malformed name");
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_NameError_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("malformed name");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_NameError_alpha(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void TokenMap_NameError_digit(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void TokenMap_NameError_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '_')
        {
            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.ungetChar();
                ctxt.badToken("malformed name");
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void TokenMap_NameError_unicode(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[TokenMap_NameError_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_NameError_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("malformed name");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.NameError State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Period State Transitions.
    //

    private void TokenMap_Period_EOF()
    {
        final int stateId = _state.getId();

        if (ctxt.isDelimiter('.') == true)
        {
            exitState();

            try
            {
                clearState();
                ctxt.endToken(ctxt.delimiterType('.'));
            }
            finally
            {
                setState(_States[TokenMap_EndOfFile_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.endToken(TokenLexer.OPERATOR);
            }
            finally
            {
                setState(_States[TokenMap_EndOfFile_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void TokenMap_Period_EOL(char c)
    {
        final int stateId = _state.getId();

        if (ctxt.isDelimiter('.') == true)
        {
            exitState();

            try
            {
                clearState();
                ctxt.endToken(ctxt.delimiterType('.'));
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.endToken(TokenLexer.OPERATOR);
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void TokenMap_Period_alpha(char c)
    {
        final int stateId = _state.getId();

        if (ctxt.isDelimiter('.') == true)
        {
            exitState();

            try
            {
                clearState();
                ctxt.ungetChar();
                ctxt.endToken(ctxt.delimiterType('.'));
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.ungetChar();
                ctxt.endToken(TokenLexer.OPERATOR);
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void TokenMap_Period_digit(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[TokenMap_Mantissa_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Period_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (ctxt.isDelimiter(c) == true)
        {
            exitState();

            try
            {
                clearState();
                ctxt.ungetChar();
                ctxt.endToken(TokenLexer.OPERATOR);
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_Operator_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void TokenMap_Period_whitespace(char c)
    {
        final int stateId = _state.getId();

        if (ctxt.isDelimiter('.') == true)
        {
            exitState();

            try
            {
                clearState();
                ctxt.endToken(ctxt.delimiterType('.'));
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.endToken(TokenLexer.OPERATOR);
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of TokenMap.Period State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.SignOperator State Transitions.
    //

    private void TokenMap_SignOperator_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
        }
        finally
        {
            setState(_States[TokenMap_Operator_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_SignOperator_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_SignOperator_digit(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[TokenMap_Number_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_SignOperator_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '.')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_MantissaStart_STATE_ID]);
            }

            enterState();
        }
        else
        {
            TokenMap_SignOperator_Default();
        }


        return;
    }


    //
    // end of TokenMap.SignOperator State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Number State Transitions.
    //

    private void TokenMap_Number_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.INTEGER);
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Number_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.INTEGER);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Number_alpha(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
            ctxt.badToken("malformed number");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Number_digit(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void TokenMap_Number_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '.')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_MantissaStart_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.ungetChar();
                ctxt.endToken(TokenLexer.INTEGER);
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void TokenMap_Number_unicode(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
            ctxt.badToken("malformed number");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Number_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.INTEGER);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Number State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.MantissaStart State Transitions.
    //

    private void TokenMap_MantissaStart_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.FLOAT);
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_MantissaStart_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.FLOAT);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_MantissaStart_alpha(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
            ctxt.badToken("malformed number");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_MantissaStart_digit(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[TokenMap_Mantissa_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_MantissaStart_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '.')
        {
            exitState();

            try
            {
                clearState();
                ctxt.ungetChar();
                ctxt.badToken("malformed decimal number");
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.ungetChar();
                ctxt.endToken(TokenLexer.FLOAT);
            }
            finally
            {
                setState(_States[TokenMap_Start_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void TokenMap_MantissaStart_unicode(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
            ctxt.badToken("malformed number");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_MantissaStart_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.FLOAT);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.MantissaStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Mantissa State Transitions.
    //

    private void TokenMap_Mantissa_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.FLOAT);
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Mantissa_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.FLOAT);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Mantissa_alpha(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
            ctxt.badToken("malformed number");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Mantissa_digit(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void TokenMap_Mantissa_punctuation(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
            ctxt.endToken(TokenLexer.FLOAT);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Mantissa_unicode(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
            ctxt.badToken("malformed number");
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Mantissa_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.FLOAT);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Mantissa State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.Operator State Transitions.
    //

    private void TokenMap_Operator_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Operator_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Operator_alpha(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Operator_digit(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Operator_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (ctxt.isDelimiter(c) == true)
        {
            try
            {
                clearState();
                ctxt.ungetChar();
                ctxt.endToken(TokenLexer.OPERATOR);
            }
            finally
            {
                setState(_States[stateId]);
            }

        }
        else
        {
            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[stateId]);
            }

        }

        return;
    }


    private void TokenMap_Operator_unicode(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_Operator_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.Operator State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.CommentStart State Transitions.
    //

    private void TokenMap_CommentStart_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_CommentStart_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_CommentStart_alpha(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_CommentStart_digit(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_CommentStart_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '*')
        {
            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_OldComment_STATE_ID]);
                enterState();
                pushState(_States[OldCommentMap_Start_STATE_ID]);
            }

            enterState();
        }
        else if (c == '/')
        {
            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_NewComment_STATE_ID]);
                enterState();
                pushState(_States[NewCommentMap_Start_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[TokenMap_Operator_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void TokenMap_CommentStart_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.OPERATOR);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.CommentStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.OldComment State Transitions.
    //

    private void TokenMap_OldComment_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("missing */ to end comment.");
            ctxt.ungetChar();
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_OldComment_commentDone()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.COMMENT);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.OldComment State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.NewComment State Transitions.
    //

    private void TokenMap_NewComment_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.ungetChar();
            ctxt.endToken(TokenLexer.COMMENT);
        }
        finally
        {
            setState(_States[TokenMap_EndOfFile_STATE_ID]);
        }

        enterState();

        return;
    }


    private void TokenMap_NewComment_commentDone()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.COMMENT);
        }
        finally
        {
            setState(_States[TokenMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of TokenMap.NewComment State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // TokenMap.EndOfFile State Transitions.
    //

    private void TokenMap_EndOfFile_Default()
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.endToken(TokenLexer.EOF);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    //
    // end of TokenMap.EndOfFile State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // StringMap.Default State Transitions.
    //

    private void StringMap_Default_alpha(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[StringMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void StringMap_Default_digit(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[StringMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void StringMap_Default_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[StringMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void StringMap_Default_punctuation(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[StringMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void StringMap_Default_unicode(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[StringMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void StringMap_Default_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        EOF();

        return;
    }


    //
    // end of StringMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // StringMap.Start State Transitions.
    //

    private void StringMap_Start_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        stringError();

        return;
    }


    private void StringMap_Start_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("strings may not contain end-of-line");
        }
        finally
        {
            setState(_States[StringMap_BadString_STATE_ID]);
        }

        enterState();

        return;
    }


    private void StringMap_Start_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '"')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            stringDone();
        }
        else if (c == '\\')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[StringMap_Escaped_STATE_ID]);
            }

            enterState();
        }
        else
        {
            StringMap_Default_punctuation(c);
        }


        return;
    }


    //
    // end of StringMap.Start State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // StringMap.Escaped State Transitions.
    //

    private void StringMap_Escaped_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.badToken("malformed string");
        }
        finally
        {
            setState(_States[StringMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of StringMap.Escaped State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // StringMap.BadString State Transitions.
    //

    private void StringMap_BadString_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '"')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            stringError();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    private void StringMap_BadString_unicode(char c)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of StringMap.BadString State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // CharacterMap.Default State Transitions.
    //

    private void CharacterMap_Default_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        EOF();

        return;
    }


    //
    // end of CharacterMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // CharacterMap.Start State Transitions.
    //

    private void CharacterMap_Start_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[CharacterMap_BadCharacter_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterMap_Start_alpha(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[CharacterMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterMap_Start_digit(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[CharacterMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterMap_Start_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '\'')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            characterError();
        }
        else if (c == '\\')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[CharacterMap_Escaped_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[CharacterMap_Done_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void CharacterMap_Start_unicode(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[CharacterMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterMap_Start_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[CharacterMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of CharacterMap.Start State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // CharacterMap.Escaped State Transitions.
    //

    private void CharacterMap_Escaped_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[CharacterMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterMap_Escaped_alpha(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[CharacterMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterMap_Escaped_digit(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[CharacterMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterMap_Escaped_punctuation(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[CharacterMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterMap_Escaped_unicode(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[CharacterMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterMap_Escaped_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[CharacterMap_Done_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of CharacterMap.Escaped State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // CharacterMap.Done State Transitions.
    //

    private void CharacterMap_Done_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[CharacterMap_BadCharacter_STATE_ID]);
        }

        enterState();

        return;
    }


    private void CharacterMap_Done_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '\'')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            characterDone();
        }
        else
        {
            CharacterMap_Done_Default();
        }


        return;
    }


    //
    // end of CharacterMap.Done State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // CharacterMap.BadCharacter State Transitions.
    //

    private void CharacterMap_BadCharacter_Default()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void CharacterMap_BadCharacter_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '\'')
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                popState();
            }


            characterError();
        }
        else
        {
            CharacterMap_BadCharacter_Default();
        }


        return;
    }


    //
    // end of CharacterMap.BadCharacter State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OldCommentMap.Default State Transitions.
    //

    private void OldCommentMap_Default_alpha(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[OldCommentMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OldCommentMap_Default_digit(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[OldCommentMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OldCommentMap_Default_whitespace(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[OldCommentMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OldCommentMap_Default_punctuation(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[OldCommentMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OldCommentMap_Default_unicode(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[OldCommentMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OldCommentMap_Default_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[OldCommentMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OldCommentMap_Default_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        EOF();

        return;
    }


    //
    // end of OldCommentMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OldCommentMap.Start State Transitions.
    //

    private void OldCommentMap_Start_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '/')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[OldCommentMap_CommentStart_STATE_ID]);
            }

            enterState();
        }
        else if (c == '*')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[OldCommentMap_CommentEnd_STATE_ID]);
            }

            enterState();
        }
        else
        {
            OldCommentMap_Default_punctuation(c);
        }


        return;
    }


    //
    // end of OldCommentMap.Start State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OldCommentMap.CommentStart State Transitions.
    //

    private void OldCommentMap_CommentStart_commentDone()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[OldCommentMap_Start_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OldCommentMap_CommentStart_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '*')
        {
            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[stateId]);
                pushState(_States[OldCommentMap_Start_STATE_ID]);
            }

            enterState();
        }
        else if (c == '/')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[OldCommentMap_Start_STATE_ID]);
            }

            enterState();
        }
        else
        {
            OldCommentMap_Default_punctuation(c);
        }


        return;
    }


    //
    // end of OldCommentMap.CommentStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OldCommentMap.CommentEnd State Transitions.
    //

    private void OldCommentMap_CommentEnd_punctuation(char c)
    {
        final int stateId = _state.getId();

        if (c == '*')
        {
            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                setState(_States[stateId]);
            }

        }
        else if (c == '/')
        {
            exitState();

            try
            {
                clearState();
                ctxt.appendToken(c);
            }
            finally
            {
                popState();
            }


            commentDone();
        }
        else
        {
            OldCommentMap_Default_punctuation(c);
        }


        return;
    }


    //
    // end of OldCommentMap.CommentEnd State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NewCommentMap.Start State Transitions.
    //

    private void NewCommentMap_Start_EOF()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        EOF();

        return;
    }


    private void NewCommentMap_Start_EOL(char c)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            popState();
        }


        commentDone();

        return;
    }


    private void NewCommentMap_Start_alpha(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void NewCommentMap_Start_digit(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void NewCommentMap_Start_punctuation(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void NewCommentMap_Start_unicode(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void NewCommentMap_Start_whitespace(char c)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.appendToken(c);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    //
    // end of NewCommentMap.Start State Transitions.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    transient private TokenLexer ctxt;

    //-----------------------------------------------------------
    // Constants.
    //

    private static final long serialVersionUID = 1L;

    public static final int TokenMap_Start_STATE_ID = 0;
    public static final int TokenMap_DoubleQuoteString_STATE_ID = 1;
    public static final int TokenMap_SingleQuoteString_STATE_ID = 2;
    public static final int TokenMap_Name_STATE_ID = 3;
    public static final int TokenMap_NameError_STATE_ID = 4;
    public static final int TokenMap_Period_STATE_ID = 5;
    public static final int TokenMap_SignOperator_STATE_ID = 6;
    public static final int TokenMap_Number_STATE_ID = 7;
    public static final int TokenMap_MantissaStart_STATE_ID = 8;
    public static final int TokenMap_Mantissa_STATE_ID = 9;
    public static final int TokenMap_Operator_STATE_ID = 10;
    public static final int TokenMap_CommentStart_STATE_ID = 11;
    public static final int TokenMap_OldComment_STATE_ID = 12;
    public static final int TokenMap_NewComment_STATE_ID = 13;
    public static final int TokenMap_EndOfFile_STATE_ID = 14;

    public static final int StringMap_Start_STATE_ID = 15;
    public static final int StringMap_Escaped_STATE_ID = 16;
    public static final int StringMap_BadString_STATE_ID = 17;

    public static final int CharacterMap_Start_STATE_ID = 18;
    public static final int CharacterMap_Escaped_STATE_ID = 19;
    public static final int CharacterMap_Done_STATE_ID = 20;
    public static final int CharacterMap_BadCharacter_STATE_ID = 21;

    public static final int OldCommentMap_Start_STATE_ID = 22;
    public static final int OldCommentMap_CommentStart_STATE_ID = 23;
    public static final int OldCommentMap_CommentEnd_STATE_ID = 24;

    public static final int NewCommentMap_Start_STATE_ID = 25;

    private static final int STATE_COUNT = 26;

    private static final int EOF6_TRANSITION_ID = 1;
    private static final int EOL2_TRANSITION_ID = 2;
    private static final int alpha3_TRANSITION_ID = 3;
    private static final int characterDone10_TRANSITION_ID = 4;
    private static final int characterError11_TRANSITION_ID = 5;
    private static final int commentDone13_TRANSITION_ID = 6;
    private static final int digit4_TRANSITION_ID = 7;
    private static final int punctuation5_TRANSITION_ID = 8;
    private static final int stringDone8_TRANSITION_ID = 9;
    private static final int stringError9_TRANSITION_ID = 10;
    private static final int unicode12_TRANSITION_ID = 11;
    private static final int whitespace1_TRANSITION_ID = 12;

    private static final int TRANSITION_COUNT = 13;

    private static final MethodType[] TRANSITION_TYPES =
    {
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, char.class),
        MethodType.methodType(void.class, char.class),
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, char.class),
        MethodType.methodType(void.class, char.class),
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, char.class),
        MethodType.methodType(void.class, char.class)
    };

    private static final String[] MAP_NAMES =
    {
        "TokenMap",
        "StringMap",
        "CharacterMap",
        "OldCommentMap",
        "NewCommentMap"
    };

    private static final String[][] STATE_NAMES =
    {
        new String[]
        {
            "Start",
            "DoubleQuoteString",
            "SingleQuoteString",
            "Name",
            "NameError",
            "Period",
            "SignOperator",
            "Number",
            "MantissaStart",
            "Mantissa",
            "Operator",
            "CommentStart",
            "OldComment",
            "NewComment",
            "EndOfFile"
        },

        new String[]
        {
            "Start",
            "Escaped",
            "BadString"
        },

        new String[]
        {
            "Start",
            "Escaped",
            "Done",
            "BadCharacter"
        },

        new String[]
        {
            "Start",
            "CommentStart",
            "CommentEnd"
        },

        new String[]
        {
            "Start"
        }
    };

    private static String[][] STATE_TRANSITIONS =
    {
        new String[]
        {
            "Default",
            "EOF",
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "whitespace"
        },

        new String[]
        {
            "EOF",
            "stringDone",
            "stringError"
        },

        new String[]
        {
            "EOF",
            "characterDone",
            "characterError"
        },

        new String[]
        {
            "EOF",
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "unicode",
            "whitespace"
        },

        new String[]
        {
            "EOF",
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "unicode",
            "whitespace"
        },

        new String[]
        {
            "EOF",
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "whitespace"
        },

        new String[]
        {
            "Default",
            "EOF",
            "digit",
            "punctuation"
        },

        new String[]
        {
            "EOF",
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "unicode",
            "whitespace"
        },

        new String[]
        {
            "EOF",
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "unicode",
            "whitespace"
        },

        new String[]
        {
            "EOF",
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "unicode",
            "whitespace"
        },

        new String[]
        {
            "EOF",
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "unicode",
            "whitespace"
        },

        new String[]
        {
            "EOF",
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "whitespace"
        },

        new String[]
        {
            "EOF",
            "commentDone"
        },

        new String[]
        {
            "EOF",
            "commentDone"
        },

        new String[]
        {
            "Default"
        },

        new String[]
        {
            "EOF",
            "EOL",
            "punctuation"
        },

        new String[]
        {
            "EOL"
        },

        new String[]
        {
            "punctuation",
            "unicode"
        },

        new String[]
        {
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "unicode",
            "whitespace"
        },

        new String[]
        {
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "unicode",
            "whitespace"
        },

        new String[]
        {
            "Default",
            "punctuation"
        },

        new String[]
        {
            "Default",
            "punctuation"
        },

        new String[]
        {
            "punctuation"
        },

        new String[]
        {
            "commentDone",
            "punctuation"
        },

        new String[]
        {
            "punctuation"
        },

        new String[]
        {
            "EOF",
            "EOL",
            "alpha",
            "digit",
            "punctuation",
            "unicode",
            "whitespace"
        }
    };

    private static final String[] TRANSITION_NAMES =
    {
        "Default",
        "EOF",
        "EOL",
        "alpha",
        "characterDone",
        "characterError",
        "commentDone",
        "digit",
        "punctuation",
        "stringDone",
        "stringError",
        "unicode",
        "whitespace"
    };

    private static final State7[] _States = new State7[STATE_COUNT];

    static
    {
        final Lookup lookup = MethodHandles.lookup();
        final Class<?> clazz = TokenLexerContext.class;
        final int mapSize = MAP_NAMES.length;
        int stateSize;
        int mapIndex;
        int stateIndex;
        int transIndex;
        int stateId = 0;
        String mapName;
        String stateName;
        String transName;
        String methodName;
        MethodType transType;
        MethodHandle entryHandle;
        MethodHandle exitHandle;
        TransitionHandle[] transitions;

        for (mapIndex = 0; mapIndex < mapSize; ++mapIndex)
        {
            mapName = MAP_NAMES[mapIndex];
            stateSize = STATE_NAMES[mapIndex].length;

            for (stateIndex = 0; stateIndex < stateSize; ++stateIndex, ++stateId)
            {
                stateName = STATE_NAMES[mapIndex][stateIndex];
                transitions = new TransitionHandle[TRANSITION_COUNT];

                methodName = String.format(ENTRY_NAME, mapName, stateName);
                entryHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);
                methodName = String.format(EXIT_NAME, mapName, stateName);
                exitHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);

                for (transIndex = 1; transIndex < TRANSITION_COUNT; ++transIndex)
                {
                    transName = TRANSITION_NAMES[transIndex];
                    transType = TRANSITION_TYPES[transIndex];
                    transitions[transIndex] =
                        lookupTransition(lookup, clazz, mapName, stateName, transName, transType);
                }

                _States[stateId] =
                    new State7(
                        String.format(STATE_NAME_FORMAT, mapName, stateName),
                        stateId,
                        entryHandle,
                        exitHandle,
                        transitions,
                        STATE_TRANSITIONS[stateId]);

            }
        }
    }
}

/*
 * Local variables:
 *  buffer-read-only: t
 * End:
 */
