/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.regex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.PatternSyntaxException;
import net.sf.eBus.util.regex.Component;
import net.sf.eBus.util.regex.RegexLexer;

public final class Pattern
implements Comparable<Pattern>,
Serializable {
    private final String _pattern;
    private final Component[] _components;
    private final int _minimumSize;
    private final int _maximumSize;
    private static final long serialVersionUID = 131328L;

    private Pattern(String pattern, Component[] components, int minSize, int maxSize) {
        this._pattern = pattern;
        this._components = components;
        this._minimumSize = minSize;
        this._maximumSize = maxSize;
    }

    @Override
    public int compareTo(Pattern pattern) {
        return this._pattern.compareTo(pattern._pattern);
    }

    public String pattern() {
        return this._pattern;
    }

    public Component[] components() {
        return Arrays.copyOf(this._components, this._components.length);
    }

    public int minimumSize() {
        return this._minimumSize;
    }

    public int maximumSize() {
        return this._maximumSize;
    }

    public boolean matches(CharSequence input) {
        boolean retcode;
        int length = input.length();
        boolean bl = retcode = length >= this._minimumSize && (length <= this._maximumSize || this._maximumSize == -1);
        if (retcode) {
            LinkedList<MatchPly> queue = new LinkedList<MatchPly>();
            queue.add(new MatchPly(0, 0, 0));
            retcode = this.matches(input, length, this._components.length, queue);
        }
        return retcode;
    }

    public boolean equals(Object object) {
        boolean retcode;
        boolean bl = retcode = this == object;
        if (!retcode && object != null && object instanceof Pattern) {
            retcode = this._pattern.equals(((Pattern)object)._pattern);
        }
        return retcode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int index = 0; index < this._components.length; ++index) {
            buffer.append(this._components[index]);
        }
        buffer.append(" (min size=");
        buffer.append(this._minimumSize);
        buffer.append(", max size=");
        if (this._maximumSize == -1) {
            buffer.append("unlimited");
        } else {
            buffer.append(this._maximumSize);
        }
        buffer.append(")");
        return buffer.toString();
    }

    public int hashCode() {
        return this._pattern.hashCode();
    }

    public static Pattern compile(String regex) throws IllegalArgumentException, PatternSyntaxException {
        ArrayList<Component> components = new ArrayList<Component>();
        int index = 0;
        int minSize = 0;
        int maxSize = 0;
        if (regex == null) {
            throw new IllegalArgumentException("null regex");
        }
        if (regex.length() == 0) {
            throw new PatternSyntaxException("regex empty", regex, 0);
        }
        RegexLexer lexer = new RegexLexer(regex);
        RegexLexer.Token token = lexer.nextToken();
        int type = token.type();
        while (type == 3) {
            components.add(token.regexComponent());
            token = lexer.nextToken();
            type = token.type();
        }
        if (type == 1) {
            PatternSyntaxException t = new PatternSyntaxException(token.errorMessage(), regex, token.index());
            t.initCause(token.cause());
            throw t;
        }
        Component[] componentsArray = new Component[components.size()];
        for (Component component : components) {
            componentsArray[index++] = component;
            minSize += component.minimumSize();
            int size = component.maximumSize();
            if (size < 0) {
                maxSize = -1;
                continue;
            }
            if (maxSize < 0) continue;
            maxSize += size;
        }
        components.clear();
        return new Pattern(regex, componentsArray, minSize, maxSize);
    }

    private boolean matches(CharSequence input, int iLength, int cLength, Queue<MatchPly> queue) {
        MatchPly ply;
        boolean retcode = false;
        while (!retcode && (ply = queue.poll()) != null) {
            int ii = ply.inputIndex();
            int ci = ply.componentIndex();
            int mc = ply.matchCount();
            if (ii == iLength) {
                if (ci == cLength) {
                    retcode = true;
                    continue;
                }
                if (mc < this._components[ci].minimumSize()) continue;
                queue.add(new MatchPly(ii, ci + 1, 0));
                continue;
            }
            if (ci >= cLength || this._components[ci].minimumSize() != 0 && !this._components[ci].equalTo(input.charAt(ii))) continue;
            int ii2 = ii + 1;
            int ci2 = ci + 1;
            int mc2 = mc + 1;
            int minSize = this._components[ci].minimumSize();
            int maxSize = this._components[ci].maximumSize();
            if (mc2 < maxSize || maxSize == -1) {
                queue.add(new MatchPly(ii2, ci, mc2));
            }
            if (mc2 >= minSize) {
                queue.add(new MatchPly(ii2, ci2, 0));
            }
            if (mc2 <= minSize) continue;
            queue.add(new MatchPly(ii, ci2, 0));
        }
        return retcode;
    }

    private static final class MatchPly {
        private final int _inputIndex;
        private final int _componentIndex;
        private final int _matchCount;

        public MatchPly(int inputIndex, int componentIndex, int matchCount) {
            this._inputIndex = inputIndex;
            this._componentIndex = componentIndex;
            this._matchCount = matchCount;
        }

        public int inputIndex() {
            return this._inputIndex;
        }

        public int componentIndex() {
            return this._componentIndex;
        }

        public int matchCount() {
            return this._matchCount;
        }
    }
}

