/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.regex;

import java.io.Serializable;

public abstract class Component
implements Serializable {
    protected final int _type;
    protected final int _minimumSize;
    protected final int _maximumSize;
    protected final int _index;
    public static final int NO_MAX_MATCH_LIMIT = -1;
    public static final int LITERAL = 1;
    public static final int CHARACTER_SET = 2;
    public static final int ANY_CHAR = 3;
    private static final long serialVersionUID = 1L;

    protected Component(int type, int minLength, int maxLength, int index) {
        this._type = type;
        this._minimumSize = minLength;
        this._maximumSize = maxLength;
        this._index = index;
    }

    public int type() {
        return this._type;
    }

    public int minimumSize() {
        return this._minimumSize;
    }

    public int maximumSize() {
        return this._maximumSize;
    }

    public int index() {
        return this._index;
    }

    public abstract boolean lessThan(char var1);

    public abstract boolean equalTo(char var1);

    public abstract boolean greaterThan(char var1);

    protected void appendSize(StringBuilder buffer) {
        if (this._minimumSize != 1 || this._maximumSize != 1) {
            if (this._minimumSize == 0 && this._maximumSize == -1) {
                buffer.append('*');
            } else if (this._minimumSize == 1 && this._maximumSize == -1) {
                buffer.append('+');
            } else {
                buffer.append('{');
                if (this._minimumSize > 0) {
                    buffer.append(this._minimumSize);
                }
                buffer.append(',');
                if (this._maximumSize > 0) {
                    buffer.append(this._maximumSize);
                }
                buffer.append('}');
            }
        }
    }
}

