/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.regex;

import java.util.Iterator;
import java.util.SortedSet;
import net.sf.eBus.util.regex.Component;

public final class CharacterSet
extends Component {
    private final SortedSet<Character> _set;
    private final boolean _negationFlag;
    private static final long serialVersionUID = 131328L;

    CharacterSet(SortedSet<Character> set, boolean flag, int minSize, int maxSize, int index) {
        super(2, minSize, maxSize, index);
        this._set = set;
        this._negationFlag = flag;
    }

    @Override
    public boolean lessThan(char c) {
        return this._set.first().charValue() < c || this._negationFlag;
    }

    @Override
    public boolean equalTo(char c) {
        return this._set.contains(Character.valueOf(c)) != this._negationFlag;
    }

    @Override
    public boolean greaterThan(char c) {
        return this._set.last().charValue() > c || this._negationFlag;
    }

    public boolean isNegated() {
        return this._negationFlag;
    }

    public String toString() {
        int[] range = new int[2];
        int rangeIndex = 0;
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        if (this._negationFlag) {
            buffer.append('^');
        }
        Iterator it = this._set.iterator();
        while (it.hasNext()) {
            char index = ((Character)it.next()).charValue();
            if (rangeIndex > 0) {
                if (index == range[1] + 1) {
                    range[1] = index;
                } else {
                    buffer.append((char)range[0]);
                    if (range[1] > range[0] + 1) {
                        buffer.append('-');
                    }
                    buffer.append((char)range[1]);
                    rangeIndex = 0;
                }
            }
            if (rangeIndex != 0) continue;
            range[0] = index;
            rangeIndex = 1;
        }
        if (rangeIndex == 0) {
            buffer.append((char)range[0]);
        } else {
            buffer.append((char)range[0]);
            if (range[1] > range[0] + 1) {
                buffer.append('-');
            }
            buffer.append((char)range[1]);
        }
        buffer.append(']');
        this.appendSize(buffer);
        return buffer.toString();
    }
}

