/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.eBus.util.PropertiesEvent;
import net.sf.eBus.util.PropertiesListener;

public final class Properties
extends java.util.Properties {
    private final String _fileName;
    private final transient List<PropertiesListener> _listeners;
    private transient WatchThread _watchThread;
    private static Map<String, Properties> _propertiesMap = new HashMap<String, Properties>();
    private static Lock _propertiesMutex = new ReentrantLock();
    private static final Logger _logger = Logger.getLogger(Properties.class.getName());
    private static final long serialVersionUID = 131328L;
    private static final String THREAD_SUFFIX = "WatchThread";

    public Properties() {
        this._fileName = null;
        this._listeners = new LinkedList<PropertiesListener>();
        this._watchThread = null;
    }

    public Properties(java.util.Properties defaults) {
        super(defaults);
        this._fileName = null;
        this._listeners = new LinkedList<PropertiesListener>();
        this._watchThread = null;
    }

    private Properties(String fileName) {
        this._fileName = fileName;
        this._listeners = new LinkedList<PropertiesListener>();
        this._watchThread = null;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean getBooleanProperty(String key) {
        String value = this.getProperty(key);
        boolean retval = false;
        if (value != null) {
            Boolean bool = Boolean.valueOf(value.trim());
            retval = bool;
        }
        return retval;
    }

    public int getIntProperty(String key) {
        String value = this.getProperty(key);
        int retval = 0;
        if (value != null && value.length() > 0) {
            try {
                retval = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retval;
    }

    public double getDoubleProperty(String key) {
        String value = this.getProperty(key);
        double retval = 0.0;
        if (value != null && value.length() > 0) {
            try {
                retval = Double.parseDouble(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retval;
    }

    public String[] getArrayProperty(String key, char ifs) {
        String value = this.getProperty(key);
        String[] retval = value == null || value.length() == 0 ? new String[]{} : value.split(String.format("[%c]", Character.valueOf(ifs)));
        return retval;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        boolean retval;
        String value = this.getProperty(key);
        if (value == null) {
            retval = defaultValue;
        } else {
            Boolean bool = Boolean.valueOf(value.trim());
            retval = bool;
        }
        return retval;
    }

    public int getIntProperty(String key, int defaultValue) {
        String value = this.getProperty(key);
        int retval = defaultValue;
        if (value != null && value.length() > 0) {
            try {
                retval = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException formex) {
                retval = defaultValue;
            }
        }
        return retval;
    }

    public double getDoubleProperty(String key, double defaultValue) {
        double retval;
        String value = this.getProperty(key);
        if (value == null || value.length() == 0) {
            retval = defaultValue;
        } else {
            try {
                retval = Double.parseDouble(value);
            }
            catch (NumberFormatException formex) {
                retval = defaultValue;
            }
        }
        return retval;
    }

    public Set<String> stringPropertyNames(Pattern p) {
        Set<String> retval = this.stringPropertyNames();
        Iterator<String> it = retval.iterator();
        while (it.hasNext()) {
            Matcher m = p.matcher(it.next());
            if (m.matches()) continue;
            it.remove();
        }
        return retval;
    }

    public void setBooleanProperty(String key, boolean value) {
        Boolean obj = value;
        this.setProperty(key, obj.toString());
    }

    public void setIntProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public void setDoubleProperty(String key, double value) {
        this.setProperty(key, Double.toString(value));
    }

    public void setArrayProperty(String key, String[] value, char ifs) {
        String newValue = "";
        if (value.length > 0) {
            int i;
            int bufferLen = 0;
            for (i = 0; i < value.length; ++i) {
                bufferLen += value[i].length();
            }
            StringBuffer buffer = new StringBuffer(bufferLen += value.length - 1);
            for (i = 0; i < value.length; ++i) {
                if (i > 0) {
                    buffer.append(ifs);
                }
                buffer.append(value[i]);
            }
            newValue = buffer.toString();
        }
        this.setProperty(key, newValue);
    }

    public void load() throws IOException {
        if (this._fileName == null) {
            throw new IOException("no property file to load");
        }
        try (FileInputStream fis = new FileInputStream(this._fileName);){
            this.load(fis);
        }
        catch (FileNotFoundException nofilex) {
            throw new IOException(this._fileName + " does not exist");
        }
    }

    public void store(String header) throws FileNotFoundException, IOException {
        if (this._fileName == null) {
            throw new IOException("no property file");
        }
        try (FileOutputStream fos = new FileOutputStream(this._fileName);){
            this.store(fos, header);
        }
    }

    public void store(String fileName, String header) throws IllegalArgumentException, FileNotFoundException, IOException {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        this.store(new File(fileName), header);
    }

    public void store(File file, String header) throws IllegalArgumentException, FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        boolean existsFlag = file.exists();
        if (existsFlag && file.isDirectory()) {
            throw new IOException(file.getName() + " is a directory");
        }
        if (existsFlag && !file.canWrite()) {
            throw new IOException(file.getName() + " is unwriteable");
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.store(fos, header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PropertiesListener listener) throws IllegalArgumentException, IllegalStateException {
        boolean addFlag = false;
        int listenerSize = 0;
        if (this._fileName == null) {
            throw new IllegalStateException("no underlying property file");
        }
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        List<PropertiesListener> list = this._listeners;
        synchronized (list) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
                addFlag = true;
                listenerSize = this._listeners.size();
            }
        }
        if (addFlag && listenerSize == 1) {
            try {
                File f = new File(this._fileName).getAbsoluteFile();
                FileSystem fs = FileSystems.getDefault();
                Path p = fs.getPath(f.getParent(), new String[0]);
                Path fp = fs.getPath(f.getName(), new String[0]);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(String.format("Watching %s properties file.", this._fileName));
                }
                WatchService watcher = fs.newWatchService();
                WatchKey key = p.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                this._watchThread = new WatchThread(fp, key, watcher, String.format("%s%s", f.getName(), THREAD_SUFFIX), this);
                this._watchThread.start();
            }
            catch (IOException ioex) {
                _logger.log(Level.WARNING, "File watch failed.", ioex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PropertiesListener listener) {
        if (this._fileName == null) {
            throw new IllegalStateException("no underlying property file");
        }
        if (listener != null) {
            boolean removeFlag = false;
            boolean emptyFlag = false;
            List<PropertiesListener> list = this._listeners;
            synchronized (list) {
                if (this._listeners.contains(listener)) {
                    this._listeners.remove(listener);
                    removeFlag = true;
                    emptyFlag = this._listeners.isEmpty();
                }
            }
            if (removeFlag && emptyFlag) {
                this._watchThread.cancel();
                this._watchThread = null;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(String.format("Stopped watching %s properties file.", this._fileName));
                }
            }
        }
    }

    public static Properties loadProperties(String fileName) throws IllegalArgumentException, IOException {
        Properties retval = null;
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        retval = Properties.loadProperties(new File(fileName));
        return retval;
    }

    public static Properties loadProperties(File file) throws IllegalArgumentException, IOException {
        Properties retval = null;
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        boolean existsFlag = file.exists();
        if (existsFlag && file.isDirectory()) {
            throw new IOException(file.getName() + " is a directory");
        }
        if (existsFlag && !file.canRead()) {
            throw new IOException(file.getName() + " is unreadable");
        }
        String fileName = file.getPath();
        _propertiesMutex.lock();
        try {
            retval = _propertiesMap.get(fileName);
            if (retval == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(String.format("Loading %s properties file.", fileName));
                }
                retval = Properties.createInstance(file, fileName, existsFlag);
            }
        }
        catch (IOException ioex) {
            throw ioex;
        }
        finally {
            _propertiesMutex.unlock();
        }
        return retval;
    }

    private static Properties createInstance(File file, String fileName, boolean existsFlag) throws IOException {
        Properties retval = new Properties(fileName);
        _propertiesMap.put(fileName, retval);
        if (existsFlag) {
            try (FileInputStream fis = new FileInputStream(file);){
                retval.load(fis);
            }
            catch (IOException ioex) {
                _propertiesMap.remove(fileName);
                throw ioex;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFileEvent(WatchEvent<?> event) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(String.format("Properties event: %s.", event.kind().name()));
        }
        try {
            PropertiesEvent propEvent = new PropertiesEvent(this);
            LinkedList<PropertiesListener> listeners = new LinkedList<PropertiesListener>();
            this.load();
            List<PropertiesListener> list = this._listeners;
            synchronized (list) {
                listeners.addAll(this._listeners);
            }
            listeners.stream().forEach((? super T listener) -> {
                try {
                    listener.propertiesUpdate(propEvent);
                }
                catch (Exception jex) {
                    _logger.log(Level.WARNING, "Properties listener exception.", jex);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final class WatchThread
    extends Thread {
        private final Path _propertiesFile;
        private final WatchKey _key;
        private final WatchService _watcher;
        private final Properties _owner;

        public WatchThread(Path propFile, WatchKey key, WatchService watcher, String name, Properties owner) {
            super(name);
            this._propertiesFile = propFile;
            this._key = key;
            this._watcher = watcher;
            this._owner = owner;
        }

        @Override
        public void run() {
            boolean runFlag = true;
            while (runFlag) {
                try {
                    this._watcher.take();
                    this._key.pollEvents().stream().filter(event -> event.kind() != StandardWatchEventKinds.OVERFLOW && event.context().equals(this._propertiesFile)).forEach(event -> this._owner.handleFileEvent(event));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                runFlag = this._key.reset();
            }
        }

        public void cancel() {
            this._key.cancel();
            this.interrupt();
        }
    }
}

