/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.io.Serializable;
import java.util.Formatter;

public class MultiKey
implements Comparable<MultiKey>,
Serializable {
    private final Object[] _keys;
    private final int _hashCode;
    private static final long serialVersionUID = 131328L;

    public MultiKey(Object ... keys) throws IndexOutOfBoundsException {
        if (keys.length == 0) {
            throw new IndexOutOfBoundsException("no keys");
        }
        this._keys = new Object[keys.length];
        System.arraycopy(keys, 0, this._keys, 0, keys.length);
        int hashCode = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            hashCode ^= keys[i].hashCode();
        }
        this._hashCode = hashCode;
    }

    @Override
    public int compareTo(MultiKey key) throws ClassCastException {
        int retval = 0;
        if (this != key) {
            retval = this._keys.length - key._keys.length;
            for (int i = 0; i < this._keys.length && retval == 0; ++i) {
                if (this._keys[i] == null) {
                    if (key._keys[i] == null) continue;
                    retval = -1;
                    continue;
                }
                retval = ((Comparable)this._keys[i]).compareTo(key._keys[i]);
            }
        }
        return retval;
    }

    public int size() {
        return this._keys.length;
    }

    public Object key(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._keys.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index) + " invalid index");
        }
        return this._keys[index];
    }

    public Object[] keys() {
        Object[] keys = new Object[this._keys.length];
        System.arraycopy(this._keys, 0, keys, 0, this._keys.length);
        return keys;
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof MultiKey) {
            MultiKey mkey = (MultiKey)o;
            if (this._keys.length == mkey._keys.length) {
                retcode = true;
                for (int i = 0; retcode && i < this._keys.length; ++i) {
                    retcode = this._keys[i] == null ? mkey._keys[i] == null : this._keys[i].equals(mkey._keys[i]);
                }
            }
        }
        return retcode;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        Formatter buffer = new Formatter();
        buffer.format("{", new Object[0]);
        String sep = "";
        for (int i = 0; i < this._keys.length; ++i) {
            buffer.format("%s%s", sep, this._keys[i]);
            sep = ", ";
        }
        buffer.format("}", new Object[0]);
        return buffer.toString();
    }
}

