/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA
 * 02111-1307 USA
 *
 * The Initial Developer of the Original Code is Charles W. Rapp.
 * Portions created by Charles W. Rapp are
 * Copyright 2012. Charles W. Rapp
 * All Rights Reserved.
 */

/**
 * This regular expression package is designed to perform
 * efficient pattern matching over a
 * {@link net.sf.eBus.util.TernarySearchTree TernarySearchTree}.
 * A {@link net.sf.eBus.util.regex.Pattern Pattern} may be used
 * with the ternary search tree (TST) methods {@code keySet},
 * {@code values} and {@code entrySet}. Only those entries which
 * match the pattern are returned.
 * <p>
 * <b>Warning:</b> Pattern matching over a TST may result in
 * significant CPU usage. A pattern with wildcards first
 * (example: ".+xyz") will traverse the entire TST. If you must
 * use such patterns but you do not need to find all matching
 * entries, then consider using the {@code maxMatches}
 * parameter. Once the specified number of matches are found,
 * the method stops the search and returns.
 * <p>
 * If you need to perform regular expression pattern matching
 * on text only, then use the {@link java.util.regex} package.
 * Do not use this package for text matching only.
 * <p>
 * If you do use pattern matching, then best to use patterns
 * that begin with concrete values and place wildcards at the
 * end.
 */

package net.sf.eBus.util.regex;
