//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
// 
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2001 - 2008. Charles W. Rapp.
// All Rights Reserved.
//

package net.sf.eBus.util.logging;

import java.io.PrintWriter;

/**
 * Implement this interface when you want an object to append
 * its information to the status report.
 * 
 * @see net.sf.eBus.util.logging.StatusReport
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public interface StatusReporter
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * Append your report to this buffer.
     * @param report append report to this buffer.
     */
    void reportStatus(PrintWriter report);
} // end of interface StatusReporter

//
// CHANGE LOG
// $Log: StatusReporter.java,v $
// Revision 1.1  2004/01/28 02:07:23  charlesr
// Use StringWriter and PrintWriter to collect status reports
// instead of StringBuffer.
//
// Revision 1.0  2003/11/20 01:50:00  charlesr
// Initial revision
//
