//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2013. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.util.logging;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

/**
 * This handler quietly does nothing with the given log records.
 * Used as part of JUnit testing to allow logging statements to
 * be exercised but no logging produced.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public final class NullHandler
    extends Handler
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * Creates a new instance of NullHandler.
     */
    public NullHandler()
    {}

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Handler Abstract Method Implementation.
    //

    /**
     * Quietly ignores the log record.
     * @param record do not store this record.
     */
    @Override
    public void publish(LogRecord record)
    {}

    /**
     * Does nothing since there is nothing to flush
     */
    @Override
    public void flush()
    {}

    /**
     * Does nothing since there is nothing to close.
     */
    @Override
    public void close()
    {}

    //
    // end of Handler Abstract Method Implementation.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//
} // end of class NullHandler
