//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2001 - 2008. Charles W. Rapp.
// All Rights Reserved.
//

package net.sf.eBus.util;

/**
 * Classes using {@link net.sf.eBus.util.TimerTask TimerTask}
 * should implement this interface. It allows them to receive
 * timer expiration notifications.
 * <p>
 * As of eBus v. 4.2.0, this interface is marked as
 * {@code @FunctionalInterface}. This allows this interface to
 * be defined using a lambda expression.
 * </p>
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

@FunctionalInterface
public interface TimerTaskListener
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * This method is called when the
     * {@link net.sf.eBus.util.TimerTask TimerTask} has expired.
     * @param task the timer event (the event source is the
     * {@link net.sf.eBus.util.TimerTask} object).
     */
    void handleTimeout(TimerEvent task);
} // end of interface TimerTaskListener

//
// CHANGE LOG
// $Log: TimerTaskListener.java,v $
// Revision 1.1  2005/07/22 01:39:57  charlesr
// Moved to Java 5.
//
// Revision 1.0  2003/11/20 01:47:33  charlesr
// Initial revision
//
