/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.pattern;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.eBus.messages.ELocalOnly;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.util.Validator;

@ELocalOnly
public final class MatchEvent
extends ENotificationMessage {
    private static final long serialVersionUID = 256L;
    public final Map<String, List<ENotificationMessage>> groups;
    public final Map<Object, Object> userCache;

    private MatchEvent(Builder builder) {
        super((ENotificationMessage.Builder)builder);
        this.groups = builder.mGroups;
        this.userCache = builder.mUserCache;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        retval.append(super.toString()).append("\n  Capturing groups:");
        for (Map.Entry<String, List<ENotificationMessage>> entry2 : this.groups.entrySet()) {
            retval.append("\n  group[").append(entry2.getKey()).append(']');
            int ei = 0;
            for (ENotificationMessage msg : entry2.getValue()) {
                retval.append("\n    event[").append(ei).append("]\n").append(msg);
                ++ei;
            }
        }
        retval.append("\n  User-defined data:");
        this.userCache.entrySet().forEach(entry -> retval.append("\n    ").append(entry.getKey()).append('=').append(entry.getValue()));
        return retval.toString();
    }

    public List<ENotificationMessage> group(String name) {
        return this.groups.get(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ENotificationMessage.Builder<MatchEvent, Builder> {
        private Map<String, List<ENotificationMessage>> mGroups;
        private Map<Object, Object> mUserCache;

        private Builder() {
            super(MatchEvent.class);
        }

        protected MatchEvent buildImpl() {
            return new MatchEvent(this);
        }

        protected Validator validate(Validator problems) {
            return super.validate(problems).requireNotNull(this.mGroups, "groups").requireNotNull(this.mUserCache, "userCache");
        }

        public Builder groups(Map<String, List<ENotificationMessage>> groups) {
            this.mGroups = Objects.requireNonNull(groups, "groups is null");
            return this;
        }

        public Builder userCache(Map<Object, Object> userCache) {
            this.mUserCache = Objects.requireNonNull(userCache, "user cache is null");
            return this;
        }
    }
}

