/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EObject;
import net.sf.eBus.client.ESubscribeFeed;
import net.sf.eBus.client.IESubscribeFeed;
import net.sf.eBus.feed.pattern.EPatternFeed;
import net.sf.eBus.feed.pattern.EventPattern;
import net.sf.eBus.feed.pattern.MatchCondition;
import net.sf.eBus.feed.pattern.MatchEvent;
import net.sf.eBus.messages.ENotificationMessage;

final class EUnorderedPatternFeed
extends EPatternFeed {
    private final ArgsInfo[] mArgs;
    private Queue<MatchFrame> mMatchFrames;

    public EUnorderedPatternFeed(Builder builder) {
        super(builder);
        this.mArgs = new ArgsInfo[builder.mPattern.componentCount()];
        this.mMatchFrames = new LinkedList<MatchFrame>();
        this.setSubscribeFeeds(builder.mPattern);
    }

    @Override
    protected void matchEvent(ENotificationMessage event, int eventId) {
        LinkedList<MatchFrame> frames = new LinkedList<MatchFrame>();
        if (sLogger.isTraceEnabled()) {
            sLogger.trace("{}: received event:\n{}", (Object)this.mPubKey, (Object)event);
        } else {
            sLogger.debug("{}: received {} event.", (Object)this.mPubKey, (Object)event.key());
        }
        this.mMatchFrames.add(new MatchFrame(this.mPatternName, this.mIsExclusive, this.mArgs));
        while (!this.mMatchFrames.isEmpty()) {
            MatchFrame currFrame = this.mMatchFrames.poll();
            if (currFrame.isDefunct()) continue;
            if (this.mUntil.test(currFrame.allEvents(), event)) {
                this.matchEvent(event, eventId, currFrame, frames);
                continue;
            }
            frames.add(currFrame);
        }
        this.mMatchFrames = frames;
    }

    public static Builder builder() {
        return new Builder();
    }

    private void setSubscribeFeeds(EventPattern pattern) {
        Map<String, EventPattern.FeedInfo> params = pattern.parameters();
        List<EventPattern.PatternComponent> components = pattern.components();
        for (EventPattern.PatternComponent pc : components) {
            EventPattern.SinglePatternComponent spc = (EventPattern.SinglePatternComponent)pc;
            EventPattern.FeedInfo feedInfo = params.get(spc.parameter());
            ESubscribeFeed subFeed = (ESubscribeFeed)((ESubscribeFeed.Builder)((ESubscribeFeed.Builder)((ESubscribeFeed.Builder)ESubscribeFeed.builder().target((EObject)this)).messageKey(feedInfo.messageKey())).scope(feedInfo.scope())).condition(feedInfo.condition()).statusCallback(this::onFeedStateUpdate).notifyCallback(this::onEvent).build();
            int feedId = subFeed.feedId();
            this.mSubFeeds.add(subFeed);
            this.mAllSubFeedsMask |= 1L << feedId;
            this.mArgs[feedId] = new ArgsInfo(feedId, spc);
        }
    }

    private void matchEvent(ENotificationMessage event, int eventId, MatchFrame mf, Queue<MatchFrame> frames) {
        MatchFrame originalMF = new MatchFrame(mf);
        boolean matchFlag = false;
        sLogger.trace("{}: event ID={}\n{}\nframe={}", new Object[]{this.mPatternName, eventId, event, mf});
        boolean addFlag = mf.addEvent(eventId, event);
        if (addFlag) {
            MatchEvent me;
            sLogger.debug("{}: {} event added, frame:\n{}", new Object[]{this.mPubKey, event.key(), mf});
            if (this.mIsExclusive) {
                this.addMapping(event, mf);
            }
            if ((matchFlag = mf.isMatched()) && this.mCondition.test(me = mf.generateMatch(this.mPubKey.subject()))) {
                EClient.dispatch((Runnable)new EFeed.NotifyTask((EFeed)this, (ENotificationMessage)me, NO_CONDITION, (IESubscribeFeed)this, this.mNotifyCallback), (EObject)this.mEClient.target());
                if (this.mIsExclusive) {
                    this.markDefunct(mf.allEvents());
                }
            }
        }
        if (!(mf.isEmpty() || addFlag && matchFlag && (this.mIsExclusive || mf.isMaxedOut()))) {
            sLogger.debug("Frame {} {} enqueued.", (Object)mf.patternName(), (Object)mf.frameId());
            frames.add(mf);
        }
        if (!(!addFlag || originalMF.isEmpty() || matchFlag && originalMF.isDefunct())) {
            sLogger.debug("Frame {} {} enqueued.", (Object)originalMF.patternName(), (Object)originalMF.frameId());
            frames.add(originalMF);
        }
    }

    private static final class MatchFrame
    extends EPatternFeed.AbstractMatchFrame {
        private final PatternArguments[] mArguments;
        private boolean mEmptyFlag;
        private boolean mMatchFlag;
        private boolean mMaxFlag;

        private MatchFrame(String patternName, boolean isExclusive, ArgsInfo[] info) {
            super(patternName, isExclusive);
            this.mArguments = new PatternArguments[info.length];
            this.mEmptyFlag = true;
            int numInfo = info.length;
            for (int i = 0; i < numInfo; ++i) {
                this.mArguments[info[i].eventId()] = new PatternArguments(info[i]);
            }
        }

        private MatchFrame(MatchFrame frame) {
            super(frame);
            PatternArguments[] args = frame.mArguments;
            int numArgs = args.length;
            this.mArguments = new PatternArguments[numArgs];
            this.mEmptyFlag = frame.mEmptyFlag;
            for (int i = 0; i < numArgs; ++i) {
                this.mArguments[i] = args[i].copy();
            }
        }

        @Override
        protected Map<String, List<ENotificationMessage>> groupMap() {
            int numArgs = this.mArguments.length;
            HashMap<String, List<Object>> retval = new HashMap<String, List<Object>>(numArgs + 1);
            retval.put("__ALL_EVENTS__", Collections.unmodifiableList(this.mAllEvents));
            for (int i = 0; i < numArgs; ++i) {
                retval.put(this.mArguments[i].eventName(), Collections.unmodifiableList(this.mArguments[i].events()));
            }
            return Collections.unmodifiableMap(retval);
        }

        public final boolean isEmpty() {
            return this.mEmptyFlag;
        }

        public boolean isMatched() {
            return this.mMatchFlag;
        }

        public boolean isMaxedOut() {
            return this.mMaxFlag;
        }

        public MatchEvent generateMatch(String subject) {
            return (MatchEvent)((MatchEvent.Builder)MatchEvent.builder().subject(subject)).groups(this.groupMap()).userCache(this.userCache()).build();
        }

        public boolean addEvent(int eventId, ENotificationMessage event) {
            boolean retcode = this.mArguments[eventId].addEvent(event, this);
            if (retcode) {
                int numArgs = this.mArguments.length;
                this.mEmptyFlag = false;
                this.mAllEvents.add(event);
                this.mMatchFlag = true;
                this.mMaxFlag = true;
                for (int i = 0; i < numArgs; ++i) {
                    this.mMatchFlag = this.mMatchFlag && this.mArguments[i].atMinimum();
                    this.mMaxFlag = this.mMaxFlag && this.mArguments[i].atMaximum();
                }
            }
            return retcode;
        }
    }

    private static final class PatternArguments {
        private final String mEventName;
        private final int mEventId;
        private final int mMinQuantity;
        private final int mMaxQuantity;
        private final MatchCondition mCondition;
        private final List<ENotificationMessage> mEvents;

        private PatternArguments(ArgsInfo info) {
            this(info.eventName(), info.eventId(), info.minimumQuantity(), info.maximumQuantity(), info.condition(), new ArrayList<ENotificationMessage>(info.maximumQuantity()));
        }

        private PatternArguments(String eventName, int eventId, int minQty, int maxQty, MatchCondition condition, List<ENotificationMessage> events) {
            this.mEventName = eventName;
            this.mEventId = eventId;
            this.mMinQuantity = minQty;
            this.mMaxQuantity = maxQty;
            this.mCondition = condition;
            this.mEvents = events;
        }

        public String eventName() {
            return this.mEventName;
        }

        public int eventId() {
            return this.mEventId;
        }

        public int eventCount() {
            return this.mEvents.size();
        }

        public boolean atMinimum() {
            return this.mEvents.size() >= this.mMinQuantity;
        }

        public boolean atMaximum() {
            return this.mEvents.size() == this.mMaxQuantity;
        }

        public List<ENotificationMessage> events() {
            return this.mEvents;
        }

        public PatternArguments copy() {
            ArrayList<ENotificationMessage> events = new ArrayList<ENotificationMessage>(this.mMaxQuantity);
            events.addAll(this.mEvents);
            return new PatternArguments(this.mEventName, this.mEventId, this.mMinQuantity, this.mMaxQuantity, this.mCondition, events);
        }

        public boolean addEvent(ENotificationMessage event, MatchFrame mf) {
            boolean retcode;
            boolean bl = retcode = !this.mEvents.contains(event) && !this.atMaximum() && EPatternFeed.componentTest(event, mf, this.mCondition);
            if (retcode) {
                this.mEvents.add(event);
            }
            return retcode;
        }
    }

    private final class ArgsInfo {
        private final int mEventId;
        private final String mEventName;
        private final int mMinQuantity;
        private final int mMaxQuantity;
        private final MatchCondition mCondition;

        private ArgsInfo(int eventId, EventPattern.SinglePatternComponent spc) {
            this.mEventId = eventId;
            this.mEventName = spc.parameter();
            this.mMinQuantity = spc.minimumMatchCount();
            this.mMaxQuantity = spc.maximumMatchCount();
            this.mCondition = spc.condition();
        }

        public int eventId() {
            return this.mEventId;
        }

        public String eventName() {
            return this.mEventName;
        }

        public int minimumQuantity() {
            return this.mMinQuantity;
        }

        public int maximumQuantity() {
            return this.mMaxQuantity;
        }

        public MatchCondition condition() {
            return this.mCondition;
        }
    }

    public static final class Builder
    extends EPatternFeed.PatternBuilder<EUnorderedPatternFeed, Builder> {
        private Builder() {
            super(EUnorderedPatternFeed.class);
        }

        protected Builder self() {
            return this;
        }

        protected EUnorderedPatternFeed buildImpl() {
            return new EUnorderedPatternFeed(this);
        }
    }
}

