//
// Copyright 2023 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.feed.historic.store;

import net.sf.eBus.messages.EMessageKey;
import net.sf.eBusx.time.EInterval;

/**
 * Generates SQL statement to retrieve the specified eBus
 * notification message key for the given time interval. Returned
 * {@link java.sql.ResultSet}(s) translated into eBus
 * {@link net.sf.eBus.messages.ENotificationMessage notification message}(s)
 * by {@link IMessageDecoder}.
 *
 * @see IInsertGenerator
 * @see IMessageDecoder
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@FunctionalInterface
public interface IRetrieveGenerator
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * Returns SQL select statement used to retrieve the given
     * eBus notification message type.
     * @param key contains notification message class and
     * subject.
     * @param interval time interval.
     * @return SQL select statement text.
     */
    String retrieveStatement(EMessageKey key,
                             EInterval interval);
} // end of interface IRetrieveGenerator

