//
// Copyright 2023 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.feed.historic.store;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;

/**
 * Converts {@link ResultSet} into eBus
 * {@link ENotificationMessage notification message} for given
 * message key. Providing message key means that message subject
 * does not need to be stored in SQL database.
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

public interface IMessageDecoder
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * Returns eBus notification message created from the given
     * message key and SQL result set.
     * @param key decoded eBus message key.
     * @param rs result set containing remaining message fields.
     * @return eBus notification message subject.
     * @throws SQLException
     * if attempt to access needed message fields in result set
     * fails.
     */
    ENotificationMessage toMessage(final EMessageKey key,
                                   final ResultSet rs)
        throws SQLException;
} // end of interface IMessageDecoder

