/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.historic.store;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import net.sf.eBus.feed.historic.EHistoricSubscribeFeed;
import net.sf.eBus.feed.historic.IEMessageStore;
import net.sf.eBus.feed.historic.PublishStatusEvent;
import net.sf.eBus.feed.historic.store.IInsertGenerator;
import net.sf.eBus.feed.historic.store.IMessageDecoder;
import net.sf.eBus.feed.historic.store.IRetrieveGenerator;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.util.ValidationException;
import net.sf.eBus.util.Validator;
import net.sf.eBusx.time.EInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlMessageStore
implements IEMessageStore {
    private static final Logger sLogger = LoggerFactory.getLogger(SqlMessageStore.class);
    private static final EHistoricSubscribeFeed.PastComparator sPastComparator = new EHistoricSubscribeFeed.PastComparator();
    private final Connection mDbConnection;
    private final EMessageKey mKey;
    private final EMessageKey mPublishStatusKey;
    private final IInsertGenerator mInsertGenerator;
    private final IRetrieveGenerator mRetrieveGenerator;
    private final IMessageDecoder mMessageDecoder;
    private int mInsertCount;

    private SqlMessageStore(Builder builder) {
        this.mDbConnection = builder.mDbConnection;
        this.mKey = builder.mKey;
        this.mPublishStatusKey = new EMessageKey(PublishStatusEvent.class, this.mKey.subject());
        this.mInsertGenerator = builder.mInsertGenerator;
        this.mRetrieveGenerator = builder.mRetrieveGenerator;
        this.mMessageDecoder = builder.mMessageDecoder;
        this.mInsertCount = 0;
    }

    @Override
    public boolean isOpen() {
        boolean retcode;
        try {
            retcode = !this.mDbConnection.isClosed();
        }
        catch (SQLException sqlex) {
            retcode = false;
        }
        return retcode;
    }

    @Override
    public EMessageKey key() {
        return this.mKey;
    }

    @Override
    public void store(ENotificationMessage message) {
        String insertSql = this.mInsertGenerator.insertStatement(message);
        try (Statement statement = this.mDbConnection.createStatement();){
            statement.executeUpdate(insertSql);
            ++this.mInsertCount;
        }
        catch (SQLException jex) {
            sLogger.warn("SQL message store insert failed, SQL:\n\"{}\"", (Object)insertSql, (Object)jex);
        }
    }

    @Override
    public Collection<ENotificationMessage> retrieve(EInterval interval) {
        ResultSet rs;
        Statement statement;
        String messageSql = this.mRetrieveGenerator.retrieveStatement(this.mKey, interval);
        String pseSql = this.mRetrieveGenerator.retrieveStatement(this.mPublishStatusKey, interval);
        int rowIndex = 0;
        TreeSet<ENotificationMessage> retval = new TreeSet<ENotificationMessage>(sPastComparator);
        try {
            statement = this.mDbConnection.createStatement();
            try {
                rs = statement.executeQuery(messageSql);
                while (rs.next()) {
                    retval.add(this.mMessageDecoder.toMessage(this.mKey, rs));
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sqlex) {
            sLogger.warn("Failed to retrieve messages from store, sql:\n\"{}\"", (Object)messageSql, (Object)sqlex);
        }
        try {
            statement = this.mDbConnection.createStatement();
            try {
                rs = statement.executeQuery(pseSql);
                while (rs.next()) {
                    retval.add(this.mMessageDecoder.toMessage(this.mPublishStatusKey, rs));
                    ++rowIndex;
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sqlex) {
            sLogger.warn("Failed to retrieve messages from store, row index={}, sql:\n\"{}\"", new Object[]{rowIndex, pseSql, sqlex});
        }
        return retval;
    }

    public int insertCount() {
        return this.mInsertCount;
    }

    public static Builder builder(Connection dbConnection) throws SQLException {
        Objects.requireNonNull(dbConnection, "DB connection is null");
        if (dbConnection.isClosed()) {
            throw new IllegalArgumentException("DB connection is closed");
        }
        if (dbConnection.isReadOnly()) {
            throw new IllegalArgumentException("DB connection is read-only");
        }
        return new Builder(dbConnection);
    }

    public static final class Builder {
        private final Connection mDbConnection;
        private EMessageKey mKey;
        private IInsertGenerator mInsertGenerator;
        private IRetrieveGenerator mRetrieveGenerator;
        private IMessageDecoder mMessageDecoder;

        private Builder(Connection dbConnection) {
            this.mDbConnection = dbConnection;
        }

        public Builder key(EMessageKey key) {
            Objects.requireNonNull(key, "key is null");
            if (!key.isNotification()) {
                throw new IllegalArgumentException(key.className() + " is not a notification message class");
            }
            this.mKey = key;
            return this;
        }

        public Builder insertGenerator(IInsertGenerator generator) {
            this.mInsertGenerator = Objects.requireNonNull(generator, "generator is null");
            return this;
        }

        public Builder retrieveGenerator(IRetrieveGenerator generator) {
            this.mRetrieveGenerator = Objects.requireNonNull(generator, "generator is null");
            return this;
        }

        public Builder messageDecoder(IMessageDecoder decoder) {
            this.mMessageDecoder = Objects.requireNonNull(decoder, "decoder is null");
            return this;
        }

        public SqlMessageStore build() {
            Validator problems = new Validator();
            problems.requireNotNull((Object)this.mKey, "key").requireNotNull((Object)this.mInsertGenerator, "insertGenerator").requireNotNull((Object)this.mRetrieveGenerator, "retrieveGenerator").requireNotNull((Object)this.mMessageDecoder, "messageDecoder").throwException(ValidationException.class);
            return new SqlMessageStore(this);
        }
    }
}

