/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.historic.store;

import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.sf.eBus.feed.historic.IEMessageStore;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.util.ValidationException;
import net.sf.eBus.util.Validator;
import net.sf.eBusx.time.EInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryMessageStore
implements IEMessageStore {
    public static final int DEFAULT_STORE_CAPACITY = 1000;
    private static final int FIRST_INDEX = 0;
    private static final int LAST_INDEX = 1;
    private static final String NOT_SET = "(not set)";
    private static final Logger sLogger = LoggerFactory.getLogger(InMemoryMessageStore.class);
    private final EMessageKey mKey;
    private final int mMaximumCapacity;
    private final ENotificationMessage[] mStore;
    private final SortedMap<Instant, int[]> mTimeIndex;
    private int mMessageCount;
    private int mInsertIndex;

    private InMemoryMessageStore(Builder builder) {
        this.mKey = builder.mKey;
        this.mMaximumCapacity = builder.mMaxCapacity;
        this.mStore = new ENotificationMessage[this.mMaximumCapacity];
        this.mTimeIndex = new TreeMap<Instant, int[]>();
        this.mMessageCount = 0;
        this.mInsertIndex = 0;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public EMessageKey key() {
        return this.mKey;
    }

    @Override
    public void store(ENotificationMessage message) {
        Instant ts = Instant.ofEpochMilli(message.timestamp);
        if (this.mMessageCount == this.mMaximumCapacity) {
            this.removeOldestMessage(this.mInsertIndex);
            --this.mMessageCount;
        }
        this.mStore[this.mInsertIndex] = message;
        ++this.mMessageCount;
        int[] indices = this.mTimeIndex.computeIfAbsent(ts, k -> new int[]{this.mInsertIndex, this.mInsertIndex});
        indices[1] = this.mInsertIndex;
        this.mInsertIndex = this.incrementIndex(this.mInsertIndex);
    }

    @Override
    public Collection<ENotificationMessage> retrieve(EInterval interval) {
        Instant lastKey;
        Instant firstKey;
        Instant endTime;
        ImmutableList.Builder builder = ImmutableList.builder();
        Instant beginTime = interval.beginClusivity == EInterval.Clusivity.INCLUSIVE ? interval.beginTime : interval.beginTime.plusNanos(1L);
        SortedMap<Instant, int[]> subMap = this.mTimeIndex.subMap(beginTime, endTime = interval.endClusivity == EInterval.Clusivity.EXCLUSIVE ? interval.endTime : interval.endTime.plusNanos(1L));
        if (subMap != null && !subMap.isEmpty() && (firstKey = subMap.firstKey()) != null && (lastKey = subMap.lastKey()) != null) {
            int[] beginIndices = (int[])subMap.get(firstKey);
            int[] endIndices = (int[])subMap.get(lastKey);
            if (beginIndices == null || endIndices == null) {
                sLogger.warn("timestamp indices missing for {} and {}", (Object)firstKey, (Object)lastKey);
            } else {
                int beginIndex = interval.beginClusivity == EInterval.Clusivity.INCLUSIVE ? beginIndices[0] : this.incrementIndex(beginIndices[1]);
                int endIndex = interval.endClusivity == EInterval.Clusivity.INCLUSIVE ? this.incrementIndex(endIndices[1]) : endIndices[0];
                int index = beginIndex;
                boolean firstIteration = true;
                while (index != endIndex || firstIteration) {
                    builder.add((Object)this.mStore[index]);
                    index = this.incrementIndex(index);
                    firstIteration = false;
                }
            }
        }
        return builder.build();
    }

    public String toString() {
        Instant startTime = this.firstTimestamp();
        Instant endTime = this.lastTimestamp();
        return String.format("[size=%,d, max size=%,d, start time=%s, end time=%s]", this.mMessageCount, this.mMaximumCapacity, startTime == null ? NOT_SET : startTime, endTime == null ? NOT_SET : endTime);
    }

    public int size() {
        return this.mMessageCount;
    }

    public int capacity() {
        return this.mMaximumCapacity;
    }

    @Nullable
    public Instant firstTimestamp() {
        return this.mTimeIndex.firstKey();
    }

    @Nullable
    public Instant lastTimestamp() {
        return this.mTimeIndex.lastKey();
    }

    public Collection<ENotificationMessage> retrieve(int numMessages) {
        if (numMessages <= 0) {
            throw new IllegalArgumentException("numMessages <= 0");
        }
        int n = this.mMessageCount < numMessages ? this.mMessageCount : numMessages;
        int beginIndex = 0;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.mMessageCount == this.mMaximumCapacity && (beginIndex = this.mInsertIndex - (n + 1)) < 0) {
            beginIndex = this.mMaximumCapacity + beginIndex;
        }
        int index = beginIndex;
        boolean firstIteration = true;
        while (index != this.mInsertIndex || firstIteration) {
            builder.add((Object)this.mStore[index]);
            index = this.incrementIndex(index);
            firstIteration = false;
        }
        return builder.build();
    }

    public void clear() {
        this.mMessageCount = 0;
        this.mInsertIndex = 0;
        Arrays.fill(this.mStore, null);
        this.mTimeIndex.clear();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void removeOldestMessage(int index) {
        ENotificationMessage msg = this.mStore[index];
        Instant ts = Instant.ofEpochMilli(msg.timestamp);
        int[] indices = (int[])this.mTimeIndex.get(ts);
        if (indices == null || indices[0] != index) {
            throw new IllegalStateException(String.format("time index missing for %s", ts));
        }
        if (indices[1] == index) {
            this.mTimeIndex.remove(ts);
        } else {
            indices[0] = this.incrementIndex(index);
        }
    }

    private int incrementIndex(int index) {
        return (index + 1) % this.mMaximumCapacity;
    }

    public static final class Builder {
        private EMessageKey mKey;
        private int mMaxCapacity = 1000;

        private Builder() {
        }

        public Builder key(EMessageKey key) {
            Objects.requireNonNull(key, "key is null");
            if (!key.isNotification()) {
                throw new IllegalArgumentException(key.className() + " is not a notification message class");
            }
            this.mKey = key;
            return this;
        }

        public Builder maximumCapacity(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("maximum capacity <= zero");
            }
            this.mMaxCapacity = n;
            return this;
        }

        public InMemoryMessageStore build() {
            Validator problems = new Validator();
            problems.requireNotNull((Object)this.mKey, "key").throwException(ValidationException.class);
            return new InMemoryMessageStore(this);
        }
    }
}

