/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.historic;

import java.util.Collection;
import java.util.Objects;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.util.Validator;

public final class HistoricReply
extends EReplyMessage {
    private static final long serialVersionUID = 393984L;
    public final ENotificationMessage[] notifications;

    private HistoricReply(Builder builder) {
        super((EReplyMessage.Builder)builder);
        this.notifications = builder.mNotifications;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        return retval.append(super.toString()).append("\n        # notifications: ").append(this.notifications.length).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends EReplyMessage.Builder<HistoricReply, Builder> {
        private static final ENotificationMessage[] COPY_ARRAY = new ENotificationMessage[0];
        private ENotificationMessage[] mNotifications;

        private Builder() {
            super(HistoricReply.class);
        }

        protected Validator validate(Validator problems) {
            return super.validate(problems).requireNotNull((Object)this.mNotifications, "notifications");
        }

        protected HistoricReply buildImpl() {
            return new HistoricReply(this);
        }

        public Builder notifications(ENotificationMessage[] messages) {
            Objects.requireNonNull(messages, "messages is null");
            int size = messages.length;
            if (size == 0) {
                throw new IllegalArgumentException("messages is empty");
            }
            if (this.mNotifications != null) {
                throw new IllegalStateException("messages already set");
            }
            this.mNotifications = new ENotificationMessage[size];
            System.arraycopy(messages, 0, this.mNotifications, 0, size);
            return this;
        }

        public Builder notifications(Collection<ENotificationMessage> messages) {
            Objects.requireNonNull(messages, "messages is null");
            if (messages.isEmpty()) {
                throw new IllegalArgumentException("messages is empty");
            }
            if (this.mNotifications != null) {
                throw new IllegalStateException("messages already set");
            }
            this.mNotifications = messages.toArray(COPY_ARRAY);
            return this;
        }
    }
}

