/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.historic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EObject;
import net.sf.eBus.feed.historic.HistoricRequest;
import net.sf.eBus.feed.historic.PublishStatusEvent;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.util.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EAbstractHistoricFeed<T extends EObject> {
    private static final Logger sLogger = LoggerFactory.getLogger(EAbstractHistoricFeed.class);
    protected final String mName;
    protected final T mOwner;
    protected final EMessageKey mKey;
    protected final EMessageKey mStatusKey;
    protected final EMessageKey mRequestKey;
    protected final EFeed.FeedScope mScope;
    protected boolean mIsOpen;
    protected boolean mInPlace;
    protected EFeedState mFeedState;

    protected EAbstractHistoricFeed(Builder<T, ?, ?> builder) {
        this.mName = builder.mName;
        this.mOwner = builder.mOwner;
        this.mKey = builder.mKey;
        this.mStatusKey = builder.mStatusKey;
        this.mRequestKey = builder.mRequestKey;
        this.mScope = builder.mScope;
        this.mIsOpen = true;
        this.mInPlace = false;
        this.mFeedState = EFeedState.UNKNOWN;
    }

    protected abstract void doClose();

    public final boolean isOpen() {
        return this.mIsOpen;
    }

    public final boolean inPlace() {
        return this.mInPlace;
    }

    public final EMessageKey key() {
        return this.mKey;
    }

    public final EMessageKey publisherStatusKey() {
        return this.mStatusKey;
    }

    public final EMessageKey requestKey() {
        return this.mRequestKey;
    }

    public final EFeed.FeedScope scope() {
        return this.mScope;
    }

    public final EFeedState feedState() {
        return this.mFeedState;
    }

    @VisibleForTesting
    final T owner() {
        return this.mOwner;
    }

    public final void close() {
        sLogger.debug("{}: closing historic feed.", (Object)this.mName);
        this.mIsOpen = false;
        this.mInPlace = false;
        this.mFeedState = EFeedState.UNKNOWN;
        try {
            this.doClose();
        }
        catch (Exception jex) {
            sLogger.warn("{}: failure closing historic feed:", (Object)this.mName, (Object)jex);
        }
        sLogger.info("{}: historic feed closed.", (Object)this.mName);
    }

    protected final void closeFeed(EFeed feed) {
        if (feed != null) {
            feed.close();
        }
    }

    protected static abstract class Builder<T extends EObject, F extends EAbstractHistoricFeed<T>, B extends Builder<T, F, ?>> {
        protected static final AtomicInteger sFeedIndex = new AtomicInteger();
        protected final T mOwner;
        protected final Class<F> mFeedClass;
        protected final EMessageKey mKey;
        protected final EMessageKey mStatusKey;
        protected final EMessageKey mRequestKey;
        protected String mName;
        protected EFeed.FeedScope mScope;

        protected Builder(T owner, Class<F> feedClass, EMessageKey key) {
            this.mOwner = owner;
            this.mFeedClass = feedClass;
            this.mKey = key;
            this.mStatusKey = new EMessageKey(PublishStatusEvent.class, this.mKey.subject());
            this.mRequestKey = new EMessageKey(HistoricRequest.class, this.mKey.subject());
        }

        protected abstract B self();

        protected abstract String generateName();

        protected abstract F buildImpl();

        public final B name(@Nullable String name) {
            this.mName = name;
            return this.self();
        }

        public final B scope(EFeed.FeedScope scope) {
            this.mScope = Objects.requireNonNull(scope, "scope is null");
            return this.self();
        }

        public final F build() {
            Validator problems = new Validator();
            this.validate(problems).throwException(this.mFeedClass);
            if (Strings.isNullOrEmpty((String)this.mName)) {
                this.mName = this.generateName();
            }
            return this.buildImpl();
        }

        protected Validator validate(Validator problems) {
            return problems.requireNotNull(this.mOwner, "owner").requireNotNull((Object)this.mScope, "scope");
        }
    }
}

