//
// Copyright 2023 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.feed.historic.store;

import net.sf.eBus.messages.ENotificationMessage;

/**
 * Generates SQL insert statement used to put an eBus
 * {@link ENotificationMessage notification message} into
 * database. Unlike {@link IRetrieveGenerator message retrieval},
 * this generator both encodes the notification message and
 * creates the SQL insert statement.
 * <p>
 * (Message retrieval generates the select statement and decodes
 * the eBus notification message in two separate steps.)
 * </p>
 *
 * @see IRetrieveGenerator
 * @see IMessageDecoder
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@FunctionalInterface
public interface IInsertGenerator
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * Returns SQL statement used to insert given eBus
     * notification message into database.
     * @param message eBus notification message.
     * @return SQL insert statement.
     */
    String insertStatement(ENotificationMessage message);
} // end of interface IInsertGenerator

