/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EObject;
import net.sf.eBus.client.ESubscribeFeed;
import net.sf.eBus.client.ESubscriber;
import net.sf.eBus.client.FeedStatusCallback;
import net.sf.eBus.client.IESubscribeFeed;
import net.sf.eBus.client.NotifyCallback;
import net.sf.eBus.feed.pattern.EventPattern;
import net.sf.eBus.feed.pattern.MatchCondition;
import net.sf.eBus.feed.pattern.MatchEvent;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.util.Validator;

public abstract class EPatternFeed
extends EFeed
implements ESubscriber,
IESubscribeFeed {
    protected static final Logger sLogger = Logger.getLogger(EPatternFeed.class.getName());
    private static int sNextFrameId = 0;
    protected final String mPatternName;
    protected final EMessageKey mPubKey;
    protected final BiPredicate<List<ENotificationMessage>, ENotificationMessage> mUntil;
    protected final boolean mIsExclusive;
    protected final Predicate<MatchEvent> mCondition;
    protected final List<ESubscribeFeed> mSubFeeds;
    protected final Map<ENotificationMessage, List<AbstractMatchFrame>> mEventFrames;
    protected final FeedStatusCallback<IESubscribeFeed> mStatusCallback;
    protected final NotifyCallback mNotifyCallback;
    protected long mAllSubFeedsMask;
    protected long mSubFeedMask;

    protected EPatternFeed(PatternBuilder builder) {
        super((EFeed.Builder)builder);
        EventPattern pattern = builder.mPattern;
        this.mPatternName = pattern.patternName();
        this.mPubKey = new EMessageKey(MatchEvent.class, this.mPatternName);
        this.mUntil = pattern.until();
        this.mIsExclusive = pattern.isExclusive();
        this.mCondition = pattern.patternCondition();
        this.mEventFrames = this.mIsExclusive ? new HashMap() : null;
        this.mStatusCallback = builder.mStatusCallback;
        this.mNotifyCallback = builder.mNotifyCallback;
        this.mSubFeeds = new ArrayList<ESubscribeFeed>();
        this.mSubFeedMask = 0L;
        this.mAllSubFeedsMask = 0L;
    }

    protected abstract void matchEvent(ENotificationMessage var1, int var2);

    protected final void inactivate() {
        this.unsubscribe();
    }

    public final EMessageKey key() {
        return this.mPubKey;
    }

    public final void subscribe() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            if (sLogger.isLoggable(Level.FINEST)) {
                StringBuilder output = new StringBuilder();
                output.append(this.mPubKey).append(" subscribing to ").append(this.mSubFeeds.size()).append(":");
                this.mSubFeeds.forEach(feed -> output.append('\n').append(feed));
            } else if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s: subscribing to %d subordinate feeds.", this.mPubKey, this.mSubFeeds.size()));
            }
            this.mSubFeeds.stream().forEachOrdered(ESubscribeFeed::subscribe);
            this.mInPlace = true;
        }
    }

    public final void unsubscribe() {
        if (this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s subscriber %d, feed %d: unsubscribing.", this.mEClient.location(), this.mEClient.clientId(), this.mFeedId));
            }
            this.mSubFeeds.forEach(ESubscribeFeed::unsubscribe);
        }
    }

    protected final void onFeedStateUpdate(EFeedState state, IESubscribeFeed feed) {
        long startMask = this.mSubFeedMask;
        int feedId = feed.feedId();
        long feedMask = 1L << feedId;
        boolean postUpdate = false;
        this.mSubFeedMask = state == EFeedState.UP ? (this.mSubFeedMask |= feedMask) : (this.mSubFeedMask &= feedMask ^ 0xFFFFFFFFFFFFFFFFL);
        if (startMask != this.mSubFeedMask) {
            if (this.mSubFeedMask == this.mAllSubFeedsMask) {
                this.mFeedState = EFeedState.UP;
                postUpdate = true;
            } else if (startMask == this.mAllSubFeedsMask) {
                this.mFeedState = EFeedState.DOWN;
                postUpdate = true;
            }
        }
        if (postUpdate) {
            EClient.dispatch((Runnable)new EFeed.StatusTask((EFeed)this, this.mFeedState, (EFeed)this, this.mStatusCallback), (EObject)this.mEClient.target());
        }
    }

    protected final void onEvent(ENotificationMessage event, IESubscribeFeed feed) {
        if (this.mSubFeedMask == this.mAllSubFeedsMask) {
            this.matchEvent(event, feed.feedId());
        }
    }

    public final boolean isExclusive() {
        return this.mIsExclusive;
    }

    protected final void addMapping(ENotificationMessage event, AbstractMatchFrame mf) {
        List<AbstractMatchFrame> frames = this.mEventFrames.get(event);
        if (frames == null) {
            frames = new ArrayList<AbstractMatchFrame>();
            this.mEventFrames.put(event, frames);
        }
        frames.add(mf);
    }

    protected final void markDefunct(List<ENotificationMessage> events) {
        for (ENotificationMessage event : events) {
            List<AbstractMatchFrame> frames = this.mEventFrames.remove(event);
            if (frames == null) continue;
            for (AbstractMatchFrame frame : frames) {
                frame.setDefunct();
            }
        }
    }

    protected static boolean componentTest(ENotificationMessage e, AbstractMatchFrame mf, MatchCondition mc) {
        boolean retcode;
        try {
            Map<String, List<ENotificationMessage>> groups = mf.groupMap();
            Map<Object, Object> userCache = mf.userCache();
            retcode = mc.test(e, groups, userCache);
        }
        catch (Throwable tex) {
            sLogger.log(Level.WARNING, "notify", String.format("%s match condition exception", mf.mPatternName));
            retcode = false;
        }
        return retcode;
    }

    protected static abstract class AbstractMatchFrame {
        protected final String mPatternName;
        protected final List<ENotificationMessage> mAllEvents;
        protected final Map<Object, Object> mUserCache;
        protected final boolean mIsExclusive;
        protected boolean mIsDefunct;
        private final int mFrameId;

        protected AbstractMatchFrame(String patternName, boolean isExclusive) {
            this.mPatternName = patternName;
            this.mAllEvents = new ArrayList<ENotificationMessage>();
            this.mUserCache = new HashMap<Object, Object>();
            this.mIsExclusive = isExclusive;
            this.mIsDefunct = false;
            this.mFrameId = AbstractMatchFrame.nextFrameIdentifier();
        }

        protected AbstractMatchFrame(AbstractMatchFrame frame) {
            this.mPatternName = frame.mPatternName;
            this.mIsExclusive = frame.mIsExclusive;
            this.mAllEvents = new ArrayList<ENotificationMessage>(frame.mAllEvents);
            this.mUserCache = new HashMap<Object, Object>(frame.mUserCache);
            this.mIsDefunct = false;
            this.mFrameId = AbstractMatchFrame.nextFrameIdentifier();
        }

        protected abstract Map<String, List<ENotificationMessage>> groupMap();

        public String toString() {
            int i = 0;
            StringBuilder retval = new StringBuilder();
            retval.append(this.mPatternName).append(' ').append(this.mFrameId).append("\nEvents:");
            for (ENotificationMessage event : this.mAllEvents) {
                retval.append("\n  [").append(i).append("] ").append(event);
                ++i;
            }
            return retval.toString();
        }

        public final String patternName() {
            return this.mPatternName;
        }

        public final int frameId() {
            return this.mFrameId;
        }

        public final boolean isExclusive() {
            return this.mIsExclusive;
        }

        public final List<ENotificationMessage> allEvents() {
            return Collections.unmodifiableList(this.mAllEvents);
        }

        public final Map<Object, Object> userCache() {
            return this.mUserCache;
        }

        public final boolean isDefunct() {
            return this.mIsDefunct;
        }

        public final void setDefunct() {
            this.mIsDefunct = true;
        }

        private static int nextFrameIdentifier() {
            int retval = sNextFrameId++;
            return retval;
        }
    }

    public static abstract class PatternBuilder<F extends EPatternFeed, B extends PatternBuilder<F, ?>>
    extends EFeed.Builder<F, ESubscriber, B> {
        protected EventPattern mPattern;
        protected FeedStatusCallback<IESubscribeFeed> mStatusCallback;
        protected NotifyCallback mNotifyCallback;

        protected PatternBuilder(Class<F> tc) {
            super(tc);
            this.mScope = EFeed.FeedScope.LOCAL_ONLY;
        }

        public final B eventPattern(EventPattern pattern) {
            Objects.requireNonNull(pattern, "pattern is null");
            this.mPattern = pattern;
            return (B)((Object)((PatternBuilder)this.self()));
        }

        public final B statusCallback(FeedStatusCallback<IESubscribeFeed> cb) {
            this.mStatusCallback = cb;
            return (B)((Object)((PatternBuilder)this.self()));
        }

        public final B notifyCallback(NotifyCallback cb) {
            this.mNotifyCallback = cb;
            return (B)((Object)((PatternBuilder)this.self()));
        }

        public final B scope(EFeed.FeedScope scope) {
            throw new UnsupportedOperationException("pattern feed scope is local only and may not be changed");
        }

        public Validator validate(Validator problems) {
            if (this.mStatusCallback == null && this.mTarget != null && this.isOverridden("feedStatus", new Class[]{EFeedState.class, IESubscribeFeed.class})) {
                this.mStatusCallback = (arg_0, arg_1) -> ((ESubscriber)((ESubscriber)this.mTarget)).feedStatus(arg_0, arg_1);
            }
            if (this.mNotifyCallback == null && this.mTarget != null && this.isOverridden("notify", new Class[]{ENotificationMessage.class, IESubscribeFeed.class})) {
                this.mNotifyCallback = (arg_0, arg_1) -> ((ESubscriber)((ESubscriber)this.mTarget)).notify(arg_0, arg_1);
            }
            return super.validate(problems).requireNotNull((Object)this.mPattern, "pattern").requireNotNull(this.mStatusCallback, "statusCallback").requireNotNull((Object)this.mNotifyCallback, "notifyCallback");
        }
    }
}

