/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.historic;

import java.util.Objects;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.util.Validator;

public final class PublishStatusEvent
extends ENotificationMessage {
    private static final long serialVersionUID = 393984L;
    public final EMessageKey key;
    public final EFeedState feedState;

    private PublishStatusEvent(Builder builder) {
        super((ENotificationMessage.Builder)builder);
        this.key = builder.mKey;
        this.feedState = builder.mFeedState;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        return retval.append(super.toString()).append("\n                   key: ").append(this.key).append("\n            feed state: ").append(this.feedState).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ENotificationMessage.Builder<PublishStatusEvent, Builder> {
        private EMessageKey mKey;
        private EFeedState mFeedState;

        private Builder() {
            super(PublishStatusEvent.class);
        }

        protected PublishStatusEvent buildImpl() {
            return new PublishStatusEvent(this);
        }

        protected Validator validate(Validator problems) {
            return super.validate(problems).requireTrue(this.mPubId > 0L, "publisherId", "publisherId not set").requireNotNull((Object)this.mKey, "key").requireNotNull((Object)this.mFeedState, "feedState");
        }

        public Builder key(EMessageKey key) {
            Objects.requireNonNull(key, "message key is null");
            if (!key.isNotification()) {
                throw new IllegalArgumentException("not a notification key");
            }
            this.mKey = key;
            return this;
        }

        public Builder feedState(EFeedState feedState) {
            this.mFeedState = Objects.requireNonNull(feedState, "feed state is null");
            return this;
        }
    }
}

