//
// Copyright 2024 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

/**
 * This package contains two implementations of
 * {@link net.sf.eBus.feed.historic.IEMessageStore} interface:
 * {@link net.sf.eBus.feed.historic.store.InMemoryMessageStore InMemoryMessageStore}
 * and
 * {@link net.sf.eBus.feed.historic.store.SqlMessageStore SqlMessageStore}.
 * In-memory stores eBus messages (and
 * {@link net.sf.eBus.feed.historic.PublishStatusEvent publish status events}
 * in a fixed-size ring buffer. These messages are <em>not</em>
 * persisted. When the application stores, the messages are lost
 * unless persisted by the application itself.
 * <p>
 * SQL message store persists messages to an SQL database. The
 * user is required to provide code which generates SQL
 * statements to insert, retrieve, and decode eBus messages. This
 * code provides the link between {@code SqlMessageStore} and the
 * actual database. This allows {@code SqlMessageStore} to work
 * with multiple SQL database engines.
 * </p>
 * <p>
 * See {@code InMemoryMessageStore} and {@code SqlMessageStore}
 * javadocs for detailed explanation on how to use these classes.
 * </p>
 */

package net.sf.eBus.feed.historic.store;
