//
// Copyright 2018 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.feed.pattern;

import java.util.List;
import java.util.Map;
import net.sf.eBus.messages.ENotificationMessage;

/**
 * Implement this method to test if the latest event matches the
 * pattern. This allows for tests beyond simply matching the
 * pattern.
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@FunctionalInterface
public interface MatchCondition
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * Returns {@code true} if {@code event} satisfies this
     * condition, allowing the event pattern matching to continue
     * or complete. If {@code event} does not meet the pattern
     * condition, then the current match is abandoned.
     * <p>
     * Two further pieces of information are provided to help
     * with the test: the
     * <a href="CapturingGroups">capturing groups</a> and the
     * <a href="UserCache">user-defined data cache</a>
     * (which see for more information).
     * </p>
     * <p>
     * <strong>Note:</strong> if this method should throw any
     * exception that is treated as a test failure and the
     * current match is abandoned.
     * </p>
     * @param event test if this event matches the pattern.
     * @param groups the capturing groups so far.
     * @param userCache map containing user data.
     * @return {@code true} if {@code event} satisfies the match
     * condition.
     */
    boolean test(ENotificationMessage event,
                 Map<String, List<ENotificationMessage>> groups,
                 Map<Object, Object> userCache);
} // end of interface MatchCondition

