/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.historic;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.sf.eBus.client.ECondition;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.ERequestFeed;
import net.sf.eBus.client.ERequestor;
import net.sf.eBus.client.ESubscribeFeed;
import net.sf.eBus.client.ESubscriber;
import net.sf.eBus.client.IERequestFeed;
import net.sf.eBus.client.IESubscribeFeed;
import net.sf.eBus.feed.historic.EAbstractHistoricFeed;
import net.sf.eBus.feed.historic.HistoricFeedDoneCallback;
import net.sf.eBus.feed.historic.HistoricFeedStatusCallback;
import net.sf.eBus.feed.historic.HistoricNotifyCallback;
import net.sf.eBus.feed.historic.HistoricReply;
import net.sf.eBus.feed.historic.HistoricRequest;
import net.sf.eBus.feed.historic.IEHistoricSubscriber;
import net.sf.eBus.feed.historic.PublishStatusEvent;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.util.TimerEvent;
import net.sf.eBus.util.TimerTask;
import net.sf.eBus.util.ValidationException;
import net.sf.eBus.util.Validator;
import net.sf.eBusx.time.EInterval;

public final class EHistoricSubscribeFeed
extends EAbstractHistoricFeed<IEHistoricSubscriber>
implements ESubscriber,
ERequestor {
    public static final String DEFAULT_SUBSCRIBE_FEED_NAME = "EHistoricSubscribeFeed-";
    private static final String TIMER_NAME = "HistoricTimer";
    private static final Logger sLogger = Logger.getLogger(EHistoricSubscribeFeed.class.getName());
    private static final Timer sTimer = new Timer("HistoricTimer", true);
    private final ECondition mCondition;
    private final HistoricFeedDoneCallback mDoneCallback;
    private final HistoricFeedStatusCallback mStatusCallback;
    private final HistoricNotifyCallback mNotifyCallback;
    private final TimeLocation mBeginLocation;
    private final Instant mBeginTime;
    private final EInterval.Clusivity mBeginClusivity;
    private final TimeLocation mEndLocation;
    private final Instant mEndTime;
    private final EInterval.Clusivity mEndClusivity;
    private final AtomicReference<HistoricFeedState> mState;
    private Exception mErrorCause;
    private ESubscribeFeed mSubscribeFeed;
    private TimerTask mEndTimer;
    private ESubscribeFeed mStatusFeed;
    private ERequestFeed mRequestFeed;
    private ERequestFeed.ERequest mRequest;
    private List<ENotificationMessage> mMessages;

    private EHistoricSubscribeFeed(Builder builder) {
        super(builder);
        this.mCondition = builder.mCondition;
        this.mDoneCallback = builder.getDoneCallback();
        this.mStatusCallback = builder.getStatusCallback();
        this.mNotifyCallback = builder.getNotifyCallback();
        this.mBeginLocation = builder.mBeginLocation;
        this.mBeginTime = builder.mBeginTime;
        this.mBeginClusivity = builder.mBeginClusivity;
        this.mEndLocation = builder.mEndLocation;
        this.mEndTime = builder.mEndTime;
        this.mEndClusivity = builder.mEndClusivity;
        this.mState = new AtomicReference<HistoricFeedState>(HistoricFeedState.FEED_OPEN);
    }

    @Override
    protected void doClose() {
        if (this.mEndTimer != null) {
            this.mEndTimer.cancel();
            this.mEndTimer = null;
        }
        this.closeFeed((EFeed)this.mSubscribeFeed);
        this.mSubscribeFeed = null;
        this.closeFeed((EFeed)this.mStatusFeed);
        this.mStatusFeed = null;
        this.closeFeed((EFeed)this.mRequestFeed);
        this.mRequestFeed = null;
        if (this.mMessages != null) {
            this.mMessages.clear();
            this.mMessages = null;
        }
    }

    public String name() {
        return this.mName;
    }

    public void startup() {
        ERequestFeed.Builder reqBuilder = ERequestFeed.builder();
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s: starting.", this.mName));
        }
        if (this.mEndLocation.isFuture()) {
            ESubscribeFeed.Builder subBuilder = ESubscribeFeed.builder();
            ESubscribeFeed.Builder statBuilder = ESubscribeFeed.builder();
            this.mSubscribeFeed = (ESubscribeFeed)((ESubscribeFeed.Builder)((ESubscribeFeed.Builder)((ESubscribeFeed.Builder)subBuilder.target(this.mOwner)).messageKey(this.mKey)).scope(this.mScope)).statusCallback(this::liveStatus).notifyCallback(this::liveNotification).build();
            this.mStatusFeed = (ESubscribeFeed)((ESubscribeFeed.Builder)((ESubscribeFeed.Builder)((ESubscribeFeed.Builder)statBuilder.target(this.mOwner)).messageKey(this.mStatusKey)).scope(this.mScope)).statusCallback(this::liveStatus).notifyCallback(this::livePublisherStatus).build();
            if (this.mEndLocation == TimeLocation.FUTURE) {
                this.mEndTimer = this.scheduleEndTimer(this.mEndTime, this.mEndClusivity);
            }
        }
        if (this.mBeginLocation.isPast()) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s: opening %s request feed.", this.mName, this.mRequestKey));
            }
            this.mRequestFeed = (ERequestFeed)((ERequestFeed.Builder)((ERequestFeed.Builder)reqBuilder.target(this.mOwner)).messageKey(this.mRequestKey).scope(this.mScope)).statusCallback(this::replyStatus).replyCallback(EReplyMessage.class, this::emptyHistoricReply).replyCallback(HistoricReply.class, this::historicReply).build();
        }
        this.mIsOpen = true;
        if (sLogger.isLoggable(Level.INFO)) {
            sLogger.info(String.format("%s: started.", this.mName));
        }
    }

    public void shutdown() {
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("{}: shutting down.", this.mName));
        }
        this.close();
        if (sLogger.isLoggable(Level.INFO)) {
            sLogger.info(String.format("{}: shut down.", this.mName));
        }
    }

    private void liveStatus(EFeedState state, IESubscribeFeed feed) {
        if (sLogger.isLoggable(Level.INFO)) {
            sLogger.info(String.format("%s: notification feed %s is %s.", this.mName, feed.key(), state));
        }
    }

    private void livePublisherStatus(ENotificationMessage msg, IESubscribeFeed feed) {
        PublishStatusEvent pse = (PublishStatusEvent)msg;
        if (sLogger.isLoggable(Level.INFO)) {
            sLogger.info(String.format("%s: publisher %s notification feed %s is %s.", this.mName, pse.publisherId, pse.key, pse.feedState));
        }
        if (this.mState.get() == HistoricFeedState.LIVE_NOTIFICATIONS) {
            this.forwardPublisherStatus(pse);
        } else {
            this.mMessages.add(msg);
        }
    }

    private void liveNotification(ENotificationMessage msg, IESubscribeFeed feed) {
        if (this.isInEndTime(msg.timestamp)) {
            if (this.mState.get() == HistoricFeedState.LIVE_NOTIFICATIONS) {
                this.forwardNotification(msg);
            } else {
                this.mMessages.add(msg);
            }
        }
    }

    private void replyStatus(EFeedState feedState, IERequestFeed feed) {
        if (sLogger.isLoggable(Level.INFO)) {
            sLogger.info(String.format("%s: request feed %s is %s.", this.mName, feed.key(), feedState));
        }
        if (feedState == EFeedState.UP && this.mRequest == null) {
            this.placeRequest();
        }
    }

    private void emptyHistoricReply(int remaining, EReplyMessage reply, ERequestFeed.ERequest request) {
        ERequestFeed.RequestState state = request.requestState();
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: historic reply, request state %s, %d remaining.", this.mName, state, remaining));
        }
        if (state == ERequestFeed.RequestState.DONE || state == ERequestFeed.RequestState.CANCELED) {
            this.playback();
        }
    }

    private void historicReply(int remaining, EReplyMessage reply, ERequestFeed.ERequest request) {
        HistoricReply histReply = (HistoricReply)reply;
        int numMessages = histReply.notifications.length;
        ERequestFeed.RequestState state = request.requestState();
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: historic reply with %d notifications, request state %s, %d remaining.", this.mName, numMessages, state, remaining));
        }
        for (int i = 0; i < numMessages; ++i) {
            this.mMessages.add(histReply.notifications[i]);
        }
        if (remaining == 0) {
            this.playback();
        }
    }

    private void endOfLiveStream(TimerEvent event) {
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s: %s live stream ended, state=%s.", new Object[]{this.mName, this.mKey, this.mState.get()}));
        }
        if (this.mState.compareAndSet(HistoricFeedState.LIVE_NOTIFICATIONS, HistoricFeedState.DONE_SUCCESS)) {
            this.close();
            this.forwardFeedDone(this.mState.get());
        }
    }

    public TimeLocation beginLocation() {
        return this.mBeginLocation;
    }

    @Nullable
    public Instant beginTime() {
        return this.mBeginTime;
    }

    public EInterval.Clusivity beginClusivity() {
        return this.mBeginClusivity;
    }

    public TimeLocation endLocation() {
        return this.mEndLocation;
    }

    @Nullable
    public Instant endTime() {
        return this.mEndTime;
    }

    public EInterval.Clusivity endClusivity() {
        return this.mEndClusivity;
    }

    public HistoricFeedState state() {
        return this.mState.get();
    }

    @Nullable
    public Exception errorCause() {
        return this.mErrorCause;
    }

    public void subscribe() {
        if (!this.mIsOpen) {
            throw new IllegalStateException("feed is closed");
        }
        if (!this.mInPlace) {
            if (this.mEndLocation.isFuture()) {
                if (sLogger.isLoggable(Level.FINER)) {
                    sLogger.finer(String.format("%s: subscribing to %s (%s)", this.mName, this.mKey, this.mScope));
                }
                this.mStatusFeed.subscribe();
                this.mSubscribeFeed.subscribe();
            }
            if (this.mBeginLocation.isPast()) {
                if (sLogger.isLoggable(Level.FINER)) {
                    sLogger.finer(String.format("%s: subscribing to %s (%s)", this.mName, this.mRequestKey, this.mScope));
                }
                this.mState.set(HistoricFeedState.HISTORIC_NOTIFICATIONS);
                this.mRequestFeed.subscribe();
            } else {
                this.mState.set(HistoricFeedState.LIVE_NOTIFICATIONS);
            }
            this.mInPlace = true;
        }
    }

    public static Builder builder(EMessageKey key, IEHistoricSubscriber subscriber) {
        Objects.requireNonNull(key, "message key is null");
        Objects.requireNonNull(subscriber, "subscriber is null");
        if (!key.isNotification()) {
            throw new IllegalArgumentException("not a notification message key");
        }
        return new Builder(subscriber, key);
    }

    @Nullable
    private TimerTask scheduleEndTimer(Instant endTime, EInterval.Clusivity endClusivity) {
        long now = System.currentTimeMillis();
        long et = endTime.toEpochMilli();
        long delta = endClusivity == EInterval.Clusivity.EXCLUSIVE ? et - now : et - now + 1L;
        TimerTask retval = null;
        if (delta >= 0L) {
            retval = new TimerTask(this::endOfLiveStream);
            sTimer.schedule((java.util.TimerTask)retval, delta);
        }
        return retval;
    }

    private void placeRequest() {
        Instant now = Instant.now();
        EInterval.Builder intervalBuilder = EInterval.builder();
        this.mState.set(HistoricFeedState.HISTORIC_NOTIFICATIONS);
        this.mMessages = new ArrayList<ENotificationMessage>();
        intervalBuilder.beginTime(this.mBeginTime).beginClusivity(this.mBeginClusivity);
        if (this.mEndLocation.isPast()) {
            intervalBuilder.endTime(this.mEndTime).endClusivity(this.mEndClusivity);
        } else {
            intervalBuilder.endTime(now).endClusivity(EInterval.Clusivity.INCLUSIVE);
        }
        EInterval interval = (EInterval)intervalBuilder.build();
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s: placing %s request, interval=%s", this.mName, this.mKey, interval));
        }
        try {
            HistoricRequest.Builder builder = HistoricRequest.builder();
            HistoricRequest reqMessage = (HistoricRequest)((HistoricRequest.Builder)((HistoricRequest.Builder)builder.subject(this.mRequestKey.subject())).timestamp(now)).interval(interval).build();
            this.mRequest = this.mRequestFeed.request((ERequestMessage)reqMessage);
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException | ValidationException jex) {
            sLogger.log(Level.WARNING, String.format("%s: %s historic notification request failed: %s", this.mName, this.mKey, jex.getMessage()), jex);
            this.mState.set(HistoricFeedState.DONE_ERROR);
            this.mErrorCause = jex;
            this.close();
            this.forwardFeedDone(this.mState.get());
        }
    }

    private boolean isInEndTime(long timestamp) {
        long endTime = this.mEndTime == null ? 0L : this.mEndTime.toEpochMilli();
        return this.mEndLocation == TimeLocation.ON_GOING || this.mEndClusivity == EInterval.Clusivity.EXCLUSIVE && timestamp < endTime || this.mEndClusivity == EInterval.Clusivity.INCLUSIVE && timestamp <= endTime;
    }

    private void playback() {
        this.mMessages.sort(new PastComparator());
        this.mMessages.forEach(this::playback);
        this.mMessages.clear();
        this.mMessages = null;
        if (this.mEndLocation.mIsPast || this.mEndLocation == TimeLocation.NOW) {
            this.mState.set(HistoricFeedState.DONE_SUCCESS);
            this.forwardFeedDone(this.mState.get());
        } else {
            this.mState.set(HistoricFeedState.LIVE_NOTIFICATIONS);
        }
    }

    private void playback(ENotificationMessage msg) {
        if (msg instanceof PublishStatusEvent) {
            this.forwardPublisherStatus((PublishStatusEvent)msg);
        } else {
            this.forwardNotification(msg);
        }
    }

    private void forwardFeedDone(HistoricFeedState state) {
        try {
            this.mDoneCallback.call(state, this);
        }
        catch (Exception jex) {
            sLogger.log(Level.WARNING, String.format("%s: historic subscriber callback exception:", this.mName), jex);
        }
    }

    private void forwardPublisherStatus(PublishStatusEvent pse) {
        try {
            this.mStatusCallback.call(pse, this);
        }
        catch (Exception jex) {
            sLogger.log(Level.WARNING, String.format("%s: subscriber feed status callback exception:", this.mName), jex);
        }
    }

    private void forwardNotification(ENotificationMessage msg) {
        try {
            if (this.mCondition.test((EMessage)msg)) {
                this.mNotifyCallback.call(msg, this);
            }
        }
        catch (Exception jex) {
            sLogger.log(Level.WARNING, String.format("%s: subscriber notify callback exception:", this.mName), jex);
        }
    }

    private static final class PastComparator
    implements Comparator<ENotificationMessage> {
        private PastComparator() {
        }

        @Override
        public int compare(ENotificationMessage o1, ENotificationMessage o2) {
            int retval = Long.compare(o1.timestamp, o2.timestamp);
            if (retval == 0 && (retval = Long.compare(o1.publisherId, o2.publisherId)) == 0) {
                retval = o1.position - o2.position;
            }
            return retval;
        }
    }

    public static final class Builder
    extends EAbstractHistoricFeed.Builder<IEHistoricSubscriber, EHistoricSubscribeFeed, Builder> {
        private ECondition mCondition = EFeed.NO_CONDITION;
        private HistoricFeedDoneCallback mDoneCallback;
        private HistoricFeedStatusCallback mStatusCallback;
        private HistoricNotifyCallback mNotifyCallback;
        private TimeLocation mBeginLocation;
        private Instant mBeginTime;
        private EInterval.Clusivity mBeginClusivity;
        private TimeLocation mEndLocation;
        private Instant mEndTime;
        private EInterval.Clusivity mEndClusivity;

        private Builder(IEHistoricSubscriber subscriber, EMessageKey key) {
            super(subscriber, EHistoricSubscribeFeed.class, key);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected Validator validate(Validator problems) {
            return super.validate(problems).requireNotNull((Object)this.mBeginLocation, "beginLocation").requireNotNull((Object)this.mEndLocation, "endLocation").requireTrue(this.mBeginLocation == TimeLocation.NOW || this.mBeginTime != null, "beginTime", "beginTime not set").requireTrue(this.mEndLocation == TimeLocation.NOW || this.mEndLocation == TimeLocation.ON_GOING || this.mEndTime != null, "endTime", "endTime not set").requireTrue(this.beginEndTimeCompare(), "beginTime", "beginTime >= endTime");
        }

        @Override
        protected String generateName() {
            return EHistoricSubscribeFeed.DEFAULT_SUBSCRIBE_FEED_NAME + sFeedIndex.getAndIncrement();
        }

        @Override
        protected EHistoricSubscribeFeed buildImpl() {
            return new EHistoricSubscribeFeed(this);
        }

        private HistoricFeedDoneCallback getDoneCallback() {
            if (this.mDoneCallback == null) {
                this.mDoneCallback = ((IEHistoricSubscriber)this.mOwner)::feedDone;
            }
            return this.mDoneCallback;
        }

        private HistoricFeedStatusCallback getStatusCallback() {
            if (this.mStatusCallback == null) {
                this.mStatusCallback = ((IEHistoricSubscriber)this.mOwner)::feedStatus;
            }
            return this.mStatusCallback;
        }

        private HistoricNotifyCallback getNotifyCallback() {
            if (this.mNotifyCallback == null) {
                this.mNotifyCallback = ((IEHistoricSubscriber)this.mOwner)::notify;
            }
            return this.mNotifyCallback;
        }

        public Builder condition(ECondition condition) {
            this.mCondition = condition == null ? EFeed.NO_CONDITION : condition;
            return this;
        }

        public Builder doneCallback(@Nullable HistoricFeedDoneCallback cb) {
            this.mDoneCallback = cb;
            return this;
        }

        public Builder statusCallback(@Nullable HistoricFeedStatusCallback cb) {
            this.mStatusCallback = cb;
            return this;
        }

        public Builder notifyCallback(@Nullable HistoricNotifyCallback cb) {
            this.mNotifyCallback = cb;
            return this;
        }

        public Builder from(Instant beginTime, EInterval.Clusivity beginClusivity) {
            Objects.requireNonNull(beginTime, "begin time is null");
            Objects.requireNonNull(beginClusivity, "begin clusivity is null");
            if (beginTime.compareTo(Instant.now()) >= 0) {
                throw new IllegalArgumentException("begin time is not in the past");
            }
            if (this.mBeginLocation != null) {
                throw new IllegalStateException("begin time already set");
            }
            this.mBeginLocation = TimeLocation.PAST;
            this.mBeginTime = beginTime;
            this.mBeginClusivity = beginClusivity;
            return this;
        }

        public Builder fromNow() {
            if (this.mBeginLocation != null) {
                throw new IllegalStateException("begin time already set");
            }
            this.mBeginLocation = TimeLocation.NOW;
            this.mBeginClusivity = EInterval.Clusivity.INCLUSIVE;
            return this;
        }

        public Builder to(Instant endTime, EInterval.Clusivity endClusivity) {
            Objects.requireNonNull(endTime, "end time is null");
            Objects.requireNonNull(endClusivity, "end clusivity is null");
            if (this.mEndLocation != null) {
                throw new IllegalStateException("end time already set");
            }
            int result = endTime.compareTo(Instant.now());
            if (result == 0) {
                this.mEndLocation = TimeLocation.NOW;
                this.mEndTime = null;
            } else {
                this.mEndLocation = result < 0 ? TimeLocation.PAST : TimeLocation.FUTURE;
                this.mEndTime = endTime;
            }
            this.mEndClusivity = endClusivity;
            return this;
        }

        public Builder toNow(EInterval.Clusivity endClusivity) {
            Objects.requireNonNull(endClusivity, "end clusivity is null");
            if (this.mEndLocation != null) {
                throw new IllegalStateException("end time already set");
            }
            this.mEndLocation = TimeLocation.NOW;
            this.mEndClusivity = endClusivity;
            return this;
        }

        public Builder toForever() {
            if (this.mEndLocation != null) {
                throw new IllegalStateException("end time already set");
            }
            this.mEndLocation = TimeLocation.ON_GOING;
            this.mEndTime = null;
            this.mEndClusivity = EInterval.Clusivity.INCLUSIVE;
            return this;
        }

        private boolean beginEndTimeCompare() {
            boolean retcode = this.mBeginLocation == TimeLocation.PAST ? (this.mBeginTime == null ? false : (this.mEndLocation == TimeLocation.NOW || this.mEndLocation == TimeLocation.ON_GOING ? true : (this.mEndTime == null ? false : this.mBeginTime.isBefore(this.mEndTime)))) : this.mEndLocation == TimeLocation.FUTURE || this.mEndLocation == TimeLocation.ON_GOING;
            return retcode;
        }
    }

    public static enum HistoricFeedState {
        FEED_OPEN,
        HISTORIC_NOTIFICATIONS,
        LIVE_NOTIFICATIONS,
        DONE_SUCCESS,
        DONE_ERROR;

    }

    public static enum TimeLocation {
        PAST(true, false),
        NOW(false, false),
        FUTURE(false, true),
        ON_GOING(false, true);

        private final boolean mIsPast;
        private final boolean mIsFuture;

        private TimeLocation(boolean pastFlag, boolean futureFlag) {
            this.mIsPast = pastFlag;
            this.mIsFuture = futureFlag;
        }

        public boolean isPast() {
            return this.mIsPast;
        }

        public boolean isFuture() {
            return this.mIsFuture;
        }
    }
}

