/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.historic;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import net.sf.eBus.feed.historic.HistoricReply;
import net.sf.eBus.messages.EReplyInfo;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.util.Validator;
import net.sf.eBusx.time.EInterval;

@EReplyInfo(replyMessageClasses={HistoricReply.class})
public final class HistoricRequest
extends ERequestMessage
implements Serializable {
    private static final long serialVersionUID = 393984L;
    public final EInterval interval;

    private HistoricRequest(Builder builder) {
        super((ERequestMessage.Builder)builder);
        this.interval = builder.mInterval;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        return retval.append(super.toString()).append("\n               interval: ").append(this.interval).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ERequestMessage.Builder<HistoricRequest, Builder> {
        private EInterval mInterval;

        private Builder() {
            super(HistoricRequest.class);
        }

        protected Validator validate(Validator problems) {
            return super.validate(problems).requireNotNull((Object)this.mInterval, "interval");
        }

        protected HistoricRequest buildImpl() {
            return new HistoricRequest(this);
        }

        public Builder interval(EInterval interval) {
            Instant now = Instant.now();
            Objects.requireNonNull(interval, "interval is null");
            if (now.compareTo(interval.endTime) < 0) {
                throw new IllegalArgumentException("interval is not historic");
            }
            this.mInterval = interval;
            return this;
        }
    }
}

