//
// Copyright 2022 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

/**
 * This package contains a specialized feed providing
 * notification feeds which support both historic and live
 * messages. This capability is provided by two feeds:
 * {@link net.sf.eBus.feed.historic.EHistoricPublishFeed historic publish feed}
 * and
 * {@link net.sf.eBus.feed.historic.EHistoricSubscribeFeed historic subscribe feed}.
 * <h1>Historic Publish Feed</h1>
 * Like {@code IEPublishFeed}, this feed posts live notification
 * messages to eBus if there are any live subscribers listening.
 * The value-added difference is that the historic publish feed
 * persists notifications using the configured
 * {@link net.sf.eBus.feed.historic.IEMessageStore} instance.
 * Likewise, the historic publish feed also opens and advertises
 * a request feed for
 * {@link net.sf.eBus.feed.historic.HistoricRequest historic request messages}.
 * When an historic request is received, the historic
 * notification feed uses
 * {@code IEMessageStore.retrieve(EInterval)} method to extract
 * the historic notification messages which are sent back via
 * {@link net.sf.eBus.feed.historic.HistoricReply historic reply messages}.
 * <p>
 * Objects needing to use an historic notification feed must
 * implement
 * {@link net.sf.eBus.feed.historic.IEHistoricPublisher IEHistoricPublisher}
 * interface. Unlike an {@code EPublisher} which should not post
 * notification messages when there are no active subscribers,
 * an historic publisher is clear to post notifications on an
 * open, advertised, and up publish status historic feed because
 * of the need to persist messages.
 * </p>
 * <h1>Historic Subscribe Feed</h1>
 * This
 * {@link net.sf.eBus.feed.historic.EHistoricSubscribeFeed feed}
 * retrieve both historic and live notification
 * messages and present them as a single continuous stream back
 * to the
 * {@link net.sf.eBus.feed.historic.IEHistoricSubscriber IEHistoricSubscriber}.
 * These notification messages are ordered by timestamp
 * (millisecond granularity), publisher identifier, and message
 * position. For this reason it is important that historic
 * publishers be assigned a unique identifier and that messages
 * be assigned a unique position (especially if messages are
 * posted at a sub-millisecond rate).
 * <p>
 * Unless the historic subscribe feed is configured to accept
 * notification messages indefinitely, the historic subscriber is
 * informed that the underlying feed has terminated when
 * {@code IEHistoricSubscriber.feedDone()} method is called. Once
 * called, this means that the historic subscriber will no longer
 * receive updates.
 * </p>
 * <p>
 * Another difference between historic and live feeds is that
 * historic subscriber is informed of individual publisher feed
 * status via its
 * {@link net.sf.eBus.feed.historic.IEHistoricSubscriber#feedStatus(net.sf.eBus.feed.historic.PublishStatusEvent, net.sf.eBus.feed.historic.EHistoricSubscribeFeed) feedStatus}
 * method. This allows the historic subscriber to determine if
 * there was or is a break in an individual publisher's stream.
 * The {@code feedStatus()} method is called for both past and
 * live publisher status updates.
 * </p>
 */

package net.sf.eBus.feed.historic;
