//
// Copyright 2019, 2020 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

/**
 * This package contains specialized feeds extending the basic
 * feeds in {@code net.sf.eBus.client}. Currently this package
 * consists only of pattern feeds but there are more planned such
 * as:
 * <ul>
 *   <li>
 *     historical/live feed: the ability to access both
 *     historical and/or live updates across one feed.
 *   </li>
 *   <li>
 *     active/stand-by reply feed: allows two or more
 *     {@link net.sf.eBus.client.EReplier}s for the same message
 *     key to be placed into active and stand-by status. All
 *     repliers will see matching requests but only the active
 *     replier's response is posted back to the requestor. If the
 *     active replier advertisement is lost, the a stand-by
 *     replier takes over as active.
 *   </li>
 *   <li>
 *     replier load balancing: requests are distributed across
 *     multiple repliers based on a configured load balancing
 *     scheme.
 *   </li>
 * </ul>
 * <h1>Pattern Notification Feeds</h1>
 * eBus v. 4.6.0 introduced pattern feeds. A pattern feed
 * monitors one or more
 * {@link net.sf.eBus.client.ESubscribeFeed notification feeds}
 * looking for a series of events which match a user-defined
 * pattern. When a matching event series is found, a
 * {@link net.sf.eBus.feed.pattern.MatchEvent} is posted to the
 * {@link net.sf.eBus.client.ESubscriber subscriber}.
 * {@code MatchEvent} contains all the matching events and
 * user-defined capture groups.
 * <p>
 * There are two pattern types: ordered and unordered. Ordered
 * patterns are a simple event regular expressions. Each
 * construct has the form
 * <code>[<em>one or more event names</em>]{<em>n</em>, <em>m</em>}</code>
 * where the specified events must appear at least <em>n</em>
 * times and at most <em>m</em> times. Events must arrive in
 * exactly the ordered specified by the pattern to make a match.
 * </p>
 * <p>
 * Unordered patterns specify how many of each event type must be
 * received to match the pattern. If a pattern states that
 * between 3 and 5 stock trade events and 1 to 2 stock quote
 * events are needed, then any mix of trade and quote events
 * satisfying these counts matches the pattern.
 * </p>
 * <p>
 * See {@link net.sf.eBus.feed.pattern.EventPattern} and
 * {@link net.sf.eBus.feed.pattern.EPatternFeed} to learn how
 * to create patterns and use pattern feeds.
 * </p>
 */

package net.sf.eBus.feed.pattern;
