/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.sf.eBus.client.ECondition;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.feed.pattern.MatchCondition;
import net.sf.eBus.feed.pattern.MatchEvent;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;

public final class EventPattern {
    public static final String ALL_EVENTS = "__ALL_EVENTS__";
    public static final BiPredicate<List<ENotificationMessage>, ENotificationMessage> DEFAULT_UNTIL = (t, u) -> true;
    public static final int DEFAULT_MATCH_COUNT = 1;
    public static final MatchCondition DEFAULT_PREDICATE = (e, g, u) -> true;
    public static final Predicate<MatchEvent> DEFAULT_CONDITION = t -> true;
    private static final String[] EMPTY_NAMES = new String[0];
    private static final int BEGIN_SINGLE_MASK = 1;
    private static final int END_SINGLE_MASK = 2;
    private static final int BEGIN_MULTI_MASK = 4;
    private static final int END_MULTI_MASK = 8;
    private static final int ADD_MULTI_SINGLE_MASK = 16;
    private static final int UNTIL_MASK = 32;
    private static final int MATCH_COUNT_MASK = 64;
    private static final int CONDITION_MASK = 128;
    private static final int BEGIN_GROUP_MASK = 256;
    private static final int END_GROUP_MASK = 512;
    private static final int BEGIN_PARAM_MAP_MASK = 1024;
    private static final int END_PARAM_MAP_MASK = 2048;
    private static final int BEGIN_PARAMETER_MASK = 4096;
    private static final int END_PARAMETER_MASK = 8192;
    private static final int MESSAGE_KEY_MASK = 16384;
    private static final int SCOPE_MASK = 32768;
    private static final int EXCLUSIVE_MASK = 65536;
    private static final int PREDICATE_MASK = 131072;
    private static final int PATTERN_COND_MASK = 262144;
    private static final int BUILD_MASK = 524288;
    protected final String mPatternName;
    private final PatternType mPatternType;
    private final Map<String, FeedInfo> mParameters;
    private final List<PatternComponent> mComponents;
    private final BiPredicate<List<ENotificationMessage>, ENotificationMessage> mUntil;
    private final boolean mExclusive;
    private final Predicate<MatchEvent> mPatternCondition;

    private EventPattern(Builder builder) {
        this.mPatternName = builder.patternName();
        this.mPatternType = builder.patternType();
        this.mParameters = Collections.unmodifiableMap(builder.parameters());
        this.mComponents = Collections.unmodifiableList(builder.components());
        this.mUntil = builder.until();
        this.mExclusive = builder.exclusive();
        this.mPatternCondition = builder.patternCondition();
    }

    public String patternName() {
        return this.mPatternName;
    }

    public PatternType patternType() {
        return this.mPatternType;
    }

    public Map<String, FeedInfo> parameters() {
        return this.mParameters;
    }

    public boolean isExclusive() {
        return this.mExclusive;
    }

    public FeedInfo feedInfo(String feedName) {
        if (!this.mParameters.containsKey(feedName)) {
            throw new IllegalArgumentException("\"" + feedName + "\" is an unknown feed name");
        }
        return this.mParameters.get(feedName);
    }

    public EMessageKey messageKey(String feedName) {
        return this.feedInfo(feedName).messageKey();
    }

    public static Builder builder(String pName, PatternType pType) {
        if (Objects.requireNonNull(pName, "pName is null").isEmpty()) {
            throw new IllegalArgumentException("pName is empty");
        }
        Objects.requireNonNull(pType, "pType is null");
        return new Builder(pName, pType, new HashMap(), false);
    }

    public static Builder builder(String pName, PatternType pType, Map<String, FeedInfo> parameters) {
        if (Objects.requireNonNull(pName, "pName is null").isEmpty()) {
            throw new IllegalArgumentException("pName is empty");
        }
        Objects.requireNonNull(pType, "pType is null");
        EventPattern.validateParameters(Objects.requireNonNull(parameters, "parameters is null"));
        return new Builder(pName, pType, parameters, true);
    }

    int maximumEvents() {
        int retval = 0;
        retval = this.mComponents.stream().map(pc -> pc.maximumMatchCount()).reduce(retval, Integer::sum);
        return retval;
    }

    int componentCount() {
        return this.mComponents.size();
    }

    List<PatternComponent> components() {
        return this.mComponents;
    }

    Predicate<MatchEvent> patternCondition() {
        return this.mPatternCondition;
    }

    BiPredicate<List<ENotificationMessage>, ENotificationMessage> until() {
        return this.mUntil;
    }

    private static void validateParameters(Map<String, FeedInfo> parameters) {
        if (parameters.isEmpty()) {
            throw new IllegalArgumentException("parameters is empty");
        }
        parameters.entrySet().stream().filter(entry -> entry.getValue() == null).forEachOrdered(entry -> {
            throw new IllegalArgumentException("parameters key " + (String)entry.getKey() + " maps to a null value");
        });
    }

    static final class MultiPatternComponent
    extends PatternComponent {
        private final SinglePatternComponent[] mComponents;

        private MultiPatternComponent(int minCount, int maxCount, String[] groupNames, SinglePatternComponent[] components) {
            super(minCount, maxCount, groupNames);
            this.mComponents = components;
        }

        public SinglePatternComponent[] components() {
            return this.mComponents;
        }
    }

    static final class SinglePatternComponent
    extends PatternComponent {
        private final int mTransitionId;
        private final String mParameter;
        private final MatchCondition mCondition;

        private SinglePatternComponent(int minCount, int maxCount, String[] groupNames, int transId, String parameter, MatchCondition condition) {
            super(minCount, maxCount, groupNames);
            this.mTransitionId = transId;
            this.mParameter = parameter;
            this.mCondition = condition;
        }

        public final int transitionIdentifier() {
            return this.mTransitionId;
        }

        public String parameter() {
            return this.mParameter;
        }

        public MatchCondition condition() {
            return this.mCondition;
        }
    }

    static abstract class PatternComponent {
        protected final int mMinMatchCount;
        protected final int mMaxMatchCount;
        protected final String[] mGroupNames;

        protected PatternComponent(int minCount, int maxCount, String[] groupNames) {
            this.mMinMatchCount = minCount;
            this.mMaxMatchCount = maxCount;
            this.mGroupNames = groupNames;
        }

        public final int minimumMatchCount() {
            return this.mMinMatchCount;
        }

        public final int maximumMatchCount() {
            return this.mMaxMatchCount;
        }

        public final String[] groupNames() {
            return this.mGroupNames;
        }
    }

    public static final class Builder {
        private final String mPatternName;
        private final PatternType mPatternType;
        private final Map<String, FeedInfo> mParameters;
        private final List<PatternComponent> mComponents;
        private final Deque<String> mActiveGroups;
        private final Set<String> mGroupNames;
        private BiPredicate<List<ENotificationMessage>, ENotificationMessage> mUntil;
        private boolean mExclusive;
        private PatternState mState;
        private String mParamName;
        private EMessageKey mEventKey;
        private EFeed.FeedScope mScope;
        private ECondition mSubCondition;
        private int mMinMatchCount;
        private int mMaxMatchCount;
        private Predicate<MatchEvent> mPatternCondition;
        private MatchCondition mMatchCondition;
        private final List<SinglePatternComponent> mSubComponents;

        private Builder(String patternName, PatternType pType, Map<String, FeedInfo> parameters, boolean parmsDefined) {
            this.mPatternName = patternName;
            this.mPatternType = pType;
            this.mComponents = new ArrayList<PatternComponent>();
            this.mParameters = parameters;
            this.mActiveGroups = new LinkedList<String>();
            this.mGroupNames = new TreeSet<String>();
            this.mSubComponents = new ArrayList<SinglePatternComponent>();
            this.mActiveGroups.addFirst(EventPattern.ALL_EVENTS);
            this.mGroupNames.add(EventPattern.ALL_EVENTS);
            this.mUntil = DEFAULT_UNTIL;
            this.mExclusive = false;
            this.mPatternCondition = DEFAULT_CONDITION;
            if (!parmsDefined) {
                this.mState = PatternState.NO_PARAMS;
            } else {
                this.mState = pType == PatternType.ORDERED ? PatternState.IN_ORDERED_PATTERN : PatternState.IN_UNORDERED_PATTERN;
                Builder.assignTransitionIds(parameters);
            }
        }

        private String patternName() {
            return this.mPatternName;
        }

        private PatternType patternType() {
            return this.mPatternType;
        }

        private Map<String, FeedInfo> parameters() {
            return this.mParameters;
        }

        private List<PatternComponent> components() {
            return this.mComponents;
        }

        private BiPredicate<List<ENotificationMessage>, ENotificationMessage> until() {
            return this.mUntil;
        }

        private boolean exclusive() {
            return this.mExclusive;
        }

        private Predicate<MatchEvent> patternCondition() {
            return this.mPatternCondition;
        }

        public Builder beginParameterMap() {
            if (!this.mState.supportsMethod(1024)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support beginParameterMap");
            }
            this.mState = PatternState.IN_PARAMS;
            return this;
        }

        public Builder endParameterMap() {
            if (!this.mState.supportsMethod(2048)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support endParameterMap");
            }
            if (this.mParameters.isEmpty()) {
                throw new IllegalStateException("no parameters defined");
            }
            this.mState = this.mPatternType == PatternType.ORDERED ? PatternState.IN_ORDERED_PATTERN : PatternState.IN_UNORDERED_PATTERN;
            Builder.assignTransitionIds(this.mParameters);
            return this;
        }

        public Builder beginParameter(String name) {
            if (!this.mState.supportsMethod(4096)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support beginParameter");
            }
            if (name == null) {
                throw new NullPointerException("parameter name is null");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("parameter name is empty");
            }
            if (this.mParameters.containsKey(name)) {
                throw new IllegalStateException("\"" + name + "\" already defined");
            }
            this.mParamName = name;
            this.mState = PatternState.IN_PARAMETER;
            return this;
        }

        public Builder endParameter() {
            if (!this.mState.supportsMethod(8192)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support endParameter");
            }
            if (this.mEventKey == null) {
                throw new IllegalStateException("event message key missing");
            }
            if (this.mScope == null) {
                throw new IllegalStateException("feed scope missing");
            }
            this.mParameters.put(this.mParamName, new FeedInfo(this.mEventKey, this.mScope, this.mSubCondition));
            this.mParamName = null;
            this.mEventKey = null;
            this.mScope = null;
            this.mSubCondition = null;
            this.mState = PatternState.IN_PARAMS;
            return this;
        }

        public Builder messageKey(EMessageKey key) {
            if (!this.mState.supportsMethod(16384)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support messageKey");
            }
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            if (!key.isNotification()) {
                throw new IllegalArgumentException(key + " is not a notification key");
            }
            if (this.mEventKey != null) {
                throw new IllegalStateException("notification key already defined");
            }
            this.mEventKey = key;
            return this;
        }

        public Builder scope(EFeed.FeedScope scope) {
            if (!this.mState.supportsMethod(32768)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support scope");
            }
            if (scope == null) {
                throw new NullPointerException("scope is null");
            }
            if (this.mScope != null) {
                throw new IllegalStateException("scope already defined");
            }
            this.mScope = scope;
            return this;
        }

        public Builder condition(ECondition condition) {
            if (!this.mState.supportsMethod(128)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support condition");
            }
            if (this.mSubCondition != null) {
                throw new IllegalStateException("condition already defined");
            }
            this.mSubCondition = condition;
            return this;
        }

        public Builder beginSingleComponent(String paramName) {
            if (!this.mState.supportsMethod(1)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support beginSingleComponent");
            }
            this.validateParamName(paramName);
            this.mParamName = paramName;
            this.mState = PatternState.IN_SINGLE;
            this.mMinMatchCount = 1;
            this.mMaxMatchCount = 1;
            this.mMatchCondition = DEFAULT_PREDICATE;
            return this;
        }

        public Builder endSingleComponent() {
            if (!this.mState.supportsMethod(2)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support endSingleComponent");
            }
            String[] groupNames = this.mActiveGroups.toArray(EMPTY_NAMES);
            FeedInfo fInfo = this.validateParamName(this.mParamName);
            this.mComponents.add(new SinglePatternComponent(this.mMinMatchCount, this.mMaxMatchCount, groupNames, fInfo.transitionId(), this.mParamName, this.mMatchCondition));
            this.mMinMatchCount = 1;
            this.mMaxMatchCount = 1;
            this.mMatchCondition = DEFAULT_PREDICATE;
            this.mState = this.mPatternType == PatternType.ORDERED ? PatternState.IN_ORDERED_PATTERN : PatternState.IN_UNORDERED_PATTERN;
            return this;
        }

        public Builder beginMultiComponent() {
            if (!this.mState.supportsMethod(4)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support beginMultiComponent");
            }
            this.mState = PatternState.IN_MULTI;
            return this;
        }

        public Builder endMultiComponent() {
            if (!this.mState.supportsMethod(8)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support endMultiComponent");
            }
            if (this.mSubComponents.isEmpty()) {
                throw new IllegalStateException("no subcomponents defined for multi-component");
            }
            String[] groupNames = this.mActiveGroups.toArray(new String[0]);
            SinglePatternComponent[] components = this.mSubComponents.toArray(new SinglePatternComponent[0]);
            this.mComponents.add(new MultiPatternComponent(this.mMinMatchCount, this.mMaxMatchCount, groupNames, components));
            this.mMinMatchCount = 1;
            this.mMaxMatchCount = 1;
            this.mSubComponents.clear();
            this.mState = PatternState.IN_ORDERED_PATTERN;
            return this;
        }

        public Builder beginGroup(String groupName) {
            if (!this.mState.supportsMethod(256)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support beginGroup");
            }
            this.validateGroupName(groupName);
            if (this.mGroupNames.contains(groupName)) {
                throw new IllegalArgumentException(groupName + " is not unique");
            }
            this.mActiveGroups.addFirst(groupName);
            this.mGroupNames.add(groupName);
            return this;
        }

        public Builder endGroup(String groupName) {
            if (!this.mState.supportsMethod(512)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support endGroup");
            }
            if (!this.mGroupNames.contains(groupName)) {
                throw new IllegalArgumentException("\"" + groupName + "\" is not known");
            }
            if (EventPattern.ALL_EVENTS.equals(groupName)) {
                throw new IllegalArgumentException("cannot end __ALL_EVENTS__ group");
            }
            if (!groupName.equals(this.mActiveGroups.peekFirst())) {
                throw new IllegalStateException(groupName + " not most recently opened group");
            }
            this.mActiveGroups.removeFirst();
            return this;
        }

        public Builder matchCount(int minMax) {
            return this.matchCount(minMax, minMax);
        }

        public Builder matchCount(int min, int max) {
            if (!this.mState.supportsMethod(64)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support matchCount");
            }
            if (min < 0) {
                throw new IllegalArgumentException("min (" + min + ") < zero");
            }
            if (max < min) {
                throw new IllegalArgumentException("min (" + min + ") > max (" + max + ")");
            }
            this.mMinMatchCount = min;
            this.mMaxMatchCount = max;
            return this;
        }

        public Builder matchCondition(MatchCondition p) {
            if (!this.mState.supportsMethod(131072)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support matchCondition");
            }
            this.mMatchCondition = p == null ? DEFAULT_PREDICATE : p;
            return this;
        }

        public Builder addSubordinate(String paramName) {
            return this.addSubordinate(paramName, DEFAULT_PREDICATE);
        }

        public Builder addSubordinate(String paramName, MatchCondition predicate) {
            if (!this.mState.supportsMethod(16)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support addSubordinate");
            }
            FeedInfo fInfo = this.validateParamName(paramName);
            this.mSubComponents.add(new SinglePatternComponent(1, 1, EMPTY_NAMES, fInfo.transitionId(), paramName, predicate == null ? DEFAULT_PREDICATE : predicate));
            return this;
        }

        public Builder until(BiPredicate<List<ENotificationMessage>, ENotificationMessage> p) {
            if (!this.mState.supportsMethod(32)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support until");
            }
            if (p == null) {
                throw new NullPointerException("duration is null");
            }
            this.mUntil = p;
            return this;
        }

        public Builder isExclusive(boolean flag) {
            if (!this.mState.supportsMethod(65536)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support isExclusive");
            }
            this.mExclusive = flag;
            return this;
        }

        public Builder patternCondition(Predicate<MatchEvent> p) {
            if (!this.mState.supportsMethod(262144)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support patternCondition");
            }
            this.mPatternCondition = p == null ? DEFAULT_CONDITION : p;
            return this;
        }

        public EventPattern build() {
            if (!this.mState.supportsMethod(524288)) {
                throw new IllegalStateException("state " + (Object)((Object)this.mState) + " does not support build");
            }
            this.mState = PatternState.OUT_PATTERN;
            return new EventPattern(this);
        }

        private void validateGroupName(String groupName) {
            if (groupName == null) {
                throw new NullPointerException("groupName is null");
            }
            if (groupName.isEmpty()) {
                throw new IllegalArgumentException("groupName is empty");
            }
        }

        private FeedInfo validateParamName(String paramName) {
            if (paramName == null) {
                throw new NullPointerException("paramName is null");
            }
            if (paramName.isEmpty()) {
                throw new IllegalArgumentException("paramName is empty");
            }
            if (!this.mParameters.containsKey(paramName)) {
                throw new IllegalArgumentException("\"" + paramName + "\" is not a known parameter");
            }
            return this.mParameters.get(paramName);
        }

        private static void assignTransitionIds(Map<String, FeedInfo> parameters) {
            int tId = 0;
            for (FeedInfo fInfo : parameters.values()) {
                fInfo.transitionId(tId);
                ++tId;
            }
        }
    }

    public static final class FeedInfo {
        private int mTransitionId;
        private final EMessageKey mKey;
        private final EFeed.FeedScope mScope;
        private final ECondition mCondition;

        public FeedInfo(EMessageKey key, EFeed.FeedScope scope) {
            this(key, scope, EFeed.NO_CONDITION);
        }

        public FeedInfo(EMessageKey key, EFeed.FeedScope scope, ECondition condition) {
            this.mKey = Objects.requireNonNull(key, "null message key");
            this.mScope = Objects.requireNonNull(scope, "null feed scope");
            this.mCondition = condition;
            if (!key.isNotification()) {
                throw new IllegalArgumentException(key + " not a notification message key");
            }
        }

        public EMessageKey messageKey() {
            return this.mKey;
        }

        public EFeed.FeedScope scope() {
            return this.mScope;
        }

        public ECondition condition() {
            return this.mCondition;
        }

        int transitionId() {
            return this.mTransitionId;
        }

        FeedInfo transitionId(int id) {
            this.mTransitionId = id;
            return this;
        }
    }

    private static enum PatternState {
        NO_PARAMS(1024),
        IN_PARAMS(6144),
        IN_PARAMETER(57472),
        IN_ORDERED_PATTERN(852773),
        IN_UNORDERED_PATTERN(852001),
        IN_SINGLE(131138),
        IN_MULTI(88),
        OUT_PATTERN(0);

        private final int mFieldMask;

        private PatternState(int mask) {
            this.mFieldMask = mask;
        }

        public int fieldMask() {
            return this.mFieldMask;
        }

        public boolean supportsMethod(int methodMask) {
            return (this.mFieldMask & methodMask) != 0;
        }
    }

    public static enum PatternType {
        ORDERED,
        UNORDERED;

    }
}

