/*
 * ex: set ro:
 * DO NOT EDIT.
 * generated by smc (http://smc.sourceforge.net/)
 * from file : TestPublisher.sm.sm
 */


//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2009 - 2011, 2015. Charles W. Rapp.
// All Rights Reserved.
//


package net.sf.eBus.feed.pattern;

import net.sf.eBus.client.EFeedState;
import net.sf.eBus.messages.ENotificationMessage;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.invoke.MethodType;
import statemap.FSMContext7;
import statemap.State7;
import statemap.TransitionHandle;

public class TestPublisherContext
    extends FSMContext7
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    public TestPublisherContext(final TestPublisher owner)
    {
        this (owner, sStates[ErrorStartFeed_TestStart_STATE_ID]);
    }

    public TestPublisherContext(final TestPublisher owner, final int initStateId)
    {
        this (owner, sStates[initStateId]);    }

    public TestPublisherContext(final TestPublisher owner, final State7 initState)
    {
        super (initState);

        ctxt = owner;
    }

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FSMContext7 Abstract Method Override.
    //

    @Override
    protected void executeAction(final MethodHandle mh)
    {
        try
        {
            mh.invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (mDebugFlag)
            {
                tex.printStackTrace(mDebugStream);
            }
        }

        return;
    }

    //
    // end of FSMContext7 Abstract Method Override.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Transitions.
    //

    public void publish(final ENotificationMessage msg)
    {
        mTransition = "publish";
        try
        {
            final TransitionHandle th =
                getState().transition(publish5_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (mDebugFlag)
            {
                tex.printStackTrace(mDebugStream);
            }
        }
        mTransition = "";
        return;
    }

    public void startFeed()
    {
        mTransition = "startFeed";
        try
        {
            final TransitionHandle th =
                getState().transition(startFeed3_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (mDebugFlag)
            {
                tex.printStackTrace(mDebugStream);
            }
        }
        mTransition = "";
        return;
    }

    public void stopFeed()
    {
        mTransition = "stopFeed";
        try
        {
            final TransitionHandle th =
                getState().transition(stopFeed1_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (mDebugFlag)
            {
                tex.printStackTrace(mDebugStream);
            }
        }
        mTransition = "";
        return;
    }

    public void testError()
    {
        mTransition = "testError";
        try
        {
            final TransitionHandle th =
                getState().transition(testError4_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (mDebugFlag)
            {
                tex.printStackTrace(mDebugStream);
            }
        }
        mTransition = "";
        return;
    }

    //
    // end of Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoTest.TestDone State Entry/Exit Actions.
    //

    private void NoTest_TestDone__Entry_()
    {
        ctxt.unadvertise();
        ctxt.signalDone();
    }

    //
    // end of NoTest.TestDone State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoTest.TestDone State Transitions.
    //

    private void NoTest_TestDone_Default()
    {
        final int stateId = mState.getId();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(sStates[stateId]);
        }



        return;
    }


    private void NoTest_TestDone_stopFeed()
    {
        final int stateId = mState.getId();



        return;
    }


    //
    // end of NoTest.TestDone State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NullKey.TestStart State Entry/Exit Actions.
    //

    private void NullKey_TestStart__Entry_()
    {
        ctxt.advertise();
    }

    //
    // end of NullKey.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NullKey.TestStart State Transitions.
    //

    private void NullKey_TestStart_Default()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of NullKey.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ErrorStartFeed.Default State Transitions.
    //

    private void ErrorStartFeed_Default_testError()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    private void ErrorStartFeed_Default_Default()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of ErrorStartFeed.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ErrorStartFeed.TestStart State Entry/Exit Actions.
    //

    private void ErrorStartFeed_TestStart__Entry_()
    {
        ctxt.advertise();
    }

    //
    // end of ErrorStartFeed.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ErrorStartFeed.TestStart State Transitions.
    //

    private void ErrorStartFeed_TestStart_Default()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    private void ErrorStartFeed_TestStart_startFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.sendFeedStatus(EFeedState.DOWN);
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    private void ErrorStartFeed_TestStart_stopFeed()
    {
        final int stateId = mState.getId();



        return;
    }


    private void ErrorStartFeed_TestStart_testError()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of ErrorStartFeed.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // PublishMap.Default State Transitions.
    //

    private void PublishMap_Default_testError()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    private void PublishMap_Default_stopFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    private void PublishMap_Default_Default()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of PublishMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // PublishMap.TestStart State Entry/Exit Actions.
    //

    private void PublishMap_TestStart__Entry_()
    {
        ctxt.advertise();
    }

    //
    // end of PublishMap.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // PublishMap.TestStart State Transitions.
    //

    private void PublishMap_TestStart_startFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.sendFeedStatus(EFeedState.UP);
        }
        finally
        {
            setState(sStates[PublishMap_FeedUp_STATE_ID]);
        }

        enterState();


        return;
    }


    private void PublishMap_TestStart_stopFeed()
    {
        final int stateId = mState.getId();



        return;
    }


    //
    // end of PublishMap.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // PublishMap.FeedUp State Entry/Exit Actions.
    //

    private void PublishMap_FeedUp__Entry_()
    {
        ctxt.startTimer();
    }

    private void PublishMap_FeedUp__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of PublishMap.FeedUp State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // PublishMap.FeedUp State Transitions.
    //

    private void PublishMap_FeedUp_publish(final ENotificationMessage msg)
    {
        final int stateId = mState.getId();

        if (ctxt.sentCount() >= ctxt.sendCount())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(sStates[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
                clearState();
                ctxt.send(msg);
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }

        return;
    }


    private void PublishMap_FeedUp_stopFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[PublishMap_FeedDown_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of PublishMap.FeedUp State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // PublishMap.FeedDown State Transitions.
    //

    private void PublishMap_FeedDown_publish(final ENotificationMessage msg)
    {
        final int stateId = mState.getId();



        return;
    }


    private void PublishMap_FeedDown_startFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.sendFeedStatus(EFeedState.DOWN);
        }
        finally
        {
            setState(sStates[PublishMap_FeedUp_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of PublishMap.FeedDown State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // StopFeedMap.Default State Transitions.
    //

    private void StopFeedMap_Default_testError()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    private void StopFeedMap_Default_Default()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of StopFeedMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // StopFeedMap.TestStart State Entry/Exit Actions.
    //

    private void StopFeedMap_TestStart__Entry_()
    {
        ctxt.advertise();
    }

    //
    // end of StopFeedMap.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // StopFeedMap.TestStart State Transitions.
    //

    private void StopFeedMap_TestStart_startFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.sendFeedStatus(EFeedState.UP);
        }
        finally
        {
            setState(sStates[StopFeedMap_FeedUp_STATE_ID]);
        }

        enterState();


        return;
    }


    private void StopFeedMap_TestStart_stopFeed()
    {
        final int stateId = mState.getId();



        return;
    }


    //
    // end of StopFeedMap.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // StopFeedMap.FeedUp State Entry/Exit Actions.
    //

    private void StopFeedMap_FeedUp__Entry_()
    {
        ctxt.startTimer();
    }

    private void StopFeedMap_FeedUp__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of StopFeedMap.FeedUp State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // StopFeedMap.FeedUp State Transitions.
    //

    private void StopFeedMap_FeedUp_publish(final ENotificationMessage msg)
    {
        final int stateId = mState.getId();

        try
        {
            clearState();
            ctxt.send(msg);
        }
        finally
        {
            setState(sStates[stateId]);
        }



        return;
    }


    private void StopFeedMap_FeedUp_stopFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of StopFeedMap.FeedUp State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.Default State Transitions.
    //

    private void UpAndDown_Default_testError()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    private void UpAndDown_Default_Default()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of UpAndDown.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.TestStart State Entry/Exit Actions.
    //

    private void UpAndDown_TestStart__Entry_()
    {
        ctxt.advertise();
    }

    //
    // end of UpAndDown.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.TestStart State Transitions.
    //

    private void UpAndDown_TestStart_startFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.sendFeedStatus(EFeedState.UP);
        }
        finally
        {
            setState(sStates[UpAndDown_FeedUp_STATE_ID]);
        }

        enterState();


        return;
    }


    private void UpAndDown_TestStart_stopFeed()
    {
        final int stateId = mState.getId();



        return;
    }


    //
    // end of UpAndDown.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.FeedUp State Entry/Exit Actions.
    //

    private void UpAndDown_FeedUp__Entry_()
    {
        ctxt.startTimer();
    }

    //
    // end of UpAndDown.FeedUp State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.FeedUp State Transitions.
    //

    private void UpAndDown_FeedUp_publish(final ENotificationMessage msg)
    {
        final int stateId = mState.getId();

        if (ctxt.sentCount() >= ctxt.sendCount())
        {
            exitState();

            try
            {
                clearState();
                ctxt.stopTimer();
            }
            finally
            {
                setState(sStates[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else if (ctxt.sentCount() == (ctxt.sendCount() / 2))
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(msg);
            }
            finally
            {
                setState(sStates[UpAndDown_PauseFeed_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
                clearState();
                ctxt.send(msg);
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }

        return;
    }


    private void UpAndDown_FeedUp_stopFeed()
    {
        final int stateId = mState.getId();



        return;
    }


    //
    // end of UpAndDown.FeedUp State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.PauseFeed State Entry/Exit Actions.
    //

    private void UpAndDown_PauseFeed__Entry_()
    {
        ctxt.sendFeedStatus(EFeedState.DOWN);
        ctxt.unadvertise();
    }

    private void UpAndDown_PauseFeed__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of UpAndDown.PauseFeed State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.PauseFeed State Transitions.
    //

    private void UpAndDown_PauseFeed_publish(final ENotificationMessage msg)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[UpAndDown_TestStart_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of UpAndDown.PauseFeed State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // AlwaysPublish.Default State Transitions.
    //

    private void AlwaysPublish_Default_testError()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    private void AlwaysPublish_Default_Default()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of AlwaysPublish.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // AlwaysPublish.TestStart State Entry/Exit Actions.
    //

    private void AlwaysPublish_TestStart__Entry_()
    {
        ctxt.advertise();
        ctxt.startTimer();
    }

    //
    // end of AlwaysPublish.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // AlwaysPublish.TestStart State Transitions.
    //

    private void AlwaysPublish_TestStart_publish(final ENotificationMessage msg)
    {
        final int stateId = mState.getId();



        return;
    }


    private void AlwaysPublish_TestStart_startFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.sendFeedStatus(EFeedState.UP);
        }
        finally
        {
            setState(sStates[AlwaysPublish_FeedUp_STATE_ID]);
        }

        enterState();


        return;
    }


    private void AlwaysPublish_TestStart_stopFeed()
    {
        final int stateId = mState.getId();



        return;
    }


    //
    // end of AlwaysPublish.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // AlwaysPublish.FeedUp State Entry/Exit Actions.
    //

    private void AlwaysPublish_FeedUp__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of AlwaysPublish.FeedUp State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // AlwaysPublish.FeedUp State Transitions.
    //

    private void AlwaysPublish_FeedUp_publish(final ENotificationMessage msg)
    {
        final int stateId = mState.getId();

        try
        {
            clearState();
            ctxt.send(msg);
        }
        finally
        {
            setState(sStates[stateId]);
        }



        return;
    }


    private void AlwaysPublish_FeedUp_stopFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of AlwaysPublish.FeedUp State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Readvertise.Default State Transitions.
    //

    private void Readvertise_Default_testError()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    private void Readvertise_Default_Default()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    //
    // end of Readvertise.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Readvertise.TestStart State Entry/Exit Actions.
    //

    private void Readvertise_TestStart__Entry_()
    {
        ctxt.advertise();
    }

    //
    // end of Readvertise.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Readvertise.TestStart State Transitions.
    //

    private void Readvertise_TestStart_startFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[Readvertise_FeedUp_STATE_ID]);
        }

        enterState();


        return;
    }


    private void Readvertise_TestStart_stopFeed()
    {
        final int stateId = mState.getId();



        return;
    }


    //
    // end of Readvertise.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Readvertise.FeedUp State Entry/Exit Actions.
    //

    private void Readvertise_FeedUp__Entry_()
    {
        ctxt.unadvertise();
        ctxt.advertise();
    }

    //
    // end of Readvertise.FeedUp State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Readvertise.FeedUp State Transitions.
    //

    private void Readvertise_FeedUp_startFeed()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(sStates[NoTest_TestDone_STATE_ID]);
        }

        enterState();


        return;
    }


    private void Readvertise_FeedUp_stopFeed()
    {
        final int stateId = mState.getId();



        return;
    }


    //
    // end of Readvertise.FeedUp State Transitions.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    transient private TestPublisher ctxt;

    //-----------------------------------------------------------
    // Constants.
    //

    private static final long serialVersionUID = 1L;

    public static final int NoTest_TestDone_STATE_ID = 0;

    public static final int NullKey_TestStart_STATE_ID = 1;

    public static final int ErrorStartFeed_TestStart_STATE_ID = 2;

    public static final int PublishMap_TestStart_STATE_ID = 3;
    public static final int PublishMap_FeedUp_STATE_ID = 4;
    public static final int PublishMap_FeedDown_STATE_ID = 5;

    public static final int StopFeedMap_TestStart_STATE_ID = 6;
    public static final int StopFeedMap_FeedUp_STATE_ID = 7;

    public static final int UpAndDown_TestStart_STATE_ID = 8;
    public static final int UpAndDown_FeedUp_STATE_ID = 9;
    public static final int UpAndDown_PauseFeed_STATE_ID = 10;

    public static final int AlwaysPublish_TestStart_STATE_ID = 11;
    public static final int AlwaysPublish_FeedUp_STATE_ID = 12;

    public static final int Readvertise_TestStart_STATE_ID = 13;
    public static final int Readvertise_FeedUp_STATE_ID = 14;

    private static final int STATE_COUNT = 15;

    private static final int publish5_TRANSITION_ID = 1;
    private static final int startFeed3_TRANSITION_ID = 2;
    private static final int stopFeed1_TRANSITION_ID = 3;
    private static final int testError4_TRANSITION_ID = 4;

    private static final int TRANSITION_COUNT = 5;

    private static final MethodType[] TRANSITION_TYPES =
    {
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, ENotificationMessage.class),
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        NO_ARGS_TYPE
    };

    private static final String[] MAP_NAMES =
    {
        "NoTest",
        "NullKey",
        "ErrorStartFeed",
        "PublishMap",
        "StopFeedMap",
        "UpAndDown",
        "AlwaysPublish",
        "Readvertise"
    };

    private static final String[][] STATE_NAMES =
    {
        new String[]
        {
            "TestDone"
        },

        new String[]
        {
            "TestStart"
        },

        new String[]
        {
            "TestStart"
        },

        new String[]
        {
            "TestStart",
            "FeedUp",
            "FeedDown"
        },

        new String[]
        {
            "TestStart",
            "FeedUp"
        },

        new String[]
        {
            "TestStart",
            "FeedUp",
            "PauseFeed"
        },

        new String[]
        {
            "TestStart",
            "FeedUp"
        },

        new String[]
        {
            "TestStart",
            "FeedUp"
        }
    };

    private static String[][] STATE_TRANSITIONS =
    {
        new String[]
        {
            "Default",
            "stopFeed"
        },

        new String[]
        {
            "Default"
        },

        new String[]
        {
            "Default",
            "startFeed",
            "stopFeed",
            "testError"
        },

        new String[]
        {
            "startFeed",
            "stopFeed"
        },

        new String[]
        {
            "publish",
            "stopFeed"
        },

        new String[]
        {
            "publish",
            "startFeed"
        },

        new String[]
        {
            "startFeed",
            "stopFeed"
        },

        new String[]
        {
            "publish",
            "stopFeed"
        },

        new String[]
        {
            "startFeed",
            "stopFeed"
        },

        new String[]
        {
            "publish",
            "stopFeed"
        },

        new String[]
        {
            "publish"
        },

        new String[]
        {
            "publish",
            "startFeed",
            "stopFeed"
        },

        new String[]
        {
            "publish",
            "stopFeed"
        },

        new String[]
        {
            "startFeed",
            "stopFeed"
        },

        new String[]
        {
            "startFeed",
            "stopFeed"
        }
    };

    private static final String[] TRANSITION_NAMES =
    {
        "Default",
        "publish",
        "startFeed",
        "stopFeed",
        "testError"
    };

    private static final State7[] sStates = new State7[STATE_COUNT];

    static
    {
        final Lookup lookup = MethodHandles.lookup();
        final Class<?> clazz = TestPublisherContext.class;
        final int mapSize = MAP_NAMES.length;
        int stateSize;
        int mapIndex;
        int stateIndex;
        int transIndex;
        int stateId = 0;
        String mapName;
        String stateName;
        String transName;
        String methodName;
        MethodType transType;
        MethodHandle entryHandle;
        MethodHandle exitHandle;
        TransitionHandle[] transitions;

        for (mapIndex = 0; mapIndex < mapSize; ++mapIndex)
        {
            mapName = MAP_NAMES[mapIndex];
            stateSize = STATE_NAMES[mapIndex].length;

            for (stateIndex = 0; stateIndex < stateSize; ++stateIndex, ++stateId)
            {
                stateName = STATE_NAMES[mapIndex][stateIndex];
                transitions = new TransitionHandle[TRANSITION_COUNT];

                methodName = String.format(ENTRY_NAME, mapName, stateName);
                entryHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);
                methodName = String.format(EXIT_NAME, mapName, stateName);
                exitHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);

                for (transIndex = 1; transIndex < TRANSITION_COUNT; ++transIndex)
                {
                    transName = TRANSITION_NAMES[transIndex];
                    transType = TRANSITION_TYPES[transIndex];
                    transitions[transIndex] =
                        lookupTransition(lookup, clazz, mapName, stateName, transName, transType);
                }

                sStates[stateId] =
                    new State7(
                        String.format(STATE_NAME_FORMAT, mapName, stateName),
                        stateId,
                        entryHandle,
                        exitHandle,
                        transitions,
                        STATE_TRANSITIONS[stateId]);
            }
        }
    }
}

/*
 * Local variables:
 *  buffer-read-only: t
 * End:
 */
