//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2019. Charles W. Rapp
// All Rights Reserved.
//

/**
 * This package contains specialized feeds extending the basic
 * feeds in {@code net.sf.eBus.client}. Currently this package
 * consists only of pattern feeds but there are more planned such
 * as:
 * <ul>
 *   <li>
 *     historical/live feed: the ability to access both
 *     historical and/or live updates across one feed.
 *   </li>
 *   <li>
 *     active/stand-by reply feed: allows two or more
 *     {@link net.sf.eBus.client.EReplier}s for the same message
 *     key to be placed into active and stand-by status. All
 *     repliers will see matching requests but only the active
 *     replier's response is posted back to the requestor. If the
 *     active replier advertisement is lost, the a stand-by
 *     replier takes over as active.
 *   </li>
 *   <li>
 *     replier load balancing: requests are distributed across
 *     multiple repliers based on a configured load balancing
 *     scheme.
 *   </li>
 * </ul>
 * <h1>Pattern Feeds</h1>
 * eBus v. 4.6.0 introduced pattern feeds. A pattern feed
 * monitors one or more
 * {@link net.sf.eBus.client.ESubscribeFeed notification feeds}
 * looking for a series of events which match a user-defined
 * pattern. When a matching event series is found, a
 * {@link MatchEvent} is posted to the
 * {@link net.sf.eBus.client.ESubscriber subscriber}.
 * {@code MatchEvent} contains all the matching events and
 * user-defined capture groups.
 * <p>
 * There are two pattern types: ordered and unordered. Ordered
 * patterns are a simple event regular expressions. Each
 * construct has the form
 * <code>[<em>one or more event names</em>]{<em>n</em>, <em>m</em>}</code>
 * where the specified events must appear at least <em>n</em>
 * times and at most <em>m</em> times. Events must arrive in
 * exactly the ordered specified by the pattern to make a match.
 * </p>
 * <p>
 * Unordered patterns specify how many of each event type must be
 * received to match the pattern. If a pattern states that
 * between 3 and 5 stock trade events and 1 to 2 stock quote
 * events are needed, then any mix of trade and quote events
 * satisfying these counts matches the pattern.
 * </p>
 * <p>
 * See {@link EventPattern} and {@link EPatternFeed} to learn how
 * to create patterns and use pattern feeds.
 * </p>
 */

package net.sf.eBus.feed;
