/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed;

import java.io.Serializable;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.eBus.messages.ELocalOnly;
import net.sf.eBus.messages.EMessageObject;
import net.sf.eBus.messages.ENotificationMessage;

@ELocalOnly
public final class MatchEvent
extends ENotificationMessage
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final Map<String, List<ENotificationMessage>> groups;
    public final Map<Object, Object> userCache;

    private MatchEvent(Builder builder) {
        super((ENotificationMessage.Builder)builder);
        this.groups = builder.mGroups;
        this.userCache = builder.mUserCache;
    }

    public String toString() {
        Formatter retval = new Formatter();
        retval.format("%s", super.toString());
        retval.format("%n  Capturing groups:", new Object[0]);
        for (Map.Entry<String, List<ENotificationMessage>> entry2 : this.groups.entrySet()) {
            retval.format("%n  group[%s]", entry2.getKey());
            int ei = 0;
            for (ENotificationMessage msg : entry2.getValue()) {
                retval.format("%n    event[%2d]%n%s", ei, msg);
                ++ei;
            }
        }
        retval.format("%n%n  User-defined data:", new Object[0]);
        this.userCache.entrySet().forEach(entry -> retval.format("%n    %s=%s", entry.getKey(), entry.getValue()));
        return retval.toString();
    }

    public List<ENotificationMessage> group(String name) {
        return this.groups.get(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ENotificationMessage.Builder<MatchEvent, Builder> {
        private Map<String, List<ENotificationMessage>> mGroups;
        private Map<Object, Object> mUserCache;

        private Builder() {
            super(MatchEvent.class);
        }

        protected MatchEvent buildImpl() {
            return new MatchEvent(this);
        }

        protected EMessageObject.Validator validate(EMessageObject.Validator problems) {
            return super.validate(problems).requireNotNull(this.mGroups, "groups").requireNotNull(this.mUserCache, "userCache");
        }

        public Builder groups(Map<String, List<ENotificationMessage>> groups) {
            this.mGroups = Objects.requireNonNull(groups, "groups is null");
            return this;
        }

        public Builder userCache(Map<Object, Object> userCache) {
            this.mUserCache = Objects.requireNonNull(userCache, "user cache is null");
            return this;
        }
    }
}

