//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2018. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.feed;

import java.util.List;
import java.util.Map;
import net.sf.eBus.messages.ENotificationMessage;

/**
 * Implement this method to test if the latest event matches the
 * pattern. This allows for tests beyond simply matching the
 * pattern.
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@FunctionalInterface
public interface MatchCondition
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * Returns {@code true} if {@code event} satisfies this
     * condition, allowing the event pattern matching to continue
     * or complete. If {@code event} does not meet the pattern
     * condition, then the current match is abandoned.
     * <p>
     * Two further pieces of information are provided to help
     * with the test: the
     * <a href="CapturingGroups">capturing groups</a> and the
     * <a href="UserCache">user-defined data cache</a>
     * (which see for more information).
     * </p>
     * <p>
     * <strong>Note:</strong> if this method should throw any
     * exception that is treated as a test failure and the
     * current match is abandoned.
     * </p>
     * @param event test if this event matches the pattern.
     * @param groups the capturing groups so far.
     * @param userCache map containing user data.
     * @return {@code true} if {@code event} satisfies the match
     * condition.
     */
    boolean test(ENotificationMessage event,
                 Map<String, List<ENotificationMessage>> groups,
                 Map<Object, Object> userCache);
} // end of interface MatchCondition

