/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed;

import java.io.Serializable;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import net.sf.eBus.messages.EFieldInfo;
import net.sf.eBus.messages.ENotificationMessage;

@EFieldInfo(fields={})
public final class MatchEvent
extends ENotificationMessage
implements Serializable {
    private static final long serialVersionUID = 263680L;
    public final Map<String, List<ENotificationMessage>> groups;
    public final Map<Object, Object> userCache;

    public MatchEvent(String subject, Map<String, List<ENotificationMessage>> groups, Map<Object, Object> userCache) {
        this(subject, System.currentTimeMillis(), groups, userCache);
    }

    public MatchEvent(String subject, long timestamp) {
        this(subject, timestamp, Collections.emptyMap(), Collections.emptyMap());
    }

    public MatchEvent(String subject, long timestamp, Map<String, List<ENotificationMessage>> groups, Map<Object, Object> userCache) {
        super(subject, timestamp);
        this.groups = groups;
        this.userCache = userCache;
    }

    public String toString() {
        Formatter retval = new Formatter();
        retval.format("%s", super.toString());
        retval.format("%n  Capturing groups:", new Object[0]);
        for (Map.Entry<String, List<ENotificationMessage>> entry2 : this.groups.entrySet()) {
            retval.format("%n  group[%s]", entry2.getKey());
            int ei = 0;
            for (ENotificationMessage msg : entry2.getValue()) {
                retval.format("%n    event[%2d]%n%s", ei, msg);
                ++ei;
            }
        }
        retval.format("%n%n  User-defined data:", new Object[0]);
        this.userCache.entrySet().forEach(entry -> retval.format("%n    %s=%s", entry.getKey(), entry.getValue()));
        return retval.toString();
    }

    public List<ENotificationMessage> group(String name) {
        return this.groups.get(name);
    }
}

